/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.persistence.InferenceIndexConstants;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextEmbeddingConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.VocabularyConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class TextEmbeddingConfig
implements NlpConfig {
    public static final String NAME = "text_embedding";
    public static final ParseField EMBEDDING_SIZE = new ParseField("embedding_size", new String[0]);
    private static final ConstructingObjectParser<TextEmbeddingConfig, Void> STRICT_PARSER = TextEmbeddingConfig.createParser(false);
    private static final ConstructingObjectParser<TextEmbeddingConfig, Void> LENIENT_PARSER = TextEmbeddingConfig.createParser(true);
    private final VocabularyConfig vocabularyConfig;
    private final Tokenization tokenization;
    private final String resultsField;
    private final Integer embeddingSize;

    public static TextEmbeddingConfig fromXContentStrict(XContentParser parser) {
        return (TextEmbeddingConfig)STRICT_PARSER.apply(parser, null);
    }

    public static TextEmbeddingConfig fromXContentLenient(XContentParser parser) {
        return (TextEmbeddingConfig)LENIENT_PARSER.apply(parser, null);
    }

    private static ConstructingObjectParser<TextEmbeddingConfig, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME, ignoreUnknownFields, a -> TextEmbeddingConfig.create((VocabularyConfig)a[0], (Tokenization)a[1], (String)a[2], (Integer)a[3]));
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> {
            if (!ignoreUnknownFields) {
                throw ExceptionsHelper.badRequestException("illegal setting [{}] on inference model creation", VOCABULARY.getPreferredName());
            }
            return VocabularyConfig.fromXContentLenient(p);
        }, VOCABULARY);
        parser.declareNamedObject(ConstructingObjectParser.optionalConstructorArg(), (p, c, n) -> (Tokenization)p.namedObject(Tokenization.class, n, (Object)ignoreUnknownFields), TOKENIZATION);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), RESULTS_FIELD);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), EMBEDDING_SIZE);
        return parser;
    }

    static TextEmbeddingConfig create(@Nullable VocabularyConfig vocabularyConfig, @Nullable Tokenization tokenization, @Nullable String resultsField, @Nullable Integer embeddingSize) {
        TextEmbeddingConfig config = new TextEmbeddingConfig(Optional.ofNullable(vocabularyConfig).orElse(new VocabularyConfig(InferenceIndexConstants.nativeDefinitionStore())), tokenization == null ? Tokenization.createDefault() : tokenization, resultsField, embeddingSize);
        if (config.embeddingSize != null && config.embeddingSize <= 0) {
            throw ExceptionsHelper.badRequestException("[{}] must be a number greater than 0; configured size [{}]", EMBEDDING_SIZE.getPreferredName(), embeddingSize);
        }
        if (config.tokenization.span != -1) {
            throw ExceptionsHelper.badRequestException("[{}] does not support windowing long text sequences; configured span [{}]", NAME, config.tokenization.span);
        }
        return config;
    }

    private TextEmbeddingConfig(VocabularyConfig vocabularyConfig, Tokenization tokenization, String resultsField, Integer embeddingSize) {
        this.vocabularyConfig = vocabularyConfig;
        this.tokenization = tokenization;
        this.resultsField = resultsField;
        this.embeddingSize = embeddingSize;
    }

    public TextEmbeddingConfig(StreamInput in) throws IOException {
        this.vocabularyConfig = new VocabularyConfig(in);
        this.tokenization = (Tokenization)in.readNamedWriteable(Tokenization.class);
        this.resultsField = in.readOptionalString();
        this.embeddingSize = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0) ? in.readOptionalVInt() : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(VOCABULARY.getPreferredName(), (ToXContent)this.vocabularyConfig, params);
        NamedXContentObjectHelper.writeNamedObject(builder, params, TOKENIZATION.getPreferredName(), this.tokenization);
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (this.embeddingSize != null) {
            builder.field(EMBEDDING_SIZE.getPreferredName(), this.embeddingSize);
        }
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return NAME;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.vocabularyConfig.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.tokenization);
        out.writeOptionalString(this.resultsField);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_8_0)) {
            out.writeOptionalVInt(this.embeddingSize);
        }
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return false;
    }

    @Override
    public InferenceConfig apply(InferenceConfigUpdate update) {
        if (update instanceof TextEmbeddingConfigUpdate) {
            TextEmbeddingConfigUpdate configUpdate = (TextEmbeddingConfigUpdate)update;
            return new TextEmbeddingConfig(this.vocabularyConfig, configUpdate.tokenizationUpdate == null ? this.tokenization : configUpdate.tokenizationUpdate.apply(this.tokenization), configUpdate.getResultsField() == null ? this.resultsField : configUpdate.getResultsField(), this.embeddingSize);
        }
        if (update instanceof TokenizationConfigUpdate) {
            TokenizationConfigUpdate tokenizationUpdate = (TokenizationConfigUpdate)update;
            Tokenization updatedTokenization = this.getTokenization().updateWindowSettings(tokenizationUpdate.getSpanSettings());
            return new TextEmbeddingConfig(this.vocabularyConfig, updatedTokenization, this.resultsField, this.embeddingSize);
        }
        throw this.incompatibleUpdateException(update.getName());
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.V_8_0_0;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return TransportVersions.V_8_0_0;
    }

    @Override
    public boolean isAllocateOnly() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextEmbeddingConfig that = (TextEmbeddingConfig)o;
        return Objects.equals(this.vocabularyConfig, that.vocabularyConfig) && Objects.equals(this.tokenization, that.tokenization) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.embeddingSize, that.embeddingSize);
    }

    public int hashCode() {
        return Objects.hash(this.vocabularyConfig, this.tokenization, this.resultsField, this.embeddingSize);
    }

    @Override
    public VocabularyConfig getVocabularyConfig() {
        return this.vocabularyConfig;
    }

    @Override
    public Tokenization getTokenization() {
        return this.tokenization;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    public Integer getEmbeddingSize() {
        return this.embeddingSize;
    }
}

