/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesMetrics;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.s3.S3ClientSettings;
import org.elasticsearch.repositories.s3.S3RepositoriesMetrics;
import org.elasticsearch.repositories.s3.S3Repository;
import org.elasticsearch.repositories.s3.S3Service;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

public class S3RepositoryPlugin
extends Plugin
implements RepositoryPlugin,
ReloadablePlugin {
    private static final Logger logger = LogManager.getLogger(S3RepositoryPlugin.class);
    private final SetOnce<S3Service> service = new SetOnce();
    private final Settings settings;

    public S3RepositoryPlugin(Settings settings) {
        this.settings = settings;
    }

    S3Service getService() {
        return (S3Service)((Object)this.service.get());
    }

    protected S3Repository createRepository(RepositoryMetadata metadata, NamedXContentRegistry registry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, S3RepositoriesMetrics s3RepositoriesMetrics) {
        return new S3Repository(metadata, registry, (S3Service)((Object)this.service.get()), clusterService, bigArrays, recoverySettings, s3RepositoriesMetrics);
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        this.service.set((Object)this.s3Service(services.environment(), services.clusterService().getSettings(), services.resourceWatcherService()));
        ((S3Service)((Object)this.service.get())).refreshAndClearCache(S3ClientSettings.load(this.settings));
        return List.of((S3Service)((Object)this.service.get()));
    }

    S3Service s3Service(Environment environment, Settings nodeSettings, ResourceWatcherService resourceWatcherService) {
        return new S3Service(environment, nodeSettings, resourceWatcherService, S3RepositoryPlugin::getDefaultRegion);
    }

    private static Region getDefaultRegion() {
        return DefaultAwsRegionProviderChain.builder().build().getRegion();
    }

    public Map<String, Repository.Factory> getRepositories(Environment env, NamedXContentRegistry registry, ClusterService clusterService, BigArrays bigArrays, RecoverySettings recoverySettings, RepositoriesMetrics repositoriesMetrics) {
        S3RepositoriesMetrics s3RepositoriesMetrics = new S3RepositoriesMetrics(repositoriesMetrics);
        return Collections.singletonMap("s3", metadata -> this.createRepository(metadata, registry, clusterService, bigArrays, recoverySettings, s3RepositoriesMetrics));
    }

    public List<Setting<?>> getSettings() {
        return Arrays.asList(S3ClientSettings.ACCESS_KEY_SETTING, S3ClientSettings.SECRET_KEY_SETTING, S3ClientSettings.SESSION_TOKEN_SETTING, S3ClientSettings.ENDPOINT_SETTING, S3ClientSettings.PROTOCOL_SETTING, S3ClientSettings.PROXY_HOST_SETTING, S3ClientSettings.PROXY_PORT_SETTING, S3ClientSettings.PROXY_SCHEME_SETTING, S3ClientSettings.PROXY_USERNAME_SETTING, S3ClientSettings.PROXY_PASSWORD_SETTING, S3ClientSettings.READ_TIMEOUT_SETTING, S3ClientSettings.MAX_CONNECTIONS_SETTING, S3ClientSettings.MAX_RETRIES_SETTING, S3ClientSettings.UNUSED_USE_THROTTLE_RETRIES_SETTING, S3ClientSettings.USE_PATH_STYLE_ACCESS, S3ClientSettings.UNUSED_SIGNER_OVERRIDE, S3ClientSettings.ADD_PURPOSE_CUSTOM_QUERY_PARAMETER, S3ClientSettings.REGION, S3Service.REPOSITORY_S3_CAS_TTL_SETTING, S3Service.REPOSITORY_S3_CAS_ANTI_CONTENTION_DELAY_SETTING, S3Repository.ACCESS_KEY_SETTING, S3Repository.SECRET_KEY_SETTING);
    }

    public void reload(Settings settings) {
        Map<String, S3ClientSettings> clientsSettings = S3ClientSettings.load(settings);
        this.getService().refreshAndClearCache(clientsSettings);
    }

    public void close() throws IOException {
        this.getService().close();
    }
}

