/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivileges;

public final class ResourcePrivilegesMap {
    private final Map<String, ResourcePrivileges> resourceToResourcePrivileges;

    public ResourcePrivilegesMap(Map<String, ResourcePrivileges> resToResPriv) {
        this.resourceToResourcePrivileges = Collections.unmodifiableMap(Objects.requireNonNull(resToResPriv));
    }

    public Map<String, ResourcePrivileges> getResourceToResourcePrivileges() {
        return this.resourceToResourcePrivileges;
    }

    public int hashCode() {
        return Objects.hash(this.resourceToResourcePrivileges);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourcePrivilegesMap other = (ResourcePrivilegesMap)obj;
        return Objects.equals(this.resourceToResourcePrivileges, other.resourceToResourcePrivileges);
    }

    public String toString() {
        return "ResourcePrivilegesMap [resourceToResourcePrivileges=" + String.valueOf(this.resourceToResourcePrivileges) + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Map<String, ResourcePrivileges.Builder> resourceToResourcePrivilegesBuilder = new TreeMap<String, ResourcePrivileges.Builder>();

        public Builder addResourcePrivilege(String resource, String privilege, Boolean allowed) {
            assert (resource != null && privilege != null && allowed != null) : "resource, privilege and permission(allowed or denied) are required";
            ResourcePrivileges.Builder builder = this.resourceToResourcePrivilegesBuilder.computeIfAbsent(resource, ResourcePrivileges::builder);
            builder.addPrivilege(privilege, allowed);
            return this;
        }

        public Builder addResourcePrivilege(String resource, Map<String, Boolean> privilegePermissions) {
            assert (resource != null && privilegePermissions != null) : "resource, privilege permissions(allowed or denied) are required";
            ResourcePrivileges.Builder builder = this.resourceToResourcePrivilegesBuilder.computeIfAbsent(resource, ResourcePrivileges::builder);
            builder.addPrivileges(privilegePermissions);
            return this;
        }

        public Builder addResourcePrivilegesMap(ResourcePrivilegesMap resourcePrivilegesMap) {
            resourcePrivilegesMap.getResourceToResourcePrivileges().forEach((key, value) -> this.addResourcePrivilege((String)key, value.getPrivileges()));
            return this;
        }

        public ResourcePrivilegesMap build() {
            Map<String, ResourcePrivileges> result = this.resourceToResourcePrivilegesBuilder.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((ResourcePrivileges.Builder)e.getValue()).build()));
            return new ResourcePrivilegesMap(result);
        }
    }
}

