/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz;

import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.xpack.core.security.support.Automatons;

public class RestrictedIndices {
    private final Automaton automaton;
    private final Predicate<String> predicate;

    public RestrictedIndices(IndexNameExpressionResolver resolver) {
        this(resolver.getSystemNameAutomaton());
    }

    public RestrictedIndices(Automaton automaton) {
        this.automaton = automaton;
        this.predicate = Automatons.predicate(automaton);
    }

    public boolean isRestricted(String indexOrAliasName) {
        return this.predicate.test(indexOrAliasName);
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }
}

