/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.saml;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.core.Nullable;

public final class SamlInvalidateSessionRequest
extends LegacyActionRequest {
    @Nullable
    private String realmName;
    @Nullable
    private String assertionConsumerServiceURL;
    private String queryString;

    public SamlInvalidateSessionRequest(StreamInput in) throws IOException {
        super(in);
    }

    public SamlInvalidateSessionRequest() {
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty((String)this.queryString)) {
            validationException = ValidateActions.addValidationError((String)"query_string is missing", validationException);
        }
        return validationException;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        if (this.queryString != null) {
            throw new IllegalArgumentException("Must use either [query_string] or [queryString], not both at the same time");
        }
        this.queryString = queryString;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public void setAssertionConsumerServiceURL(String assertionConsumerServiceURL) {
        this.assertionConsumerServiceURL = assertionConsumerServiceURL;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{realmName='" + this.realmName + "', assertionConsumerServiceURL='" + this.assertionConsumerServiceURL + "', url-query=" + this.queryString.length() + " chars}";
    }
}

