/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring;

import java.util.Arrays;
import java.util.Locale;
import java.util.stream.Stream;

public enum MonitoredSystem {
    ES("es"),
    KIBANA("kibana"),
    LOGSTASH("logstash"),
    BEATS("beats"),
    UNKNOWN("unknown");

    private final String system;

    private MonitoredSystem(String system) {
        this.system = system;
    }

    public String getSystem() {
        return this.system;
    }

    public static MonitoredSystem fromSystem(String system) {
        return switch (system.toLowerCase(Locale.ROOT)) {
            case "es" -> ES;
            case "kibana" -> KIBANA;
            case "logstash" -> LOGSTASH;
            case "beats" -> BEATS;
            default -> UNKNOWN;
        };
    }

    public static Stream<MonitoredSystem> allSystems() {
        return Arrays.stream(MonitoredSystem.values()).filter(s -> s != UNKNOWN);
    }
}

