/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.assignment;

import java.util.List;
import java.util.Optional;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.xpack.core.ml.inference.ModelAliasMetadata;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingInfo;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingInfoUpdate;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingStateAndReason;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;

public class TrainedModelAssignmentUtils {
    public static final String NODES_CHANGED_REASON = "nodes changed";
    public static final String NODE_IS_SHUTTING_DOWN = "node is shutting down";

    public static RoutingInfo createShuttingDownRoute(RoutingInfo existingRoute) {
        RoutingInfoUpdate routeUpdate = RoutingInfoUpdate.updateStateAndReason(new RoutingStateAndReason(RoutingState.STOPPING, NODE_IS_SHUTTING_DOWN));
        return routeUpdate.apply(existingRoute);
    }

    public static List<TrainedModelAssignment> modelAssignments(String modelId, ClusterState state) {
        String concreteModelId = Optional.ofNullable(ModelAliasMetadata.fromState(state).getModelId(modelId)).orElse(modelId);
        TrainedModelAssignmentMetadata trainedModelAssignmentMetadata = TrainedModelAssignmentMetadata.fromState(state);
        TrainedModelAssignment assignment = trainedModelAssignmentMetadata.getDeploymentAssignment(concreteModelId);
        List<TrainedModelAssignment> assignments = assignment != null ? List.of(assignment) : trainedModelAssignmentMetadata.getDeploymentsUsingModel(concreteModelId);
        return assignments;
    }

    private TrainedModelAssignmentUtils() {
    }
}

