/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.Index;

public class LifecycleExecutionStateUtils {
    private LifecycleExecutionStateUtils() {
    }

    public static ClusterState newClusterStateWithLifecycleState(ClusterState clusterState, Index index, LifecycleExecutionState lifecycleState) {
        Objects.requireNonNull(clusterState, "clusterState must not be null");
        Objects.requireNonNull(index, "index must not be null");
        Objects.requireNonNull(lifecycleState, "lifecycleState must not be null");
        Metadata metadata = clusterState.metadata().withLifecycleState(index, lifecycleState);
        if (metadata == clusterState.metadata()) {
            return clusterState;
        }
        return ClusterState.builder((ClusterState)clusterState).metadata(metadata).build();
    }
}

