/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncTask;

public abstract class StoredAsyncTask<Response extends ActionResponse>
extends CancellableTask
implements AsyncTask {
    private final AsyncExecutionId asyncExecutionId;
    private final Map<String, String> originHeaders;
    private volatile long expirationTimeMillis;
    protected final List<ActionListener<Response>> completionListeners;
    private boolean hasCompleted = false;

    public StoredAsyncTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, Map<String, String> originHeaders, AsyncExecutionId asyncExecutionId, TimeValue keepAlive) {
        super(id, type, action, description, parentTaskId, headers);
        this.asyncExecutionId = asyncExecutionId;
        this.originHeaders = originHeaders;
        this.expirationTimeMillis = this.getStartTime() + keepAlive.getMillis();
        this.completionListeners = new ArrayList<ActionListener<Response>>();
    }

    @Override
    public Map<String, String> getOriginHeaders() {
        return this.originHeaders;
    }

    @Override
    public AsyncExecutionId getExecutionId() {
        return this.asyncExecutionId;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.expirationTimeMillis = expirationTime;
    }

    public long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }

    public synchronized boolean addCompletionListener(Supplier<ActionListener<Response>> listenerSupplier) {
        if (this.hasCompleted) {
            return false;
        }
        this.completionListeners.add(listenerSupplier.get());
        return true;
    }

    public synchronized void removeCompletionListener(ActionListener<Response> listener) {
        this.completionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Response response) {
        ArrayList<ActionListener<Response>> completionListenersCopy;
        StoredAsyncTask storedAsyncTask = this;
        synchronized (storedAsyncTask) {
            assert (!this.hasCompleted);
            this.hasCompleted = true;
            completionListenersCopy = new ArrayList<ActionListener<Response>>(this.completionListeners);
            this.completionListeners.clear();
        }
        for (ActionListener actionListener : completionListenersCopy) {
            response.incRef();
            ActionListener.respondAndRelease((ActionListener)actionListener, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(Exception e) {
        ArrayList<ActionListener<Response>> completionListenersCopy;
        StoredAsyncTask storedAsyncTask = this;
        synchronized (storedAsyncTask) {
            assert (!this.hasCompleted);
            this.hasCompleted = true;
            completionListenersCopy = new ArrayList<ActionListener<Response>>(this.completionListeners);
            this.completionListeners.clear();
        }
        for (ActionListener actionListener : completionListenersCopy) {
            actionListener.onFailure(e);
        }
    }

    public abstract Response getCurrentResult();

    @Override
    public void cancelTask(TaskManager taskManager, Runnable runnable, String reason) {
        taskManager.cancelTaskAndDescendants((CancellableTask)this, reason, true, ActionListener.running((Runnable)runnable));
    }
}

