/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import java.time.OffsetDateTime;

public class AccessToken {
    private final String token;
    private final OffsetDateTime expiresAt;
    private final OffsetDateTime refreshAt;

    public AccessToken(String token, OffsetDateTime expiresAt) {
        this.token = token;
        this.expiresAt = expiresAt;
        this.refreshAt = null;
    }

    public AccessToken(String token, OffsetDateTime expiresAt, OffsetDateTime refreshAt) {
        this.token = token;
        this.expiresAt = expiresAt;
        this.refreshAt = refreshAt;
    }

    public String getToken() {
        return this.token;
    }

    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    public OffsetDateTime getRefreshAt() {
        return this.refreshAt;
    }

    public boolean isExpired() {
        return OffsetDateTime.now().isAfter(this.expiresAt);
    }
}

