/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.rankeval;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.rankeval.EvalQueryQuality;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RankEvalResponse
extends ActionResponse
implements ToXContentObject {
    private final double metricScore;
    private final Map<String, EvalQueryQuality> details;
    private final Map<String, Exception> failures;

    public RankEvalResponse(double metricScore, Map<String, EvalQueryQuality> partialResults, Map<String, Exception> failures) {
        this.metricScore = metricScore;
        this.details = new HashMap<String, EvalQueryQuality>(partialResults);
        this.failures = new HashMap<String, Exception>(failures);
    }

    RankEvalResponse(StreamInput in) throws IOException {
        super(in);
        this.metricScore = in.readDouble();
        int partialResultSize = in.readVInt();
        this.details = Maps.newMapWithExpectedSize((int)partialResultSize);
        for (int i = 0; i < partialResultSize; ++i) {
            String queryId = in.readString();
            EvalQueryQuality partial = new EvalQueryQuality(in);
            this.details.put(queryId, partial);
        }
        int failuresSize = in.readVInt();
        this.failures = Maps.newMapWithExpectedSize((int)failuresSize);
        for (int i = 0; i < failuresSize; ++i) {
            String queryId = in.readString();
            this.failures.put(queryId, in.readException());
        }
    }

    public double getMetricScore() {
        return this.metricScore;
    }

    public Map<String, EvalQueryQuality> getPartialResults() {
        return Collections.unmodifiableMap(this.details);
    }

    public Map<String, Exception> getFailures() {
        return Collections.unmodifiableMap(this.failures);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(this.metricScore);
        out.writeMap(this.details, StreamOutput::writeWriteable);
        out.writeMap(this.failures, StreamOutput::writeException);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("metric_score", this.metricScore);
        builder.startObject("details");
        for (String key : this.details.keySet()) {
            this.details.get(key).toXContent(builder, params);
        }
        builder.endObject();
        builder.startObject("failures");
        for (String key : this.failures.keySet()) {
            builder.startObject(key);
            ElasticsearchException.generateFailureXContent((XContentBuilder)builder, (ToXContent.Params)params, (Exception)this.failures.get(key), (boolean)true);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

