/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.notifications;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessage;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditMessageFactory;
import org.elasticsearch.xpack.core.common.notifications.AbstractAuditor;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.ml.MlIndexTemplateRegistry;

abstract class AbstractMlAuditor<T extends AbstractAuditMessage>
extends AbstractAuditor<T> {
    private static final Logger logger = LogManager.getLogger(AbstractMlAuditor.class);
    private volatile boolean isResetMode;

    protected AbstractMlAuditor(Client client, AbstractAuditMessageFactory<T> messageFactory, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(new OriginSettingClient(client, "ml"), ".ml-notifications-write", clusterService.getNodeName(), messageFactory, clusterService, indexNameExpressionResolver, clusterService.threadPool().generic());
        clusterService.addListener(event -> {
            if (event.metadataChanged()) {
                this.setResetMode(MlMetadata.getMlMetadata((ClusterState)event.state()).isResetMode());
            }
        });
    }

    private void setResetMode(boolean value) {
        this.isResetMode = value;
    }

    protected void indexDoc(ToXContent toXContent) {
        if (this.isResetMode) {
            logger.trace("Skipped writing the audit message backlog as reset_mode is enabled");
        } else {
            super.indexDoc(toXContent);
        }
    }

    protected void writeBacklog() {
        if (this.isResetMode) {
            logger.trace("Skipped writing the audit message backlog as reset_mode is enabled");
            this.clearBacklog();
        } else {
            super.writeBacklog();
        }
    }

    protected TransportPutComposableIndexTemplateAction.Request putTemplateRequest() {
        TransportPutComposableIndexTemplateAction.Request request;
        block8: {
            IndexTemplateConfig templateConfig = MlIndexTemplateRegistry.NOTIFICATIONS_TEMPLATE;
            XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, MlIndexTemplateRegistry.NOTIFICATIONS_TEMPLATE.loadBytes());
            try {
                request = (TransportPutComposableIndexTemplateAction.Request)new TransportPutComposableIndexTemplateAction.Request(templateConfig.getTemplateName()).indexTemplate(ComposableIndexTemplate.parse((XContentParser)parser)).masterNodeTimeout(MASTER_TIMEOUT);
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchParseException("unable to parse composable template " + templateConfig.getTemplateName(), (Throwable)e, new Object[0]);
                }
            }
            parser.close();
        }
        return request;
    }

    protected int templateVersion() {
        return MlIndexTemplateRegistry.NOTIFICATIONS_TEMPLATE.getVersion();
    }

    protected AbstractAuditor.IndexDetails indexDetails() {
        return new AbstractAuditor.IndexDetails(".ml-notifications-", "000002");
    }
}

