/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;
import org.elasticsearch.xpack.core.ml.calendars.ScheduledEvent;
import org.elasticsearch.xpack.ml.utils.QueryBuilderHelper;

public class ScheduledEventsQueryBuilder {
    public static final int DEFAULT_SIZE = 1000;
    private Integer from = 0;
    private Integer size = 1000;
    private String[] calendarIds;
    private String start;
    private String end;

    public static ScheduledEventsQueryBuilder builder() {
        return new ScheduledEventsQueryBuilder();
    }

    public ScheduledEventsQueryBuilder calendarIds(String[] calendarIds) {
        this.calendarIds = calendarIds;
        return this;
    }

    public ScheduledEventsQueryBuilder start(String start) {
        this.start = start;
        return this;
    }

    public ScheduledEventsQueryBuilder start(long start) {
        this.start = Long.toString(start);
        return this;
    }

    public ScheduledEventsQueryBuilder end(String end) {
        this.end = end;
        return this;
    }

    public ScheduledEventsQueryBuilder from(Integer from) {
        this.from = from;
        return this;
    }

    public ScheduledEventsQueryBuilder size(Integer size) {
        this.size = size;
        return this;
    }

    public SearchSourceBuilder build() {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)ScheduledEvent.TYPE.getPreferredName(), (String)"scheduled_event"));
        if (this.start != null) {
            RangeQueryBuilder startQuery = QueryBuilders.rangeQuery((String)ScheduledEvent.END_TIME.getPreferredName());
            startQuery.gt((Object)this.start);
            boolQueryBuilder.filter((QueryBuilder)startQuery);
        }
        if (this.end != null) {
            RangeQueryBuilder endQuery = QueryBuilders.rangeQuery((String)ScheduledEvent.START_TIME.getPreferredName());
            endQuery.lt((Object)this.end);
            boolQueryBuilder.filter((QueryBuilder)endQuery);
        }
        QueryBuilderHelper.buildTokenFilterQuery(Calendar.ID.getPreferredName(), this.calendarIds).ifPresent(arg_0 -> ((BoolQueryBuilder)boolQueryBuilder).filter(arg_0));
        SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().sort(ScheduledEvent.START_TIME.getPreferredName()).sort(ScheduledEvent.DESCRIPTION.getPreferredName()).query((QueryBuilder)boolQueryBuilder);
        if (this.from != null) {
            searchSourceBuilder.from(this.from.intValue());
        }
        if (this.size != null) {
            searchSourceBuilder.size(this.size.intValue());
        }
        return searchSourceBuilder;
    }
}

