/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.annotations;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ml.annotations.Annotation;
import org.elasticsearch.xpack.ml.utils.persistence.ResultsPersisterService;

public class AnnotationPersister {
    private static final Logger logger = LogManager.getLogger(AnnotationPersister.class);
    private static final int DEFAULT_BULK_LIMIT = 10000;
    private final ResultsPersisterService resultsPersisterService;
    private final int bulkLimit;

    public AnnotationPersister(ResultsPersisterService resultsPersisterService) {
        this(resultsPersisterService, 10000);
    }

    AnnotationPersister(ResultsPersisterService resultsPersisterService, int bulkLimit) {
        this.resultsPersisterService = Objects.requireNonNull(resultsPersisterService);
        this.bulkLimit = bulkLimit;
    }

    public Tuple<String, Annotation> persistAnnotation(@Nullable String annotationId, Annotation annotation) {
        Objects.requireNonNull(annotation);
        String jobId = annotation.getJobId();
        BulkResponse bulkResponse = this.bulkPersisterBuilder(jobId).persistAnnotation(annotationId, annotation).executeRequest();
        assert (bulkResponse.getItems().length == 1);
        return Tuple.tuple((Object)bulkResponse.getItems()[0].getId(), (Object)annotation);
    }

    public Builder bulkPersisterBuilder(String jobId) {
        return new Builder(jobId, () -> true);
    }

    public Builder bulkPersisterBuilder(String jobId, Supplier<Boolean> shouldRetry) {
        return new Builder(jobId, shouldRetry);
    }

    public class Builder {
        private final String jobId;
        private BulkRequest bulkRequest = new BulkRequest(".ml-annotations-write");
        private final Supplier<Boolean> shouldRetry;

        private Builder(String jobId, Supplier<Boolean> shouldRetry) {
            this.jobId = Objects.requireNonNull(jobId);
            this.shouldRetry = Objects.requireNonNull(shouldRetry);
        }

        public Builder persistAnnotation(Annotation annotation) {
            return this.persistAnnotation(null, annotation);
        }

        public Builder persistAnnotation(@Nullable String annotationId, Annotation annotation) {
            Objects.requireNonNull(annotation);
            try (XContentBuilder xContentBuilder = annotation.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS);){
                this.bulkRequest.add(new IndexRequest().id(annotationId).source(xContentBuilder).setRequireAlias(true));
            }
            catch (IOException e) {
                logger.error(() -> "[" + this.jobId + "] Error serialising annotation", (Throwable)e);
            }
            if (this.bulkRequest.numberOfActions() >= AnnotationPersister.this.bulkLimit) {
                this.executeRequest();
            }
            return this;
        }

        public BulkResponse executeRequest() {
            if (this.bulkRequest.numberOfActions() == 0) {
                return null;
            }
            logger.trace("[{}] ES API CALL: bulk request with {} actions", new org.apache.logging.log4j.util.Supplier[]{() -> this.jobId, () -> this.bulkRequest.numberOfActions()});
            BulkResponse bulkResponse = AnnotationPersister.this.resultsPersisterService.bulkIndexWithRetry(this.bulkRequest, this.jobId, this.shouldRetry, retryMessage -> logger.debug("[{}] Bulk indexing of annotations failed {}", (Object)this.jobId, retryMessage));
            this.bulkRequest = new BulkRequest(".ml-annotations-write");
            return bulkResponse;
        }
    }
}

