/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs.frequentitemsets;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;

class ItemSetBitSet
implements Cloneable {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private static final long WORD_MASK = -1L;
    long[] words;
    transient int wordsInUse = 0;
    private int cardinality = 0;

    ItemSetBitSet() {
        this.initWords(64);
    }

    ItemSetBitSet(int nbits) {
        if (nbits < 0) {
            throw new NegativeArraySizeException("nbits < 0: " + nbits);
        }
        this.initWords(nbits);
    }

    void reset(ItemSetBitSet bitSet) {
        this.words = ArrayUtil.grow((long[])this.words, (int)bitSet.wordsInUse);
        System.arraycopy(bitSet.words, 0, this.words, 0, bitSet.wordsInUse);
        this.cardinality = bitSet.cardinality;
        this.wordsInUse = bitSet.wordsInUse;
    }

    void set(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = ItemSetBitSet.wordIndex(bitIndex);
        this.expandTo(wordIndex);
        long oldWord = this.words[wordIndex];
        int n = wordIndex;
        this.words[n] = this.words[n] | 1L << bitIndex;
        if (oldWord != this.words[wordIndex]) {
            ++this.cardinality;
        }
    }

    boolean get(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = ItemSetBitSet.wordIndex(bitIndex);
        return wordIndex < this.wordsInUse && (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    void clear(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        int wordIndex = ItemSetBitSet.wordIndex(bitIndex);
        if (wordIndex >= this.wordsInUse) {
            return;
        }
        long oldWord = this.words[wordIndex];
        int n = wordIndex;
        this.words[n] = this.words[n] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
        if (oldWord != this.words[wordIndex]) {
            --this.cardinality;
        }
        this.recalculateWordsInUse();
    }

    public void clear() {
        while (this.wordsInUse > 0) {
            this.words[--this.wordsInUse] = 0L;
        }
        this.cardinality = 0;
    }

    boolean isSubset(ItemSetBitSet set) {
        if (this.wordsInUse > set.wordsInUse) {
            return false;
        }
        for (int i = this.wordsInUse - 1; i >= 0; --i) {
            if ((this.words[i] & set.words[i]) == this.words[i]) continue;
            return false;
        }
        return true;
    }

    public SetRelation setRelation(ItemSetBitSet set) {
        if (this.wordsInUse > set.wordsInUse || this.cardinality > set.cardinality) {
            for (int i = set.wordsInUse - 1; i >= 0; --i) {
                if ((set.words[i] & this.words[i]) == set.words[i]) continue;
                return SetRelation.DISJOINT_OR_INTERSECT;
            }
            return SetRelation.SUPER_SET;
        }
        if (this.wordsInUse < set.wordsInUse || this.cardinality < set.cardinality) {
            for (int i = this.wordsInUse - 1; i >= 0; --i) {
                if ((this.words[i] & set.words[i]) == this.words[i]) continue;
                return SetRelation.DISJOINT_OR_INTERSECT;
            }
            return SetRelation.SUB_SET;
        }
        for (int i = this.wordsInUse - 1; i >= 0; --i) {
            if ((this.words[i] & set.words[i]) == this.words[i]) continue;
            return SetRelation.DISJOINT_OR_INTERSECT;
        }
        return SetRelation.EQUAL;
    }

    int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + fromIndex);
        }
        int u = ItemSetBitSet.wordIndex(fromIndex);
        if (u >= this.wordsInUse) {
            return -1;
        }
        long word = this.words[u] & -1L << fromIndex;
        while (word == 0L) {
            if (++u == this.wordsInUse) {
                return -1;
            }
            word = this.words[u];
        }
        return u * 64 + Long.numberOfTrailingZeros(word);
    }

    int cardinality() {
        return this.cardinality;
    }

    public static int compare(ItemSetBitSet a, ItemSetBitSet b) {
        if (a.cardinality != b.cardinality) {
            return a.cardinality > b.cardinality ? 1 : -1;
        }
        if (a.wordsInUse != b.wordsInUse) {
            return a.wordsInUse < b.wordsInUse ? 1 : -1;
        }
        int i = Arrays.mismatch(a.words, 0, a.wordsInUse, b.words, 0, b.wordsInUse);
        if (i == -1) {
            return 0;
        }
        return a.words[i] < b.words[i] ? 1 : -1;
    }

    public Object clone() {
        this.trimToSize();
        try {
            ItemSetBitSet result = (ItemSetBitSet)super.clone();
            result.words = (long[])this.words.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    public String toString() {
        int MAX_INITIAL_CAPACITY = 0x7FFFFFF7;
        int numBits = this.wordsInUse * 64;
        int initialCapacity = numBits <= 0x15555553 ? 6 * numBits + 2 : 0x7FFFFFF7;
        StringBuilder b = new StringBuilder(initialCapacity);
        for (int i = 0; i < this.wordsInUse; ++i) {
            b.append(this.words[i]);
            b.append(" ");
        }
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ItemSetBitSet set = (ItemSetBitSet)obj;
        if (this.wordsInUse != set.wordsInUse) {
            return false;
        }
        for (int i = 0; i < this.wordsInUse; ++i) {
            if (this.words[i] == set.words[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.wordsInUse; ++i) {
            int elementHash = (int)(this.words[i] ^ this.words[i] >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }

    private void trimToSize() {
        if (this.wordsInUse != this.words.length) {
            this.words = Arrays.copyOf(this.words, this.wordsInUse);
        }
    }

    private void initWords(int nbits) {
        this.words = new long[ItemSetBitSet.wordIndex(nbits - 1) + 1];
    }

    private void recalculateWordsInUse() {
        int i;
        for (i = this.wordsInUse - 1; i >= 0 && this.words[i] == 0L; --i) {
        }
        this.wordsInUse = i + 1;
    }

    private void expandTo(int wordIndex) {
        int wordsRequired = wordIndex + 1;
        if (this.wordsInUse < wordsRequired) {
            this.words = ArrayUtil.grow((long[])this.words, (int)wordsRequired);
            this.wordsInUse = wordsRequired;
        }
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    public static enum SetRelation {
        DISJOINT_OR_INTERSECT,
        SUB_SET,
        SUPER_SET,
        EQUAL;

    }
}

