/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.TransportTasksAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Strings;
import org.elasticsearch.discovery.MasterNotDiscoveredException;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.inference.action.GetInferenceModelAction;
import org.elasticsearch.xpack.core.ml.action.StopTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignment;
import org.elasticsearch.xpack.core.ml.inference.assignment.TrainedModelAssignmentMetadata;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.InferenceProcessorInfoExtractor;
import org.elasticsearch.xpack.ml.action.TransportDeleteTrainedModelAction;
import org.elasticsearch.xpack.ml.inference.assignment.TrainedModelAssignmentClusterService;
import org.elasticsearch.xpack.ml.inference.deployment.TrainedModelDeploymentTask;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportStopTrainedModelDeploymentAction
extends TransportTasksAction<TrainedModelDeploymentTask, StopTrainedModelDeploymentAction.Request, StopTrainedModelDeploymentAction.Response, StopTrainedModelDeploymentAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStopTrainedModelDeploymentAction.class);
    private final OriginSettingClient client;
    private final TrainedModelAssignmentClusterService trainedModelAssignmentClusterService;
    private final InferenceAuditor auditor;

    @Inject
    public TransportStopTrainedModelDeploymentAction(ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Client client, TrainedModelAssignmentClusterService trainedModelAssignmentClusterService, InferenceAuditor auditor) {
        super("cluster:admin/xpack/ml/trained_models/deployment/stop", clusterService, transportService, actionFilters, StopTrainedModelDeploymentAction.Request::new, StopTrainedModelDeploymentAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = new OriginSettingClient(client, "ml");
        this.trainedModelAssignmentClusterService = trainedModelAssignmentClusterService;
        this.auditor = Objects.requireNonNull(auditor);
    }

    protected void doExecute(Task task, StopTrainedModelDeploymentAction.Request request, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        DiscoveryNodes nodes = state.nodes();
        if (!nodes.isLocalNodeElectedMaster()) {
            this.redirectToMasterNode(nodes.getMasterNode(), request, listener);
            return;
        }
        logger.debug(() -> Strings.format((String)"[%s] Received request to undeploy%s", (Object[])new Object[]{request.getId(), request.isForce() ? " (force)" : ""}));
        Optional maybeAssignment = TrainedModelAssignmentMetadata.assignmentForDeploymentId((ClusterState)this.clusterService.state(), (String)request.getId());
        if (maybeAssignment.isEmpty()) {
            if (!request.isAllowNoMatch()) {
                listener.onFailure((Exception)ExceptionsHelper.missingModelDeployment((String)request.getId()));
            } else {
                listener.onResponse((Object)new StopTrainedModelDeploymentAction.Response(true));
            }
            return;
        }
        IngestMetadata currentIngestMetadata = (IngestMetadata)state.metadata().custom("ingest");
        Set referencedModels = InferenceProcessorInfoExtractor.getModelIdsFromInferenceProcessors((IngestMetadata)currentIngestMetadata);
        if (!request.isForce()) {
            if (referencedModels.contains(request.getId())) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Cannot stop deployment [{}] as it is referenced by ingest processors; use force to stop the deployment", RestStatus.CONFLICT, new Object[]{request.getId()}));
                return;
            }
            List<String> modelAliases = TransportDeleteTrainedModelAction.getModelAliases(state, request.getId());
            Optional<String> referencedModelAlias = modelAliases.stream().filter(referencedModels::contains).findFirst();
            if (referencedModelAlias.isPresent()) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Cannot stop deployment [{}] as it has a model_alias [{}] that is still referenced by ingest processors; use force to stop the deployment", RestStatus.CONFLICT, new Object[]{request.getId(), referencedModelAlias.get()}));
                return;
            }
        }
        assert (this.clusterService.localNode().isMasterNode());
        if (!request.isForce()) {
            this.checkIfUsedByInferenceEndpoint(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(canStop -> this.stopDeployment(task, request, (TrainedModelAssignment)maybeAssignment.get(), listener), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.stopDeployment(task, request, (TrainedModelAssignment)maybeAssignment.get(), listener);
        }
    }

    private void stopDeployment(Task task, StopTrainedModelDeploymentAction.Request request, TrainedModelAssignment assignment, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        this.trainedModelAssignmentClusterService.setModelAssignmentToStopping(request.getId(), (ActionListener<AcknowledgedResponse>)ActionListener.wrap(setToStopping -> this.normalUndeploy(task, request.getId(), assignment, request, listener), failure -> {
            if (ExceptionsHelper.unwrapCause((Throwable)failure) instanceof ResourceNotFoundException) {
                listener.onResponse((Object)new StopTrainedModelDeploymentAction.Response(true));
                return;
            }
            listener.onFailure(failure);
        }));
    }

    private void checkIfUsedByInferenceEndpoint(String deploymentId, ActionListener<Boolean> listener) {
        GetInferenceModelAction.Request getAllEndpoints = new GetInferenceModelAction.Request("*", TaskType.ANY);
        this.client.execute((ActionType)GetInferenceModelAction.INSTANCE, (ActionRequest)getAllEndpoints, listener.delegateFailureAndWrap((l, response) -> {
            List<ModelConfigurations> mlNodeEndpoints = response.getEndpoints().stream().filter(model -> model.getService().equals("elasticsearch") || model.getService().equals("elser")).toList();
            Optional<ModelConfigurations> endpointOwnsDeployment = mlNodeEndpoints.stream().filter(model -> model.getInferenceEntityId().equals(deploymentId)).findFirst();
            if (endpointOwnsDeployment.isPresent()) {
                l.onFailure((Exception)new ElasticsearchStatusException("Cannot stop deployment [{}] as it was created by inference endpoint [{}]", RestStatus.CONFLICT, new Object[]{deploymentId, endpointOwnsDeployment.get().getInferenceEntityId()}));
                return;
            }
            for (ModelConfigurations endpoint : mlNodeEndpoints) {
                BytesReference serviceSettingsXContent = XContentHelper.toXContent((ToXContent)endpoint.getServiceSettings(), (XContentType)XContentType.JSON, (boolean)false);
                Map settingsMap = (Map)XContentHelper.convertToMap((BytesReference)serviceSettingsXContent, (boolean)false, (XContentType)XContentType.JSON).v2();
                String deploymentIdFromSettings = (String)settingsMap.get("deployment_id");
                if (deploymentIdFromSettings == null || !deploymentIdFromSettings.equals(deploymentId)) continue;
                l.onFailure((Exception)new ElasticsearchStatusException("Cannot stop deployment [{}] as it is used by inference endpoint [{}]", RestStatus.CONFLICT, new Object[]{deploymentId, endpoint.getInferenceEntityId()}));
                return;
            }
            l.onResponse((Object)true);
        }));
    }

    private void redirectToMasterNode(DiscoveryNode masterNode, StopTrainedModelDeploymentAction.Request request, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        if (masterNode == null) {
            listener.onFailure((Exception)new MasterNotDiscoveredException());
        } else {
            this.transportService.sendRequest(masterNode, this.actionName, (TransportRequest)request, (TransportResponseHandler)new ActionListenerResponseHandler(listener, StopTrainedModelDeploymentAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
        }
    }

    private void normalUndeploy(Task task, String modelId, TrainedModelAssignment modelAssignment, StopTrainedModelDeploymentAction.Request request, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        request.setNodes((String[])modelAssignment.getNodeRoutingTable().keySet().toArray(String[]::new));
        ActionListener finalListener = ActionListener.wrap(r -> {
            assert (this.clusterService.localNode().isMasterNode());
            this.trainedModelAssignmentClusterService.removeModelAssignment(modelId, (ActionListener<AcknowledgedResponse>)ActionListener.wrap(deleted -> {
                this.auditor.info(modelId, "Stopped deployment");
                listener.onResponse(r);
            }, deletionFailed -> {
                logger.error(() -> Strings.format((String)"[%s] failed to delete model assignment after nodes unallocated the deployment", (Object[])new Object[]{modelId}), (Throwable)deletionFailed);
                listener.onFailure((Exception)((Object)ExceptionsHelper.serverError((String)"failed to delete model assignment after nodes unallocated the deployment. Attempt to stop again", (Throwable)deletionFailed)));
            }));
        }, e -> {
            if (ExceptionsHelper.unwrapCause((Throwable)e) instanceof FailedNodeException) {
                this.doExecute(task, request, listener);
            } else {
                listener.onFailure(e);
            }
        });
        super.doExecute(task, (BaseTasksRequest)request, finalListener);
    }

    protected StopTrainedModelDeploymentAction.Response newResponse(StopTrainedModelDeploymentAction.Request request, List<StopTrainedModelDeploymentAction.Response> tasks, List<TaskOperationFailure> taskOperationFailures, List<FailedNodeException> failedNodeExceptions) {
        if (!taskOperationFailures.isEmpty()) {
            throw ExceptionsHelper.taskOperationFailureToStatusException((TaskOperationFailure)taskOperationFailures.get(0));
        }
        if (!failedNodeExceptions.isEmpty()) {
            throw failedNodeExceptions.get(0);
        }
        return new StopTrainedModelDeploymentAction.Response(true);
    }

    protected void taskOperation(CancellableTask actionTask, StopTrainedModelDeploymentAction.Request request, TrainedModelDeploymentTask task, ActionListener<StopTrainedModelDeploymentAction.Response> listener) {
        task.stop("undeploy_trained_model (api)", request.shouldFinishPendingWork(), (ActionListener<AcknowledgedResponse>)ActionListener.wrap(r -> listener.onResponse((Object)new StopTrainedModelDeploymentAction.Response(true)), arg_0 -> listener.onFailure(arg_0)));
    }
}

