/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.useragent;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ingest.useragent.UserAgentParser;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class DeviceTypeParser {
    private static final String OS_PARSERS = "os_parsers";
    private static final String BROWSER_PARSER = "browser_parsers";
    private static final String DEVICE_PARSER = "device_parsers";
    private static final String AGENT_STRING_PARSER = "agent_string_parsers";
    private static final String robot = "Robot";
    private static final String tablet = "Tablet";
    private static final String desktop = "Desktop";
    private static final String phone = "Phone";
    private final List<String> patternListKeys = List.of("os_parsers", "browser_parsers", "device_parsers", "agent_string_parsers");
    private final HashMap<String, ArrayList<DeviceTypeSubPattern>> deviceTypePatterns = new HashMap();

    public void init(InputStream regexStream) throws IOException {
        try (XContentParser yamlParser = XContentFactory.xContent((XContentType)XContentType.YAML).createParser(XContentParserConfiguration.EMPTY, regexStream);){
            XContentParser.Token token = yamlParser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                token = yamlParser.nextToken();
                while (token != null) {
                    String currentName = yamlParser.currentName();
                    if (token == XContentParser.Token.FIELD_NAME && this.patternListKeys.contains(currentName)) {
                        List<Map<String, String>> parserConfigurations = UserAgentParser.readParserConfigurations(yamlParser);
                        ArrayList<DeviceTypeSubPattern> subPatterns = new ArrayList<DeviceTypeSubPattern>();
                        for (Map<String, String> map : parserConfigurations) {
                            subPatterns.add(new DeviceTypeSubPattern(Pattern.compile(map.get("regex")), map.get("replacement")));
                        }
                        this.deviceTypePatterns.put(currentName, subPatterns);
                    }
                    token = yamlParser.nextToken();
                }
            }
        }
        if (this.patternListKeys.size() != this.deviceTypePatterns.size()) {
            throw new ElasticsearchParseException("not a valid regular expression file", new Object[0]);
        }
    }

    public String findDeviceType(String agentString, UserAgentParser.VersionedName userAgent, UserAgentParser.VersionedName os, UserAgentParser.VersionedName device) {
        String deviceType;
        if (this.deviceTypePatterns.isEmpty()) {
            return null;
        }
        if (agentString != null && (deviceType = DeviceTypeParser.findMatch((List<DeviceTypeSubPattern>)this.deviceTypePatterns.get(AGENT_STRING_PARSER), agentString)) != null) {
            return deviceType;
        }
        return this.findDeviceType(userAgent, os, device);
    }

    public String findDeviceType(UserAgentParser.VersionedName userAgent, UserAgentParser.VersionedName os, UserAgentParser.VersionedName device) {
        if (this.deviceTypePatterns.isEmpty()) {
            return null;
        }
        ArrayList<String> extractedDeviceTypes = new ArrayList<String>();
        for (String patternKey : this.patternListKeys) {
            String deviceType = null;
            switch (patternKey) {
                case "os_parsers": {
                    if (os == null || os.name() == null) break;
                    deviceType = DeviceTypeParser.findMatch((List<DeviceTypeSubPattern>)this.deviceTypePatterns.get(patternKey), os.name());
                    break;
                }
                case "browser_parsers": {
                    if (userAgent == null || userAgent.name() == null) break;
                    deviceType = DeviceTypeParser.findMatch((List<DeviceTypeSubPattern>)this.deviceTypePatterns.get(patternKey), userAgent.name());
                    break;
                }
                case "device_parsers": {
                    if (device == null || device.name() == null) break;
                    deviceType = DeviceTypeParser.findMatch((List<DeviceTypeSubPattern>)this.deviceTypePatterns.get(patternKey), device.name());
                    break;
                }
            }
            if (deviceType == null) continue;
            extractedDeviceTypes.add(deviceType);
        }
        if (extractedDeviceTypes.contains(robot)) {
            return robot;
        }
        if (extractedDeviceTypes.contains(tablet)) {
            return tablet;
        }
        if (extractedDeviceTypes.contains(phone)) {
            return phone;
        }
        if (extractedDeviceTypes.contains(desktop)) {
            return desktop;
        }
        return "Other";
    }

    private static String findMatch(List<DeviceTypeSubPattern> possiblePatterns, String matchString) {
        for (DeviceTypeSubPattern pattern : possiblePatterns) {
            String name = pattern.match(matchString);
            if (name == null) continue;
            return name;
        }
        return null;
    }

    static final class DeviceTypeSubPattern {
        private final Pattern pattern;
        private final String nameReplacement;

        DeviceTypeSubPattern(Pattern pattern, String nameReplacement) {
            this.pattern = pattern;
            this.nameReplacement = nameReplacement;
        }

        public String match(String matchString) {
            String name = null;
            Matcher matcher = this.pattern.matcher(matchString);
            if (!matcher.find()) {
                return null;
            }
            int groupCount = matcher.groupCount();
            if (this.nameReplacement != null) {
                name = this.nameReplacement.contains("$1") && groupCount >= 1 && matcher.group(1) != null ? this.nameReplacement.replaceFirst("\\$1", Matcher.quoteReplacement(matcher.group(1))) : this.nameReplacement;
            }
            return name;
        }
    }
}

