/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class ReindexDataStreamIndexAction
extends ActionType<Response> {
    public static final String NAME = "indices:admin/data_stream/index/reindex";
    public static final ActionType<Response> INSTANCE = new ReindexDataStreamIndexAction();

    private ReindexDataStreamIndexAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse {
        private final String destIndex;

        public Response(String destIndex) {
            this.destIndex = destIndex;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.destIndex = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.destIndex);
        }

        public String getDestIndex() {
            return this.destIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.destIndex, response.destIndex);
        }

        public int hashCode() {
            return Objects.hash(this.destIndex);
        }
    }

    public static class Request
    extends LegacyActionRequest
    implements IndicesRequest {
        private final String sourceIndex;

        public Request(String sourceIndex) {
            this.sourceIndex = sourceIndex;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.sourceIndex = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sourceIndex);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getSourceIndex() {
            return this.sourceIndex;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.sourceIndex, request.sourceIndex);
        }

        public int hashCode() {
            return Objects.hash(this.sourceIndex);
        }

        public String[] indices() {
            return new String[]{this.sourceIndex};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String getDescription() {
            return "reindexing data stream index " + this.sourceIndex;
        }
    }
}

