/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class ReindexDataStreamAction
extends ActionType<AcknowledgedResponse> {
    public static final String TASK_ID_PREFIX = "reindex-data-stream-";
    public static final ReindexDataStreamAction INSTANCE = new ReindexDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/reindex";
    public static final ParseField MODE_FIELD = new ParseField("mode", new String[0]);
    public static final ParseField SOURCE_FIELD = new ParseField("source", new String[0]);
    public static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);

    public ReindexDataStreamAction() {
        super(NAME);
    }

    public static class ReindexDataStreamRequest
    extends LegacyActionRequest
    implements IndicesRequest,
    ToXContent {
        private final Mode mode;
        private final String sourceDataStream;
        private static final ConstructingObjectParser<ReindexDataStreamRequest, Predicate<NodeFeature>> PARSER = new ConstructingObjectParser("migration_reindex", objects -> {
            Mode mode = Mode.valueOf(((String)objects[0]).toUpperCase(Locale.ROOT));
            String source = (String)objects[1];
            return new ReindexDataStreamRequest(mode, source);
        });
        private static final ConstructingObjectParser<String, Void> SOURCE_PARSER = new ConstructingObjectParser(SOURCE_FIELD.getPreferredName(), false, (a, id) -> (String)a[0]);

        public ReindexDataStreamRequest(Mode mode, String sourceDataStream) {
            this.mode = mode;
            this.sourceDataStream = sourceDataStream;
        }

        public ReindexDataStreamRequest(StreamInput in) throws IOException {
            super(in);
            this.mode = Mode.valueOf(in.readString());
            this.sourceDataStream = in.readString();
        }

        public static ReindexDataStreamRequest fromXContent(XContentParser parser) {
            return (ReindexDataStreamRequest)((Object)PARSER.apply(parser, null));
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.mode.name());
            out.writeString(this.sourceDataStream);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public boolean getShouldStoreResult() {
            return true;
        }

        public String getSourceDataStream() {
            return this.sourceDataStream;
        }

        public Mode getMode() {
            return this.mode;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mode, this.sourceDataStream});
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!(other instanceof ReindexDataStreamRequest)) return false;
            ReindexDataStreamRequest otherRequest = (ReindexDataStreamRequest)((Object)other);
            if (!this.mode.equals((Object)otherRequest.mode)) return false;
            if (!this.sourceDataStream.equals(otherRequest.sourceDataStream)) return false;
            return true;
        }

        public String[] indices() {
            return new String[]{this.sourceDataStream};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(MODE_FIELD.getPreferredName(), (Enum)this.mode);
            builder.startObject(SOURCE_FIELD.getPreferredName());
            builder.field(INDEX_FIELD.getPreferredName(), this.sourceDataStream);
            builder.endObject();
            return builder;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String getDescription() {
            return "reindexing data stream " + this.sourceDataStream;
        }

        static {
            SOURCE_PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), MODE_FIELD);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, id) -> (String)SOURCE_PARSER.apply(parser, null), SOURCE_FIELD);
        }
    }

    public static enum Mode {
        UPGRADE;

    }
}

