/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;

public final class LoggingTaskListener<Response>
implements ActionListener<Response> {
    private static final Logger logger = LogManager.getLogger(LoggingTaskListener.class);
    private final Task task;

    public LoggingTaskListener(Task task) {
        this.task = task;
    }

    @Override
    public void onResponse(Response response) {
        logger.info("{} finished with response {}", (Object)this.task.getId(), response);
    }

    @Override
    public void onFailure(Exception e) {
        logger.warn(() -> Strings.format((String)"%s failed with exception", (Object[])new Object[]{this.task.getId()}), (Throwable)e);
    }
}

