/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.codecs.TermStats;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.SuggestMode;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;

public final class DirectCandidateGenerator
extends CandidateGenerator {
    private final DirectSpellChecker spellchecker;
    private final String field;
    private final SuggestMode suggestMode;
    private final TermsEnum termsEnum;
    private final IndexReader reader;
    private final long sumTotalTermFreq;
    private static final double LOG_BASE = 5.0;
    private final long frequencyPlateau;
    private final Analyzer preFilter;
    private final Analyzer postFilter;
    private final double nonErrorLikelihood;
    private final CharsRefBuilder spare = new CharsRefBuilder();
    private final BytesRefBuilder byteSpare = new BytesRefBuilder();
    private final int numCandidates;

    public DirectCandidateGenerator(DirectSpellChecker spellchecker, String field, SuggestMode suggestMode, IndexReader reader, double nonErrorLikelihood, int numCandidates) throws IOException {
        this(spellchecker, field, suggestMode, reader, nonErrorLikelihood, numCandidates, null, null, MultiTerms.getTerms((IndexReader)reader, (String)field));
    }

    public DirectCandidateGenerator(DirectSpellChecker spellchecker, String field, SuggestMode suggestMode, IndexReader reader, double nonErrorLikelihood, int numCandidates, Analyzer preFilter, Analyzer postFilter, Terms terms) throws IOException {
        if (terms == null) {
            throw new IllegalArgumentException("generator field [" + field + "] doesn't exist");
        }
        this.spellchecker = spellchecker;
        this.field = field;
        this.numCandidates = numCandidates;
        this.suggestMode = suggestMode;
        this.reader = reader;
        this.sumTotalTermFreq = terms.getSumTotalTermFreq() == -1L ? (long)reader.maxDoc() : terms.getSumTotalTermFreq();
        this.preFilter = preFilter;
        this.postFilter = postFilter;
        this.nonErrorLikelihood = nonErrorLikelihood;
        float thresholdFrequency = spellchecker.getThresholdFrequency();
        this.frequencyPlateau = thresholdFrequency >= 1.0f ? (long)((int)thresholdFrequency) : (long)((int)((float)reader.maxDoc() * thresholdFrequency));
        this.termsEnum = terms.iterator();
    }

    @Override
    public TermStats termStats(BytesRef term) throws IOException {
        term = this.preFilter(term, this.spare, this.byteSpare);
        return this.internalTermStats(term);
    }

    public TermStats internalTermStats(BytesRef term) throws IOException {
        if (this.termsEnum.seekExact(term)) {
            return new TermStats(this.termsEnum.docFreq(), this.termsEnum.totalTermFreq() == -1L ? (long)this.termsEnum.docFreq() : this.termsEnum.totalTermFreq());
        }
        return new TermStats(0, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CandidateSet drawCandidates(CandidateSet set) throws IOException {
        Candidate original = set.originalTerm;
        BytesRef term = this.preFilter(original.term, this.spare, this.byteSpare);
        float origThreshold = this.spellchecker.getThresholdFrequency();
        try {
            if (this.suggestMode != SuggestMode.SUGGEST_ALWAYS) {
                int threshold = this.thresholdTermFrequency(original.termStats.docFreq);
                if (threshold == Integer.MAX_VALUE) {
                    CandidateSet candidateSet = set;
                    return candidateSet;
                }
                if (this.spellchecker.getThresholdFrequency() < (float)threshold) {
                    this.spellchecker.setThresholdFrequency((float)threshold);
                }
            }
            SuggestWord[] suggestSimilar = this.spellchecker.suggestSimilar(new Term(this.field, term), this.numCandidates, this.reader, this.suggestMode);
            ArrayList<Candidate> candidates = new ArrayList<Candidate>(suggestSimilar.length);
            for (int i = 0; i < suggestSimilar.length; ++i) {
                SuggestWord suggestWord = suggestSimilar[i];
                BytesRef candidate = new BytesRef((CharSequence)suggestWord.string);
                TermStats termStats = this.internalTermStats(candidate);
                this.postFilter(new Candidate(candidate, termStats, suggestWord.score, DirectCandidateGenerator.score(termStats, suggestWord.score, this.sumTotalTermFreq), false), this.spare, this.byteSpare, candidates);
            }
            set.addCandidates(candidates);
            CandidateSet candidateSet = set;
            return candidateSet;
        }
        finally {
            this.spellchecker.setThresholdFrequency(origThreshold);
        }
    }

    protected BytesRef preFilter(BytesRef term, CharsRefBuilder spare, final BytesRefBuilder byteSpare) throws IOException {
        if (this.preFilter == null) {
            return term;
        }
        DirectCandidateGenerator.analyze(this.preFilter, term, this.field, new TokenConsumer(){

            @Override
            public void nextToken() {
                this.fillBytesRef(byteSpare);
            }
        }, spare);
        return byteSpare.get();
    }

    protected void postFilter(final Candidate candidate, CharsRefBuilder spare, BytesRefBuilder byteSpare, final List<Candidate> candidates) throws IOException {
        if (this.postFilter == null) {
            candidates.add(candidate);
        } else {
            final BytesRefBuilder result = byteSpare;
            DirectCandidateGenerator.analyze(this.postFilter, candidate.term, this.field, new TokenConsumer(){

                @Override
                public void nextToken() throws IOException {
                    this.fillBytesRef(result);
                    if (this.posIncAttr.getPositionIncrement() > 0 && result.get().bytesEquals(candidate.term)) {
                        BytesRef term = result.toBytesRef();
                        TermStats termStats = DirectCandidateGenerator.this.internalTermStats(term);
                        candidates.add(new Candidate(result.toBytesRef(), termStats, candidate.stringDistance, DirectCandidateGenerator.score(candidate.termStats, candidate.stringDistance, DirectCandidateGenerator.this.sumTotalTermFreq), false));
                    } else {
                        candidates.add(new Candidate(result.toBytesRef(), candidate.termStats, DirectCandidateGenerator.this.nonErrorLikelihood, DirectCandidateGenerator.score(candidate.termStats, candidate.stringDistance, DirectCandidateGenerator.this.sumTotalTermFreq), false));
                    }
                }
            }, spare);
        }
    }

    private static double score(TermStats termStats, double errorScore, long dictionarySize) {
        return errorScore * (((double)termStats.totalTermFreq + 1.0) / ((double)dictionarySize + 1.0));
    }

    int thresholdTermFrequency(int docFreq) {
        if (docFreq > 0) {
            return (int)Math.min(Math.max(0L, Math.round((double)docFreq * (Math.log10((long)docFreq - this.frequencyPlateau) * (1.0 / Math.log10(5.0))) + 1.0)), Integer.MAX_VALUE);
        }
        return 0;
    }

    @Override
    public Candidate createCandidate(BytesRef term, TermStats termStats, double channelScore, boolean userInput) {
        return new Candidate(term, termStats, channelScore, DirectCandidateGenerator.score(termStats, channelScore, this.sumTotalTermFreq), userInput);
    }

    public static int analyze(Analyzer analyzer, BytesRef toAnalyze, String field, TokenConsumer consumer, CharsRefBuilder spare) throws IOException {
        spare.copyUTF8Bytes(toAnalyze);
        CharsRef charsRef = spare.get();
        try (TokenStream ts = analyzer.tokenStream(field, (Reader)new CharArrayReader(charsRef.chars, charsRef.offset, charsRef.length));){
            int n = DirectCandidateGenerator.analyze(ts, consumer);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int analyze(TokenStream stream, TokenConsumer consumer) throws IOException {
        int numTokens = 0;
        boolean success = false;
        try {
            stream.reset();
            consumer.reset(stream);
            while (stream.incrementToken()) {
                consumer.nextToken();
                ++numTokens;
            }
            consumer.end();
            success = true;
        }
        finally {
            if (success) {
                stream.close();
            } else {
                IOUtils.closeWhileHandlingException((Closeable)stream);
            }
        }
        return numTokens;
    }

    public static class CandidateSet {
        public Candidate[] candidates;
        public final Candidate originalTerm;

        public CandidateSet(Candidate[] candidates, Candidate originalTerm) {
            this.candidates = candidates;
            this.originalTerm = originalTerm;
        }

        public void addCandidates(List<Candidate> candidates) {
            HashSet<Candidate> set = new HashSet<Candidate>(candidates);
            Collections.addAll(set, this.candidates);
            this.candidates = set.toArray(new Candidate[set.size()]);
            Arrays.sort(this.candidates, Collections.reverseOrder());
        }

        public void addOneCandidate(Candidate candidate) {
            Candidate[] candidates = new Candidate[this.candidates.length + 1];
            System.arraycopy(this.candidates, 0, candidates, 0, this.candidates.length);
            candidates[candidates.length - 1] = candidate;
            this.candidates = candidates;
        }
    }

    public static class Candidate
    implements Comparable<Candidate> {
        public static final Candidate[] EMPTY = new Candidate[0];
        public final BytesRef term;
        public final double stringDistance;
        public final TermStats termStats;
        public final double score;
        public final boolean userInput;

        public Candidate(BytesRef term, TermStats termStats, double stringDistance, double score, boolean userInput) {
            this.termStats = termStats;
            this.term = term;
            this.stringDistance = stringDistance;
            this.score = score;
            this.userInput = userInput;
        }

        public String toString() {
            return "Candidate [term=" + this.term.utf8ToString() + ", stringDistance=" + this.stringDistance + ", score=" + this.score + ", termStats=" + String.valueOf(this.termStats) + (this.userInput ? ", userInput" : "") + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Candidate other = (Candidate)obj;
            if (this.term == null) {
                return other.term == null;
            }
            return this.term.equals((Object)other.term);
        }

        @Override
        public int compareTo(Candidate other) {
            if (this.score == other.score) {
                return other.term.compareTo(this.term);
            }
            return Double.compare(this.score, other.score);
        }
    }

    public static abstract class TokenConsumer {
        protected CharTermAttribute charTermAttr;
        protected PositionIncrementAttribute posIncAttr;
        protected OffsetAttribute offsetAttr;

        public void reset(TokenStream stream) {
            this.charTermAttr = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            this.posIncAttr = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            this.offsetAttr = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
        }

        protected BytesRef fillBytesRef(BytesRefBuilder spare) {
            spare.copyChars((CharSequence)this.charTermAttr);
            return spare.get();
        }

        public abstract void nextToken() throws IOException;

        public void end() {
        }
    }
}

