/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.Collections;
import org.elasticsearch.search.fetch.FetchProfiler;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.profile.SearchProfileQueryPhaseResult;
import org.elasticsearch.search.profile.aggregation.AggregationProfileShardResult;
import org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.elasticsearch.search.profile.dfs.DfsProfiler;
import org.elasticsearch.search.profile.query.QueryProfileShardResult;
import org.elasticsearch.search.profile.query.QueryProfiler;

public final class Profilers {
    private final QueryProfiler queryProfiler;
    private final AggregationProfiler aggProfiler = new AggregationProfiler();
    private DfsProfiler dfsProfiler;

    public Profilers(ContextIndexSearcher searcher) {
        this.queryProfiler = new QueryProfiler();
        searcher.setProfiler(this.queryProfiler);
    }

    public QueryProfiler getCurrentQueryProfiler() {
        return this.queryProfiler;
    }

    public AggregationProfiler getAggregationProfiler() {
        return this.aggProfiler;
    }

    public DfsProfiler getDfsProfiler() {
        if (this.dfsProfiler == null) {
            this.dfsProfiler = new DfsProfiler();
        }
        return this.dfsProfiler;
    }

    public static FetchProfiler startProfilingFetchPhase() {
        return new FetchProfiler();
    }

    public SearchProfileQueryPhaseResult buildQueryPhaseResults() {
        QueryProfileShardResult result = new QueryProfileShardResult(this.queryProfiler.getTree(), this.queryProfiler.getRewriteTime(), this.queryProfiler.getCollectorResult(), null);
        AggregationProfileShardResult aggResults = new AggregationProfileShardResult(this.aggProfiler.getTree());
        return new SearchProfileQueryPhaseResult(Collections.singletonList(result), aggResults);
    }
}

