/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.search.fetch.FetchContext;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.elasticsearch.search.fetch.StoredFieldsSpec;
import org.elasticsearch.search.rescore.RescoreContext;

public final class MatchedQueriesPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) throws IOException {
        HashMap<String, Query> namedQueries = new HashMap<String, Query>();
        if (context.parsedQuery() != null) {
            namedQueries.putAll(context.parsedQuery().namedFilters());
        }
        if (context.parsedPostFilter() != null) {
            namedQueries.putAll(context.parsedPostFilter().namedFilters());
        }
        for (RescoreContext rescoreContext : context.rescore()) {
            for (ParsedQuery parsedQuery : rescoreContext.getParsedQueries()) {
                namedQueries.putAll(parsedQuery.namedFilters());
            }
        }
        if (namedQueries.isEmpty()) {
            return null;
        }
        final HashMap<String, Weight> weights = new HashMap<String, Weight>();
        for (Map.Entry entry : namedQueries.entrySet()) {
            weights.put((String)entry.getKey(), context.searcher().createWeight(context.searcher().rewrite((Query)entry.getValue()), ScoreMode.COMPLETE, 1.0f));
        }
        return new FetchSubPhaseProcessor(){
            final Map<String, ScorerAndIterator> matchingIterators = new HashMap<String, ScorerAndIterator>();

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                this.matchingIterators.clear();
                for (Map.Entry entry : weights.entrySet()) {
                    Scorer scorer;
                    ScorerSupplier ss = ((Weight)entry.getValue()).scorerSupplier(readerContext);
                    if (ss == null || (scorer = ss.get(0L)) == null) continue;
                    TwoPhaseIterator twoPhase = scorer.twoPhaseIterator();
                    DocIdSetIterator iterator = twoPhase == null ? scorer.iterator() : twoPhase.approximation();
                    this.matchingIterators.put((String)entry.getKey(), new ScorerAndIterator(scorer, iterator, twoPhase));
                }
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                LinkedHashMap<String, Float> matches = new LinkedHashMap<String, Float>();
                int doc = hitContext.docId();
                for (Map.Entry<String, ScorerAndIterator> entry : this.matchingIterators.entrySet()) {
                    ScorerAndIterator query = entry.getValue();
                    if (query.approximation.docID() < doc) {
                        query.approximation.advance(doc);
                    }
                    if (query.approximation.docID() != doc || query.twoPhase != null && !query.twoPhase.matches()) continue;
                    matches.put(entry.getKey(), Float.valueOf(query.scorer.score()));
                }
                hitContext.hit().matchedQueries(matches);
            }

            @Override
            public StoredFieldsSpec storedFieldsSpec() {
                return StoredFieldsSpec.NO_REQUIREMENTS;
            }

            record ScorerAndIterator(Scorer scorer, DocIdSetIterator approximation, TwoPhaseIterator twoPhase) {
            }
        };
    }
}

