/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.builder;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.usage.SearchUsage;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class SubSearchSourceBuilder
implements ToXContent,
Writeable,
Rewriteable<SubSearchSourceBuilder> {
    private static final ConstructingObjectParser<SubSearchSourceBuilder, SearchUsage> PARSER = new ConstructingObjectParser("sub_search_source_builder", args -> new SubSearchSourceBuilder((QueryBuilder)args[0]));
    private final QueryBuilder queryBuilder;

    public static SubSearchSourceBuilder fromXContent(XContentParser parser, SearchUsage searchUsage) throws IOException {
        return (SubSearchSourceBuilder)PARSER.parse(parser, (Object)searchUsage);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SearchSourceBuilder.QUERY_FIELD.getPreferredName());
        this.queryBuilder.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean isFragment() {
        return false;
    }

    public SubSearchSourceBuilder(QueryBuilder queryBuilder) {
        Objects.requireNonNull(queryBuilder);
        this.queryBuilder = queryBuilder;
    }

    public SubSearchSourceBuilder(StreamInput in) throws IOException {
        this.queryBuilder = in.readNamedWriteable(QueryBuilder.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.queryBuilder);
    }

    @Override
    public SubSearchSourceBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        QueryBuilder rewrittenQueryBuilder = this.queryBuilder.rewrite(ctx);
        return rewrittenQueryBuilder == this.queryBuilder ? this : new SubSearchSourceBuilder(rewrittenQueryBuilder);
    }

    public QueryBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public Query toSearchQuery(SearchExecutionContext context) throws IOException {
        return this.queryBuilder.toQuery(context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubSearchSourceBuilder that = (SubSearchSourceBuilder)o;
        return Objects.equals(this.queryBuilder, that.queryBuilder);
    }

    public int hashCode() {
        return Objects.hash(this.queryBuilder);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> AbstractQueryBuilder.parseTopLevelQuery(p, c::trackQueryUsage), SearchSourceBuilder.QUERY_FIELD);
    }
}

