/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.PreallocatedCircuitBreakerService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.NameOrDefinition;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.support.AggregationUsageService;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SubSearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.profile.aggregation.AggregationProfiler;
import org.elasticsearch.search.profile.aggregation.ProfilingAggregator;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;

public abstract class AggregationContext
implements Releasable {
    public abstract Query query();

    public abstract Aggregator profileIfEnabled(Aggregator var1) throws IOException;

    public abstract boolean profiling();

    public abstract long nowInMillis();

    public final FieldContext buildFieldContext(String field) {
        MappedFieldType ft = this.getFieldType(field);
        if (ft == null) {
            return null;
        }
        return new FieldContext(field, this.buildFieldData(ft), ft);
    }

    public abstract Analyzer getNamedAnalyzer(String var1) throws IOException;

    public abstract Analyzer buildCustomAnalyzer(IndexSettings var1, boolean var2, NameOrDefinition var3, List<NameOrDefinition> var4, List<NameOrDefinition> var5) throws IOException;

    public final FieldContext buildFieldContext(MappedFieldType ft) {
        return new FieldContext(ft.name(), this.buildFieldData(ft), ft);
    }

    protected abstract IndexFieldData<?> buildFieldData(MappedFieldType var1);

    public abstract MappedFieldType getFieldType(String var1);

    public abstract Set<String> getMatchingFieldNames(String var1);

    public abstract <FactoryType> FactoryType compile(Script var1, ScriptContext<FactoryType> var2);

    public abstract SearchLookup lookup();

    public abstract ValuesSourceRegistry getValuesSourceRegistry();

    public final AggregationUsageService getUsageService() {
        return this.getValuesSourceRegistry().getUsageService();
    }

    public abstract BigArrays bigArrays();

    public abstract IndexSearcher searcher();

    public abstract Query buildQuery(QueryBuilder var1) throws IOException;

    public abstract Query filterQuery(Query var1);

    public abstract IndexSettings getIndexSettings();

    public abstract ClusterSettings getClusterSettings();

    public abstract Optional<SortAndFormats> buildSort(List<SortBuilder<?>> var1) throws IOException;

    public abstract NestedLookup nestedLookup();

    public abstract NestedScope nestedScope();

    public abstract SubSearchContext subSearchContext();

    public abstract void addReleasable(Aggregator var1);

    public abstract void removeReleasable(Aggregator var1);

    public abstract int maxBuckets();

    public abstract BitsetFilterCache bitsetFilterCache();

    public abstract BucketedSort buildBucketedSort(SortBuilder<?> var1, int var2, BucketedSort.ExtraData var3) throws IOException;

    public abstract int shardRandomSeed();

    public abstract long getRelativeTimeInMillis();

    public abstract boolean isCancelled();

    public abstract CircuitBreaker breaker();

    public abstract Analyzer getIndexAnalyzer(Function<String, NamedAnalyzer> var1);

    public abstract boolean isCacheable();

    public abstract boolean enableRewriteToFilterByFilter();

    public abstract boolean isInSortOrderExecutionRequired();

    public abstract Set<String> sourcePath(String var1);

    @Nullable
    public MappingLookup getMappingLookup() {
        return null;
    }

    public final boolean hasDocCountField() throws IOException {
        Term term = new Term("_doc_count", "_doc_count");
        for (LeafReaderContext c : this.searcher().getLeafContexts()) {
            if (c.reader().docFreq(term) <= 0) continue;
            return true;
        }
        return false;
    }

    public static class ProductionAggregationContext
    extends AggregationContext {
        private final SearchExecutionContext context;
        private final PreallocatedCircuitBreakerService preallocatedBreakerService;
        private final BigArrays bigArrays;
        private final ClusterSettings clusterSettings;
        private final Supplier<Query> topLevelQuery;
        private final AggregationProfiler profiler;
        private final int maxBuckets;
        private final Supplier<SubSearchContext> subSearchContextBuilder;
        private final BitsetFilterCache bitsetFilterCache;
        private final int randomSeed;
        private final LongSupplier relativeTimeInMillis;
        private final Supplier<Boolean> isCancelled;
        private final Function<Query, Query> filterQuery;
        private final boolean enableRewriteToFilterByFilter;
        private final boolean inSortOrderExecutionRequired;
        private final AnalysisRegistry analysisRegistry;
        private final List<Aggregator> releaseMe = new ArrayList<Aggregator>();

        public ProductionAggregationContext(AnalysisRegistry analysisRegistry, SearchExecutionContext context, BigArrays bigArrays, ClusterSettings clusterSettings, long bytesToPreallocate, Supplier<Query> topLevelQuery, @Nullable AggregationProfiler profiler, int maxBuckets, Supplier<SubSearchContext> subSearchContextBuilder, BitsetFilterCache bitsetFilterCache, int randomSeed, LongSupplier relativeTimeInMillis, Supplier<Boolean> isCancelled, Function<Query, Query> filterQuery, boolean enableRewriteToFilterByFilter, boolean inSortOrderExecutionRequired) {
            this.analysisRegistry = analysisRegistry;
            this.context = context;
            this.clusterSettings = clusterSettings;
            if (bytesToPreallocate == 0L) {
                this.preallocatedBreakerService = null;
                this.bigArrays = bigArrays.withCircuitBreaking();
            } else {
                this.preallocatedBreakerService = new PreallocatedCircuitBreakerService(bigArrays.breakerService(), "request", bytesToPreallocate, "aggregations");
                this.bigArrays = bigArrays.withBreakerService(this.preallocatedBreakerService).withCircuitBreaking();
            }
            this.topLevelQuery = topLevelQuery;
            this.profiler = profiler;
            this.maxBuckets = maxBuckets;
            this.subSearchContextBuilder = subSearchContextBuilder;
            this.bitsetFilterCache = bitsetFilterCache;
            this.randomSeed = randomSeed;
            this.relativeTimeInMillis = relativeTimeInMillis;
            this.isCancelled = isCancelled;
            this.filterQuery = filterQuery;
            this.enableRewriteToFilterByFilter = enableRewriteToFilterByFilter;
            this.inSortOrderExecutionRequired = inSortOrderExecutionRequired;
        }

        @Override
        public Query query() {
            return this.topLevelQuery.get();
        }

        @Override
        public Aggregator profileIfEnabled(Aggregator agg) {
            if (this.profiler == null) {
                return agg;
            }
            return new ProfilingAggregator(agg, this.profiler);
        }

        @Override
        public boolean profiling() {
            return this.profiler != null;
        }

        @Override
        public long nowInMillis() {
            return this.context.nowInMillis();
        }

        @Override
        public Analyzer getNamedAnalyzer(String analyzer) throws IOException {
            return this.analysisRegistry.getAnalyzer(analyzer);
        }

        @Override
        public Analyzer buildCustomAnalyzer(IndexSettings indexSettings, boolean normalizer, NameOrDefinition tokenizer, List<NameOrDefinition> charFilters, List<NameOrDefinition> tokenFilters) throws IOException {
            return this.analysisRegistry.buildCustomAnalyzer(IndexService.IndexCreationContext.RELOAD_ANALYZERS, indexSettings, normalizer, tokenizer, charFilters, tokenFilters);
        }

        @Override
        protected IndexFieldData<?> buildFieldData(MappedFieldType ft) {
            return this.context.getForField(ft, MappedFieldType.FielddataOperation.SEARCH);
        }

        @Override
        public MappedFieldType getFieldType(String path) {
            return this.context.getFieldType(path);
        }

        @Override
        public Set<String> getMatchingFieldNames(String pattern) {
            return this.context.getMatchingFieldNames(pattern);
        }

        @Override
        public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> scriptContext) {
            return this.context.compile(script, scriptContext);
        }

        @Override
        public SearchLookup lookup() {
            return this.context.lookup();
        }

        @Override
        public ValuesSourceRegistry getValuesSourceRegistry() {
            return this.context.getValuesSourceRegistry();
        }

        @Override
        public BigArrays bigArrays() {
            return this.bigArrays;
        }

        @Override
        public IndexSearcher searcher() {
            return this.context.searcher();
        }

        @Override
        public Query buildQuery(QueryBuilder builder) throws IOException {
            return Rewriteable.rewrite(builder, this.context, true).toQuery(this.context);
        }

        @Override
        public Query filterQuery(Query query) {
            return this.filterQuery.apply(query);
        }

        @Override
        public IndexSettings getIndexSettings() {
            return this.context.getIndexSettings();
        }

        @Override
        public ClusterSettings getClusterSettings() {
            return this.clusterSettings;
        }

        @Override
        public Optional<SortAndFormats> buildSort(List<SortBuilder<?>> sortBuilders) throws IOException {
            return SortBuilder.buildSort(sortBuilders, this.context);
        }

        @Override
        public NestedLookup nestedLookup() {
            return this.context.nestedLookup();
        }

        @Override
        public NestedScope nestedScope() {
            return this.context.nestedScope();
        }

        @Override
        public SubSearchContext subSearchContext() {
            return this.subSearchContextBuilder.get();
        }

        @Override
        public void addReleasable(Aggregator aggregator) {
            assert (!this.releaseMe.contains(aggregator)) : "adding aggregator [" + aggregator.name() + "] twice in the aggregation context";
            this.releaseMe.add(aggregator);
        }

        @Override
        public synchronized void removeReleasable(Aggregator aggregator) {
            assert (this.releaseMe.contains(aggregator)) : "removing non-existing aggregator [" + aggregator.name() + "] from the the aggregation context";
            this.releaseMe.remove(aggregator);
        }

        @Override
        public int maxBuckets() {
            return this.maxBuckets;
        }

        @Override
        public BitsetFilterCache bitsetFilterCache() {
            return this.bitsetFilterCache;
        }

        @Override
        public BucketedSort buildBucketedSort(SortBuilder<?> sort, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
            return sort.buildBucketedSort(this.context, this.bigArrays, bucketSize, extra);
        }

        @Override
        public int shardRandomSeed() {
            return this.randomSeed;
        }

        @Override
        public long getRelativeTimeInMillis() {
            return this.relativeTimeInMillis.getAsLong();
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled.get();
        }

        @Override
        public CircuitBreaker breaker() {
            return this.bigArrays.breakerService().getBreaker("request");
        }

        @Override
        public Analyzer getIndexAnalyzer(Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
            return this.context.getIndexAnalyzer(unindexedFieldAnalyzer);
        }

        @Override
        public boolean isCacheable() {
            return this.context.isCacheable();
        }

        @Override
        public boolean enableRewriteToFilterByFilter() {
            return this.enableRewriteToFilterByFilter;
        }

        @Override
        public boolean isInSortOrderExecutionRequired() {
            return this.inSortOrderExecutionRequired;
        }

        @Override
        public Set<String> sourcePath(String fullName) {
            return this.context.sourcePath(fullName);
        }

        @Override
        public MappingLookup getMappingLookup() {
            return this.context.getMappingLookup();
        }

        public void close() {
            ArrayList<Aggregator> releaseMe = new ArrayList<Aggregator>(this.releaseMe);
            releaseMe.add((Aggregator)((Object)this.preallocatedBreakerService));
            Releasables.close(releaseMe);
        }
    }
}

