/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public final class NonCollectingMultiMetricAggregator
extends NumericMetricsAggregator.MultiValue {
    private final InternalNumericMetricsAggregation.MultiValue emptyAggregation;
    private final Predicate<String> hasMetric;

    public NonCollectingMultiMetricAggregator(String name, AggregationContext context, Aggregator parent, InternalNumericMetricsAggregation.MultiValue emptyAggregation, Predicate<String> hasMetric, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.emptyAggregation = emptyAggregation;
        this.hasMetric = hasMetric;
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) {
        return LeafBucketCollector.NO_OP_COLLECTOR;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrd) throws IOException {
        return this.buildEmptyAggregation();
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.emptyAggregation;
    }

    @Override
    public boolean hasMetric(String name) {
        return this.hasMetric.test(name);
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        return this.emptyAggregation.value(name);
    }
}

