/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;

public class AggregationExecutionContext {
    private final Supplier<BytesRef> tsidProvider;
    private final LongSupplier timestampProvider;
    private final IntSupplier tsidOrdProvider;
    private final LeafReaderContext leafReaderContext;

    public AggregationExecutionContext(LeafReaderContext leafReaderContext, Supplier<BytesRef> tsidProvider, LongSupplier timestampProvider, IntSupplier tsidOrdProvider) {
        this.leafReaderContext = leafReaderContext;
        this.tsidProvider = tsidProvider;
        this.timestampProvider = timestampProvider;
        this.tsidOrdProvider = tsidOrdProvider;
    }

    public LeafReaderContext getLeafReaderContext() {
        return this.leafReaderContext;
    }

    public BytesRef getTsidHash() {
        return this.tsidProvider != null ? this.tsidProvider.get() : null;
    }

    public long getTimestamp() {
        return this.timestampProvider.getAsLong();
    }

    public int getTsidHashOrd() {
        if (this.tsidOrdProvider == null) {
            throw new IllegalArgumentException("Aggregation on a time-series field is misconfigured, likely due to lack of wrapping a metric aggregation within a `time-series` aggregation");
        }
        return this.tsidOrdProvider.getAsInt();
    }
}

