/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.ingest;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.SimulateBulkAction;
import org.elasticsearch.action.bulk.SimulateBulkRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

@ServerlessScope(value=Scope.PUBLIC)
public class RestSimulateIngestAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_ingest/_simulate"), new RestHandler.Route(RestRequest.Method.POST, "/_ingest/_simulate"), new RestHandler.Route(RestRequest.Method.GET, "/_ingest/{index}/_simulate"), new RestHandler.Route(RestRequest.Method.POST, "/_ingest/{index}/_simulate"));
    }

    @Override
    public String getName() {
        return "ingest_simulate_ingest_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String defaultIndex = request.param("index");
        FetchSourceContext defaultFetchSourceContext = FetchSourceContext.parseFromRestRequest(request);
        String defaultPipeline = request.param("pipeline");
        Tuple<XContentType, ReleasableBytesReference> sourceTuple = request.contentOrSourceParam();
        Map sourceMap = (Map)XContentHelper.convertToMap((BytesReference)sourceTuple.v2(), false, (XContentType)sourceTuple.v1()).v2();
        Map pipelineSubstitutions = (Map)sourceMap.remove("pipeline_substitutions");
        Map componentTemplateSubstitutions = (Map)sourceMap.remove("component_template_substitutions");
        Map indexTemplateSubstitutions = (Map)sourceMap.remove("index_template_substitutions");
        Object mappingAddition = sourceMap.remove("mapping_addition");
        SimulateBulkRequest bulkRequest = new SimulateBulkRequest(pipelineSubstitutions == null ? Map.of() : pipelineSubstitutions, componentTemplateSubstitutions == null ? Map.of() : componentTemplateSubstitutions, indexTemplateSubstitutions == null ? Map.of() : indexTemplateSubstitutions, mappingAddition == null ? Map.of() : Map.of("_doc", mappingAddition));
        BytesReference transformedData = RestSimulateIngestAction.convertToBulkRequestXContentBytes(sourceMap);
        bulkRequest.add(transformedData, defaultIndex, null, defaultFetchSourceContext, defaultPipeline, null, null, true, true, request.getXContentType(), request.getRestApiVersion());
        return channel -> client.execute(SimulateBulkAction.INSTANCE, bulkRequest, new SimulateIngestRestToXContentListener((RestChannel)channel));
    }

    static BytesReference convertToBulkRequestXContentBytes(Map<String, Object> sourceMap) throws IOException {
        List<Map> docs = ConfigurationUtils.readList(null, null, sourceMap, "docs");
        if (docs.isEmpty()) {
            throw new IllegalArgumentException("must specify at least one document in [docs]");
        }
        ByteBuffer[] buffers = new ByteBuffer[2 * docs.size()];
        int bufferCount = 0;
        for (Map doc : docs) {
            if (!(doc != null)) {
                throw new IllegalArgumentException("malformed [docs] section, should include an inner object");
            }
            Map document = ConfigurationUtils.readMap(null, null, doc, "_source");
            String index = ConfigurationUtils.readOptionalStringProperty(null, null, doc, IngestDocument.Metadata.INDEX.getFieldName());
            String id = ConfigurationUtils.readOptionalStringProperty(null, null, doc, IngestDocument.Metadata.ID.getFieldName());
            XContentBuilder actionXContentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).lfAtEnd();
            actionXContentBuilder.startObject().field("index").startObject();
            if (index != null) {
                actionXContentBuilder.field("_index", index);
            }
            if (id != null) {
                actionXContentBuilder.field("_id", id);
            }
            actionXContentBuilder.endObject().endObject();
            buffers[bufferCount++] = ByteBuffer.wrap(BytesReference.bytes((XContentBuilder)actionXContentBuilder).toBytesRef().bytes);
            XContentBuilder dataXContentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON).lfAtEnd();
            dataXContentBuilder.startObject();
            for (String key : document.keySet()) {
                dataXContentBuilder.field(key, document.get(key));
            }
            dataXContentBuilder.endObject();
            buffers[bufferCount++] = ByteBuffer.wrap(BytesReference.bytes((XContentBuilder)dataXContentBuilder).toBytesRef().bytes);
        }
        return BytesReference.fromByteBuffers(buffers);
    }

    static class SimulateIngestRestToXContentListener
    extends RestBuilderListener<BulkResponse> {
        SimulateIngestRestToXContentListener(RestChannel channel) {
            super(channel);
        }

        @Override
        public RestResponse buildResponse(BulkResponse response, XContentBuilder builder) throws Exception {
            assert (!response.isFragment());
            SimulateIngestRestToXContentListener.toXContent(response, builder, this.channel.request());
            return new RestResponse(RestStatus.OK, builder);
        }

        private static void toXContent(BulkResponse response, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray("docs");
            for (BulkItemResponse item : response) {
                builder.startObject();
                builder.startObject("doc");
                if (item.isFailed()) {
                    builder.field("_id", item.getFailure().getId());
                    builder.field("_index", item.getFailure().getIndex());
                    builder.startObject("error");
                    ElasticsearchException.generateThrowableXContent(builder, params, item.getFailure().getCause());
                    builder.endObject();
                } else {
                    ((DocWriteResponse)item.getResponse()).innerToXContent(builder, params);
                }
                builder.endObject();
                builder.endObject();
            }
            builder.endArray();
            builder.endObject();
        }
    }
}

