/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public class RepositoryException
extends ElasticsearchException {
    private final String repository;

    public RepositoryException(String repository, String msg, Object ... args) {
        this(repository, msg, null, args);
    }

    public RepositoryException(String repository, String msg, Throwable cause, Object ... args) {
        super("[" + (repository == null ? "_na" : repository) + "] " + msg, cause, args);
        this.repository = repository;
    }

    public String repository() {
        return this.repository;
    }

    public RepositoryException(StreamInput in) throws IOException {
        super(in);
        this.repository = in.readOptionalString();
    }

    @Override
    protected void writeTo(StreamOutput out, Writeable.Writer<Throwable> nestedExceptionsWriter) throws IOException {
        super.writeTo(out, nestedExceptionsWriter);
        out.writeOptionalString(this.repository);
    }
}

