/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import org.elasticsearch.lucene.spatial.CoordinateEncoder;

public interface TriangleTreeVisitor {
    public void visitPoint(int var1, int var2);

    public void visitLine(int var1, int var2, int var3, int var4, byte var5);

    public void visitTriangle(int var1, int var2, int var3, int var4, int var5, int var6, byte var7);

    public boolean push();

    public boolean pushX(int var1);

    public boolean pushY(int var1);

    public boolean push(int var1, int var2);

    public boolean push(int var1, int var2, int var3, int var4);

    public static boolean abFromTriangle(byte metadata) {
        return (metadata & 0x10) == 16;
    }

    public static boolean bcFromTriangle(byte metadata) {
        return (metadata & 0x20) == 32;
    }

    public static boolean caFromTriangle(byte metadata) {
        return (metadata & 0x40) == 64;
    }

    public static abstract class TriangleTreeDecodedVisitor
    implements TriangleTreeVisitor {
        private final CoordinateEncoder encoder;

        protected TriangleTreeDecodedVisitor(CoordinateEncoder encoder) {
            this.encoder = encoder;
        }

        @Override
        public final void visitPoint(int x, int y) {
            this.visitDecodedPoint(this.encoder.decodeX(x), this.encoder.decodeY(y));
        }

        protected abstract void visitDecodedPoint(double var1, double var3);

        @Override
        public final void visitLine(int aX, int aY, int bX, int bY, byte metadata) {
            this.visitDecodedLine(this.encoder.decodeX(aX), this.encoder.decodeY(aY), this.encoder.decodeX(bX), this.encoder.decodeY(bY), metadata);
        }

        protected abstract void visitDecodedLine(double var1, double var3, double var5, double var7, byte var9);

        @Override
        public final void visitTriangle(int aX, int aY, int bX, int bY, int cX, int cY, byte metadata) {
            this.visitDecodedTriangle(this.encoder.decodeX(aX), this.encoder.decodeY(aY), this.encoder.decodeX(bX), this.encoder.decodeY(bY), this.encoder.decodeX(cX), this.encoder.decodeY(cY), metadata);
        }

        protected abstract void visitDecodedTriangle(double var1, double var3, double var5, double var7, double var9, double var11, byte var13);

        @Override
        public final boolean pushX(int minX) {
            return this.pushDecodedX(this.encoder.decodeX(minX));
        }

        protected abstract boolean pushDecodedX(double var1);

        @Override
        public final boolean pushY(int minY) {
            return this.pushDecodedY(this.encoder.decodeY(minY));
        }

        protected abstract boolean pushDecodedY(double var1);

        @Override
        public final boolean push(int maxX, int maxY) {
            return this.pushDecoded(this.encoder.decodeX(maxX), this.encoder.decodeY(maxY));
        }

        protected abstract boolean pushDecoded(double var1, double var3);

        @Override
        public final boolean push(int minX, int minY, int maxX, int maxY) {
            return this.pushDecoded(this.encoder.decodeX(minX), this.encoder.decodeY(minY), this.encoder.decodeX(maxX), this.encoder.decodeY(maxY));
        }

        protected abstract boolean pushDecoded(double var1, double var3, double var5, double var7);
    }
}

