/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.grouping;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.CollectionUtils;

public final class TopFieldGroups
extends TopFieldDocs {
    public final String field;
    public final Object[] groupValues;

    public TopFieldGroups(String field, TotalHits totalHits, ScoreDoc[] scoreDocs, SortField[] sortFields, Object[] values) {
        super(totalHits, scoreDocs, sortFields);
        this.field = field;
        this.groupValues = values;
    }

    static boolean tieBreakLessThan(ShardRef first, ScoreDoc firstDoc, ShardRef second, ScoreDoc secondDoc) {
        int secondShardIndex;
        int firstShardIndex = first.getShardIndex(firstDoc);
        if (firstShardIndex < (secondShardIndex = second.getShardIndex(secondDoc))) {
            return true;
        }
        if (firstShardIndex > secondShardIndex) {
            return false;
        }
        assert (first.hitIndex != second.hitIndex);
        return first.hitIndex < second.hitIndex;
    }

    public static TopFieldGroups merge(Sort sort, int start, int size, TopFieldGroups[] shardHits, boolean setShardIndex) {
        Object[] values;
        ScoreDoc[] hits;
        String groupField = shardHits[0].field;
        for (int i = 1; i < shardHits.length; ++i) {
            if (groupField.equals(shardHits[i].field)) continue;
            throw new IllegalArgumentException("group field differ across shards [" + groupField + "] != [" + shardHits[i].field + "]");
        }
        MergeSortQueue queue = new MergeSortQueue(sort, shardHits);
        long totalHitCount = 0L;
        int availHitCount = 0;
        TotalHits.Relation totalHitsRelation = TotalHits.Relation.EQUAL_TO;
        for (int shardIDX = 0; shardIDX < shardHits.length; ++shardIDX) {
            TopFieldGroups shard = shardHits[shardIDX];
            totalHitCount += shard.totalHits.value;
            if (shard.totalHits.relation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
            }
            if (CollectionUtils.isEmpty(shard.scoreDocs)) continue;
            availHitCount += shard.scoreDocs.length;
            queue.add(new ShardRef(shardIDX, !setShardIndex));
        }
        if (availHitCount <= start) {
            hits = new ScoreDoc[]{};
            values = new Object[]{};
        } else {
            ArrayList<ScoreDoc> hitList = new ArrayList<ScoreDoc>();
            ArrayList<Object> groupList = new ArrayList<Object>();
            int requestedResultWindow = start + size;
            int numIterOnHits = Math.min(availHitCount, requestedResultWindow);
            int hitUpto = 0;
            HashSet<Object> seen = new HashSet<Object>();
            while (hitUpto < numIterOnHits && queue.size() != 0) {
                Object groupValue;
                ShardRef ref = (ShardRef)queue.top();
                ScoreDoc hit = shardHits[ref.shardIndex].scoreDocs[ref.hitIndex];
                if (seen.contains(groupValue = shardHits[ref.shardIndex].groupValues[ref.hitIndex++])) {
                    if (ref.hitIndex < shardHits[ref.shardIndex].scoreDocs.length) {
                        queue.updateTop();
                        continue;
                    }
                    queue.pop();
                    continue;
                }
                seen.add(groupValue);
                if (setShardIndex) {
                    hit.shardIndex = ref.shardIndex;
                }
                if (hitUpto >= start) {
                    hitList.add(hit);
                    groupList.add(groupValue);
                }
                ++hitUpto;
                if (ref.hitIndex < shardHits[ref.shardIndex].scoreDocs.length) {
                    queue.updateTop();
                    continue;
                }
                queue.pop();
            }
            hits = hitList.toArray(Lucene.EMPTY_SCORE_DOCS);
            values = groupList.toArray(new Object[0]);
        }
        TotalHits totalHits = new TotalHits(totalHitCount, totalHitsRelation);
        return new TopFieldGroups(groupField, totalHits, hits, sort.getSort(), values);
    }

    private static final class ShardRef {
        final int shardIndex;
        final boolean useScoreDocIndex;
        int hitIndex;

        ShardRef(int shardIndex, boolean useScoreDocIndex) {
            this.shardIndex = shardIndex;
            this.useScoreDocIndex = useScoreDocIndex;
        }

        public String toString() {
            return "ShardRef(shardIndex=" + this.shardIndex + " hitIndex=" + this.hitIndex + ")";
        }

        int getShardIndex(ScoreDoc scoreDoc) {
            if (this.useScoreDocIndex) {
                if (scoreDoc.shardIndex == -1) {
                    throw new IllegalArgumentException("setShardIndex is false but TopDocs[" + this.shardIndex + "].scoreDocs[" + this.hitIndex + "] is not set");
                }
                return scoreDoc.shardIndex;
            }
            return this.shardIndex;
        }
    }

    private static class MergeSortQueue
    extends PriorityQueue<ShardRef> {
        final ScoreDoc[][] shardHits;
        final FieldComparator<?>[] comparators;
        final int[] reverseMul;

        MergeSortQueue(Sort sort, TopFieldGroups[] shardHits) {
            super(shardHits.length);
            this.shardHits = new ScoreDoc[shardHits.length][];
            for (int shardIDX = 0; shardIDX < shardHits.length; ++shardIDX) {
                ScoreDoc[] shard = shardHits[shardIDX].scoreDocs;
                if (shard == null) continue;
                this.shardHits[shardIDX] = shard;
                for (int hitIDX = 0; hitIDX < shard.length; ++hitIDX) {
                    ScoreDoc sd = shard[hitIDX];
                    FieldDoc gd = (FieldDoc)sd;
                    assert (gd.fields != null);
                }
            }
            SortField[] sortFields = sort.getSort();
            this.comparators = new FieldComparator[sortFields.length];
            this.reverseMul = new int[sortFields.length];
            for (int compIDX = 0; compIDX < sortFields.length; ++compIDX) {
                SortField sortField = sortFields[compIDX];
                this.comparators[compIDX] = sortField.getComparator(1, Pruning.NONE);
                this.reverseMul[compIDX] = sortField.getReverse() ? -1 : 1;
            }
        }

        public boolean lessThan(ShardRef first, ShardRef second) {
            assert (first != second);
            FieldDoc firstFD = (FieldDoc)this.shardHits[first.shardIndex][first.hitIndex];
            FieldDoc secondFD = (FieldDoc)this.shardHits[second.shardIndex][second.hitIndex];
            for (int compIDX = 0; compIDX < this.comparators.length; ++compIDX) {
                FieldComparator<?> comp = this.comparators[compIDX];
                int cmp = this.reverseMul[compIDX] * comp.compareValues(firstFD.fields[compIDX], secondFD.fields[compIDX]);
                if (cmp == 0) continue;
                return cmp < 0;
            }
            return TopFieldGroups.tieBreakLessThan(first, (ScoreDoc)firstFD, second, (ScoreDoc)secondFD);
        }
    }
}

