/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.injection.guice;

import java.util.List;
import org.elasticsearch.injection.guice.Binding;
import org.elasticsearch.injection.guice.BindingProcessor;
import org.elasticsearch.injection.guice.ContextualCallable;
import org.elasticsearch.injection.guice.DeferredLookups;
import org.elasticsearch.injection.guice.Initializer;
import org.elasticsearch.injection.guice.Injector;
import org.elasticsearch.injection.guice.InjectorImpl;
import org.elasticsearch.injection.guice.InjectorShell;
import org.elasticsearch.injection.guice.LookupProcessor;
import org.elasticsearch.injection.guice.Module;
import org.elasticsearch.injection.guice.internal.BindingImpl;
import org.elasticsearch.injection.guice.internal.Errors;
import org.elasticsearch.injection.guice.internal.ErrorsException;
import org.elasticsearch.injection.guice.internal.InternalContext;
import org.elasticsearch.injection.guice.internal.Scoping;
import org.elasticsearch.injection.guice.internal.Stopwatch;
import org.elasticsearch.injection.guice.spi.Dependency;

class InjectorBuilder {
    private final Stopwatch stopwatch = new Stopwatch();
    private final Errors errors = new Errors();
    private final Initializer initializer = new Initializer();
    private final BindingProcessor bindingProcesor;
    private final InjectorShell.Builder shellBuilder = new InjectorShell.Builder();
    private List<InjectorShell> shells;

    InjectorBuilder() {
        this.bindingProcesor = new BindingProcessor(this.errors, this.initializer);
    }

    InjectorBuilder addModules(Iterable<? extends Module> modules) {
        this.shellBuilder.addModules(modules);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Injector build() {
        Object object = this.shellBuilder.lock();
        synchronized (object) {
            this.shells = this.shellBuilder.build(this.bindingProcesor, this.stopwatch, this.errors);
            this.stopwatch.resetAndLog("Injector construction");
            this.initializeStatically();
        }
        this.injectDynamically();
        return this.primaryInjector();
    }

    private void initializeStatically() {
        this.bindingProcesor.initializeBindings();
        this.stopwatch.resetAndLog("Binding initialization");
        for (InjectorShell shell : this.shells) {
            shell.getInjector().index();
        }
        this.stopwatch.resetAndLog("Binding indexing");
        this.stopwatch.resetAndLog("Collecting injection requests");
        this.bindingProcesor.runCreationListeners();
        this.stopwatch.resetAndLog("Binding validation");
        this.stopwatch.resetAndLog("Static validation");
        this.initializer.validateOustandingInjections(this.errors);
        this.stopwatch.resetAndLog("Instance member validation");
        new LookupProcessor(this.errors).process(this.shells);
        for (InjectorShell shell : this.shells) {
            ((DeferredLookups)shell.getInjector().lookups).initialize(this.errors);
        }
        this.stopwatch.resetAndLog("Provider verification");
        for (InjectorShell shell : this.shells) {
            if (!shell.getElements().isEmpty()) {
                throw new AssertionError((Object)("Failed to execute " + String.valueOf(shell.getElements())));
            }
        }
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    private Injector primaryInjector() {
        return this.shells.get(0).getInjector();
    }

    private void injectDynamically() {
        this.stopwatch.resetAndLog("Static member injection");
        this.initializer.injectAll(this.errors);
        this.stopwatch.resetAndLog("Instance injection");
        this.errors.throwCreationExceptionIfErrorsExist();
        for (InjectorShell shell : this.shells) {
            InjectorBuilder.loadEagerSingletons(shell.getInjector(), this.errors);
        }
        this.stopwatch.resetAndLog("Preloading singletons");
        this.errors.throwCreationExceptionIfErrorsExist();
    }

    public static void loadEagerSingletons(InjectorImpl injector, Errors errors) {
        for (Binding<?> binding : injector.state.getExplicitBindingsThisLevel().values()) {
            InjectorBuilder.loadEagerSingletons(injector, errors, (BindingImpl)binding);
        }
        for (BindingImpl bindingImpl : injector.jitBindings.values()) {
            InjectorBuilder.loadEagerSingletons(injector, errors, bindingImpl);
        }
    }

    private static void loadEagerSingletons(InjectorImpl injector, final Errors errors, final BindingImpl<?> binding) {
        if (binding.getScoping() == Scoping.EAGER_SINGLETON) {
            try {
                injector.callInContext(new ContextualCallable<Void>(){
                    final Dependency<?> dependency;
                    {
                        this.dependency = Dependency.get(binding.getKey());
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Void call(InternalContext context) {
                        context.setDependency(this.dependency);
                        Errors errorsForBinding = errors.withSource(this.dependency);
                        try {
                            binding.getInternalFactory().get(errorsForBinding, context, this.dependency);
                        }
                        catch (ErrorsException e) {
                            errorsForBinding.merge(e.getErrors());
                        }
                        finally {
                            context.setDependency(null);
                        }
                        return null;
                    }
                });
            }
            catch (ErrorsException e) {
                throw new AssertionError();
            }
        }
    }
}

