/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.ThreadedActionListener;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.seqno.ReplicationTracker;
import org.elasticsearch.index.seqno.RetentionLease;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.seqno.SequenceNumbers;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.MultiChunkTransfer;
import org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.indices.recovery.plan.RecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.ShardRecoveryPlan;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.Transports;

public class RecoverySourceHandler {
    protected final Logger logger;
    private final IndexShard shard;
    private final StartRecoveryRequest request;
    private final int chunkSizeInBytes;
    private final RecoveryTargetHandler recoveryTarget;
    private final int maxConcurrentFileChunks;
    private final int maxConcurrentOperations;
    private final int maxConcurrentSnapshotFileDownloads;
    private final boolean useSnapshots;
    private final ThreadPool threadPool;
    private final RecoveryPlannerService recoveryPlannerService;
    private final CancellableThreads cancellableThreads = new CancellableThreads();
    private final List<Closeable> resources = new CopyOnWriteArrayList<Closeable>();
    private final SubscribableListener<RecoveryResponse> future = new SubscribableListener();

    public RecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, ThreadPool threadPool, StartRecoveryRequest request, int fileChunkSizeInBytes, int maxConcurrentFileChunks, int maxConcurrentOperations, int maxConcurrentSnapshotFileDownloads, boolean useSnapshots, RecoveryPlannerService recoveryPlannerService) {
        this.shard = shard;
        this.recoveryTarget = recoveryTarget;
        this.threadPool = threadPool;
        this.recoveryPlannerService = recoveryPlannerService;
        this.request = request;
        this.logger = Loggers.getLogger(this.getClass(), request.shardId(), "recover to " + request.targetNode().getName());
        this.chunkSizeInBytes = fileChunkSizeInBytes;
        this.maxConcurrentFileChunks = maxConcurrentFileChunks;
        this.maxConcurrentOperations = maxConcurrentOperations;
        this.maxConcurrentSnapshotFileDownloads = maxConcurrentSnapshotFileDownloads;
        this.useSnapshots = useSnapshots;
    }

    public StartRecoveryRequest getRequest() {
        return this.request;
    }

    public void addListener(ActionListener<RecoveryResponse> listener) {
        this.future.addListener(listener);
    }

    public void recoverToTarget(ActionListener<RecoveryResponse> listener) {
        this.addListener(listener);
        Closeable releaseResources = () -> IOUtils.close(this.resources);
        try {
            this.cancellableThreads.setOnCancel((reason, beforeCancelEx) -> {
                ElasticsearchException e = this.shard.state() == IndexShardState.CLOSED ? new IndexShardClosedException(this.shard.shardId(), "shard is closed and recovery was canceled reason [" + reason + "]") : new CancellableThreads.ExecutionCancelledException("recovery was canceled reason [" + reason + "]");
                if (beforeCancelEx != null) {
                    e.addSuppressed(beforeCancelEx);
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releaseResources, () -> this.future.onFailure(e)});
                throw e;
            });
            Consumer<Exception> onFailure = e -> {
                assert (Transports.assertNotTransportThread(String.valueOf(this) + "[onFailure]"));
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releaseResources, () -> this.future.onFailure((Exception)e)});
            };
            RecoverySourceHandler.runUnderPrimaryPermit((ActionListener<T> retentionLeaseListener) -> {
                IndexShardRoutingTable routingTable = this.shard.getReplicationGroup().getRoutingTable();
                ShardRouting targetShardRouting = routingTable.getByAllocationId(this.request.targetAllocationId());
                if (targetShardRouting == null) {
                    this.logger.debug("delaying recovery of {} as it is not listed as assigned to target node {}", (Object)this.request.shardId(), (Object)this.request.targetNode());
                    throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
                }
                assert (targetShardRouting.initializing()) : "expected recovery target to be initializing but was " + String.valueOf(targetShardRouting);
                retentionLeaseListener.onResponse(this.shard.getRetentionLeases().get(ReplicationTracker.getPeerRecoveryRetentionLeaseId(targetShardRouting)));
            }, this.shard, this.cancellableThreads, ActionListener.wrap(retentionLease -> this.recoverToTarget((RetentionLease)retentionLease, onFailure), onFailure));
        }
        catch (Exception e2) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releaseResources, () -> this.future.onFailure(e2)});
        }
    }

    private void recoverToTarget(RetentionLease retentionLease, Consumer<Exception> onFailure) throws IOException {
        long startingSeqNo;
        boolean isSequenceNumberBasedRecovery;
        Closeable retentionLock = this.shard.acquireHistoryRetentionLock();
        this.resources.add(retentionLock);
        boolean bl = isSequenceNumberBasedRecovery = this.request.startingSeqNo() != -2L && this.isTargetSameHistory() && this.shard.hasCompleteHistoryOperations("peer-recovery", this.request.startingSeqNo()) && (retentionLease == null && !this.shard.useRetentionLeasesInPeerRecovery() || retentionLease != null && retentionLease.retainingSequenceNumber() <= this.request.startingSeqNo());
        if (isSequenceNumberBasedRecovery && retentionLease != null) {
            retentionLock.close();
            this.logger.trace("history is retained by {}", (Object)retentionLease);
        } else {
            this.logger.trace("history is retained by retention lock");
        }
        SubscribableListener<SendFileResult> sendFileStep = new SubscribableListener<SendFileResult>();
        SubscribableListener prepareEngineStep = new SubscribableListener();
        SubscribableListener sendSnapshotStep = new SubscribableListener();
        SubscribableListener finalizeStep = new SubscribableListener();
        AtomicReference sendSnapshotStepResult = new AtomicReference();
        AtomicReference sendFileStepResult = new AtomicReference();
        AtomicLong prepareEngineTimeMillisRef = new AtomicLong();
        if (isSequenceNumberBasedRecovery) {
            this.logger.trace("performing sequence numbers based recovery. starting at [{}]", (Object)this.request.startingSeqNo());
            startingSeqNo = this.request.startingSeqNo();
            if (retentionLease == null) {
                this.createRetentionLease(startingSeqNo, sendFileStep.map(ignored -> SendFileResult.EMPTY));
            } else {
                sendFileStep.onResponse(SendFileResult.EMPTY);
            }
        } else {
            Engine.IndexCommitRef safeCommitRef;
            try {
                safeCommitRef = this.acquireSafeCommit(this.shard);
                this.resources.add(safeCommitRef);
            }
            catch (Exception e2) {
                throw new RecoveryEngineException(this.shard.shardId(), 1, "snapshot failed", e2);
            }
            startingSeqNo = Long.parseLong((String)safeCommitRef.getIndexCommit().getUserData().get("local_checkpoint")) + 1L;
            this.logger.trace("performing file-based recovery followed by history replay starting at [{}]", (Object)startingSeqNo);
            try {
                int estimateNumOps = this.estimateNumberOfHistoryOperations(startingSeqNo);
                Releasable releaseStore = this.acquireStore(this.shard.store());
                this.resources.add((Closeable)releaseStore);
                sendFileStep.addListener(ActionListener.wrap(r -> IOUtils.close((Closeable[])new Closeable[]{safeCommitRef, releaseStore}), e -> {
                    try {
                        IOUtils.close((Closeable[])new Closeable[]{safeCommitRef, releaseStore});
                    }
                    catch (Exception ex) {
                        this.logger.warn("releasing snapshot caused exception", (Throwable)ex);
                    }
                }));
                this.deleteRetentionLease(ActionListener.wrap(ignored -> {
                    assert (Transports.assertNotTransportThread(String.valueOf(this) + "[phase1]"));
                    this.phase1(safeCommitRef.getIndexCommit(), startingSeqNo, () -> estimateNumOps, sendFileStep);
                }, onFailure));
            }
            catch (Exception e3) {
                throw new RecoveryEngineException(this.shard.shardId(), 1, "sendFileStep failed", e3);
            }
        }
        assert (startingSeqNo >= 0L) : "startingSeqNo must be non negative. got: " + startingSeqNo;
        sendFileStep.addListener(ActionListener.wrap(r -> {
            assert (Transports.assertNotTransportThread(String.valueOf(this) + "[prepareTargetForTranslog]"));
            sendFileStepResult.set(r);
            this.prepareTargetForTranslog(this.estimateNumberOfHistoryOperations(startingSeqNo), prepareEngineStep);
        }, onFailure));
        prepareEngineStep.addListener(ActionListener.wrap(prepareEngineTime -> {
            assert (Transports.assertNotTransportThread(String.valueOf(this) + "[phase2]"));
            prepareEngineTimeMillisRef.set(prepareEngineTime.millis());
            RecoverySourceHandler.runUnderPrimaryPermit(() -> this.shard.initiateTracking(this.request.targetAllocationId()), this.shard, this.cancellableThreads, ActionListener.wrap(ignored -> {
                long endingSeqNo = this.shard.seqNoStats().getMaxSeqNo();
                this.logger.trace("snapshot for recovery; current size is [{}]", (Object)this.estimateNumberOfHistoryOperations(startingSeqNo));
                Translog.Snapshot phase2Snapshot = this.shard.newChangesSnapshot("peer-recovery", startingSeqNo, Long.MAX_VALUE, false, false, true, this.chunkSizeInBytes);
                this.resources.add(phase2Snapshot);
                retentionLock.close();
                long maxSeenAutoIdTimestamp = this.shard.getMaxSeenAutoIdTimestamp();
                long maxSeqNoOfUpdatesOrDeletes = this.shard.getMaxSeqNoOfUpdatesOrDeletes();
                RetentionLeases retentionLeases = this.shard.getRetentionLeases();
                long mappingVersionOnPrimary = this.shard.indexSettings().getIndexMetadata().getMappingVersion();
                this.phase2(startingSeqNo, endingSeqNo, phase2Snapshot, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersionOnPrimary, sendSnapshotStep);
            }, onFailure));
        }, onFailure));
        long trimAboveSeqNo = startingSeqNo - 1L;
        sendSnapshotStep.addListener(ActionListener.wrap(r -> {
            sendSnapshotStepResult.set(r);
            this.finalizeRecovery(r.targetLocalCheckpoint, trimAboveSeqNo, finalizeStep);
        }, onFailure));
        finalizeStep.addListener(ActionListener.wrap(r -> {
            long phase1ThrottlingWaitTime = 0L;
            SendSnapshotResult sendSnapshotResult = (SendSnapshotResult)sendSnapshotStepResult.get();
            SendFileResult sendFileResult = (SendFileResult)sendFileStepResult.get();
            RecoveryResponse response = new RecoveryResponse(sendFileResult.phase1FileNames, sendFileResult.phase1FileSizes, sendFileResult.phase1ExistingFileNames, sendFileResult.phase1ExistingFileSizes, sendFileResult.totalSize, sendFileResult.existingTotalSize, sendFileResult.took.millis(), 0L, prepareEngineTimeMillisRef.get(), sendSnapshotResult.sentOperations, sendSnapshotResult.tookTime.millis());
            try {
                this.future.onResponse(response);
            }
            finally {
                IOUtils.close(this.resources);
            }
        }, onFailure));
    }

    private boolean isTargetSameHistory() {
        String targetHistoryUUID = this.request.metadataSnapshot().getHistoryUUID();
        assert (targetHistoryUUID != null) : "incoming target history missing";
        return targetHistoryUUID.equals(this.shard.getHistoryUUID());
    }

    private int estimateNumberOfHistoryOperations(long startingSeqNo) throws IOException {
        return this.shard.countChanges("peer-recovery", startingSeqNo, Long.MAX_VALUE);
    }

    static <T> void runUnderPrimaryPermit(Consumer<ActionListener<T>> action, IndexShard primary, CancellableThreads cancellableThreads, ActionListener<T> listener) {
        primary.acquirePrimaryOperationPermit(listener.delegateFailure((l1, permit) -> ActionListener.run(new ActionListener<T>(){
            final /* synthetic */ ActionListener val$l1;
            final /* synthetic */ Releasable val$permit;
            final /* synthetic */ CancellableThreads val$cancellableThreads;
            {
                this.val$l1 = actionListener;
                this.val$permit = releasable;
                this.val$cancellableThreads = cancellableThreads;
            }

            @Override
            public void onResponse(T result) {
                ActionListener.completeWith(this.val$l1, () -> {
                    try (Releasable releasable = this.val$permit;){
                        this.val$cancellableThreads.checkForCancel();
                    }
                    return result;
                });
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    Releasables.closeExpectNoException((Releasable)this.val$permit);
                }
                finally {
                    this.val$l1.onFailure(e);
                }
            }
        }, l2 -> {
            cancellableThreads.checkForCancel();
            RecoverySourceHandler.ensureNotRelocatedPrimary(primary);
            action.accept((ActionListener)l2);
        })), primary.getThreadPool().generic());
    }

    static void runUnderPrimaryPermit(Runnable action, IndexShard primary, CancellableThreads cancellableThreads, ActionListener<Void> listener) {
        RecoverySourceHandler.runUnderPrimaryPermit((ActionListener<T> l) -> ActionListener.completeWith(l, () -> {
            action.run();
            return null;
        }), primary, cancellableThreads, listener);
    }

    private static void ensureNotRelocatedPrimary(IndexShard indexShard) {
        if (indexShard.isRelocatedPrimary()) {
            throw new IndexShardRelocatedException(indexShard.shardId());
        }
    }

    private Releasable acquireStore(Store store) {
        store.incRef();
        return Releasables.releaseOnce(() -> this.closeOnGenericThreadPool(store::decRef));
    }

    private Engine.IndexCommitRef acquireSafeCommit(IndexShard shard) {
        Engine.IndexCommitRef commitRef = shard.acquireSafeIndexCommit();
        return new Engine.IndexCommitRef(commitRef.getIndexCommit(), (CheckedRunnable<IOException>)((CheckedRunnable)() -> this.closeOnGenericThreadPool(commitRef)));
    }

    private void closeOnGenericThreadPool(Closeable closeable) {
        assert (!this.threadPool.generic().isShutdown());
        this.threadPool.generic().execute(() -> {
            try {
                closeable.close();
            }
            catch (Exception e) {
                assert (false) : e;
                this.logger.warn(() -> Strings.format((String)"Exception while closing [%s]", (Object[])new Object[]{closeable}), (Throwable)e);
            }
        });
    }

    void phase1(IndexCommit snapshot, long startingSeqNo, IntSupplier translogOps, ActionListener<SendFileResult> listener) {
        this.cancellableThreads.checkForCancel();
        Store store = this.shard.store();
        try {
            String shardStateIdentifier;
            Store.MetadataSnapshot recoverySourceMetadata;
            StopWatch stopWatch = new StopWatch().start();
            try {
                recoverySourceMetadata = store.getMetadata(snapshot);
                shardStateIdentifier = SnapshotShardsService.getShardStateId(this.shard, snapshot);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                this.shard.failShard("recovery", (Exception)ex);
                throw ex;
            }
            for (String name : snapshot.getFileNames()) {
                StoreFileMetadata md = recoverySourceMetadata.get(name);
                if (md != null) continue;
                this.logger.info("Snapshot differs from actual index for file: {} meta: {}", (Object)name, recoverySourceMetadata.fileMetadataMap());
                throw new CorruptIndexException("Snapshot differs from actual index - maybe index was removed metadata has " + recoverySourceMetadata.fileMetadataMap().size() + " files", name);
            }
            if (!this.hasSameLegacySyncId(recoverySourceMetadata, this.request.metadataSnapshot())) {
                this.cancellableThreads.checkForCancel();
                SubscribableListener.newForked(l -> this.recoveryPlannerService.computeRecoveryPlan(this.shard.shardId(), shardStateIdentifier, recoverySourceMetadata, this.request.metadataSnapshot(), startingSeqNo, translogOps.getAsInt(), this.getRequest().targetNode().getMaxIndexVersion(), this.canUseSnapshots(), this.request.isPrimaryRelocation(), (ActionListener<ShardRecoveryPlan>)l)).andThen((l, plan) -> this.recoverFilesFromSourceAndSnapshot((ShardRecoveryPlan)plan, store, stopWatch, (ActionListener<SendFileResult>)l)).addListener(listener);
            } else {
                this.logger.trace("skipping [phase1] since source and target have identical sync id [{}]", (Object)recoverySourceMetadata.getSyncId());
                SubscribableListener.newForked(leaseListener -> this.createRetentionLease(startingSeqNo, (ActionListener<RetentionLease>)leaseListener)).andThenApply(ignored -> {
                    TimeValue took = stopWatch.totalTime();
                    this.logger.trace("recovery [phase1]: took [{}]", (Object)took);
                    return new SendFileResult(Collections.emptyList(), Collections.emptyList(), 0L, Collections.emptyList(), Collections.emptyList(), 0L, took);
                }).addListener(listener);
            }
        }
        catch (Exception e) {
            throw new RecoverFilesRecoveryException(this.request.shardId(), 0, ByteSizeValue.ZERO, e);
        }
    }

    private boolean canUseSnapshots() {
        return this.useSnapshots && this.request.canDownloadSnapshotFiles() && !this.shard.indexSettings().getIndexMetadata().isSearchableSnapshot();
    }

    void recoverFilesFromSourceAndSnapshot(ShardRecoveryPlan shardRecoveryPlan, Store store, StopWatch stopWatch, ActionListener<SendFileResult> listener) {
        if (this.logger.isTraceEnabled()) {
            for (StoreFileMetadata md : shardRecoveryPlan.getFilesPresentInTarget()) {
                this.logger.trace("recovery [phase1]: not recovering [{}], exist in local store and has checksum [{}], size [{}]", (Object)md.name(), (Object)md.checksum(), (Object)md.length());
            }
            for (StoreFileMetadata md : shardRecoveryPlan.getSourceFilesToRecover()) {
                if (this.request.metadataSnapshot().fileMetadataMap().containsKey(md.name())) {
                    this.logger.trace("recovery [phase1]: recovering [{}] from peer, exists in local store but is different: remote [{}], local [{}]", (Object)md.name(), (Object)this.request.metadataSnapshot().fileMetadataMap().get(md.name()), (Object)md);
                    continue;
                }
                this.logger.trace("recovery [phase1]: recovering [{}] from peer, does not exist in remote", (Object)md.name());
            }
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : shardRecoveryPlan.getSnapshotFilesToRecover()) {
                StoreFileMetadata md = fileInfo.metadata();
                if (this.request.metadataSnapshot().fileMetadataMap().containsKey(md.name())) {
                    this.logger.trace("recovery [phase1]: recovering [{}] from snapshot, exists in local store but is different: remote [{}], local [{}]", (Object)md.name(), (Object)this.request.metadataSnapshot().fileMetadataMap().get(md.name()), (Object)md);
                    continue;
                }
                this.logger.trace("recovery [phase1]: recovering [{}] from snapshot, does not exist in remote", (Object)md.name());
            }
            long totalSize = shardRecoveryPlan.getTotalSize();
            long existingTotalSize = shardRecoveryPlan.getExistingSize();
            this.logger.trace("recovery [phase1]: total_size[{}], recovering_files [{}] with total_size [{}] from peer, recovering_files [{}] with total_size [{}] from snapshot, reusing_files [{}] with total_size [{}]", (Object)ByteSizeValue.ofBytes(totalSize), (Object)shardRecoveryPlan.getSourceFilesToRecover().size(), (Object)ByteSizeValue.ofBytes(shardRecoveryPlan.getSourceFilesToRecover().stream().mapToLong(StoreFileMetadata::length).sum()), (Object)shardRecoveryPlan.getSnapshotFilesToRecover().size(), (Object)ByteSizeValue.ofBytes(shardRecoveryPlan.getSnapshotFilesToRecover().snapshotFiles().stream().mapToLong(BlobStoreIndexShardSnapshot.FileInfo::length).sum()), (Object)shardRecoveryPlan.getFilesPresentInTarget().size(), (Object)ByteSizeValue.ofBytes(existingTotalSize));
        }
        new FileBasedRecoveryContext(store, stopWatch, shardRecoveryPlan).run(listener);
    }

    void recoverSnapshotFiles(ShardRecoveryPlan shardRecoveryPlan, ActionListener<List<StoreFileMetadata>> listener) {
        ShardRecoveryPlan.SnapshotFilesToRecover snapshotFilesToRecover = shardRecoveryPlan.getSnapshotFilesToRecover();
        if (snapshotFilesToRecover.isEmpty()) {
            listener.onResponse(Collections.emptyList());
            return;
        }
        new SnapshotRecoverFileRequestsSender(shardRecoveryPlan, listener).start();
    }

    void createRetentionLease(long startingSeqNo, ActionListener<RetentionLease> listener) {
        this.updateRetentionLease(syncListener -> {
            String targetNodeId = this.request.targetNode().getId();
            this.logger.trace("cloning primary's retention lease for target node ID [{}]", (Object)targetNodeId);
            ActionListener<ReplicationResponse> backgroundSyncListener = this.wrapLeaseSyncListener((ActionListener<Void>)syncListener);
            try {
                RetentionLease clonedLease = this.shard.cloneLocalPeerRecoveryRetentionLease(targetNodeId, backgroundSyncListener);
                this.logger.trace("cloned primary's retention lease as [{}]", (Object)clonedLease);
                return clonedLease;
            }
            catch (RetentionLeaseNotFoundException e) {
                assert (this.shard.indexSettings().getIndexVersionCreated().before(IndexVersions.V_7_4_0) || !this.shard.indexSettings().isSoftDeleteEnabled());
                long estimatedGlobalCheckpoint = startingSeqNo - 1L;
                RetentionLease newLease = this.shard.addPeerRecoveryRetentionLease(targetNodeId, estimatedGlobalCheckpoint, backgroundSyncListener);
                this.logger.trace("created retention lease with estimated checkpoint of [{}]", (Object)estimatedGlobalCheckpoint);
                return newLease;
            }
        }, listener);
    }

    private void deleteRetentionLease(ActionListener<Void> listener) {
        this.updateRetentionLease(syncListener -> {
            try {
                this.shard.removePeerRecoveryRetentionLease(this.request.targetNode().getId(), this.wrapLeaseSyncListener((ActionListener<Void>)syncListener));
            }
            catch (RetentionLeaseNotFoundException e) {
                this.logger.debug("no peer-recovery retention lease for [{}]", (Object)this.request.targetAllocationId());
                syncListener.onResponse(null);
            }
            return null;
        }, listener);
    }

    private <R> void updateRetentionLease(Function<ActionListener<Void>, R> updateLeaseFunction, ActionListener<R> outerListener) {
        SubscribableListener leasesSyncedStep = new SubscribableListener();
        RecoverySourceHandler.runUnderPrimaryPermit((ActionListener<T> resultListener) -> ActionListener.completeWith(resultListener, () -> updateLeaseFunction.apply(leasesSyncedStep)), this.shard, this.cancellableThreads, outerListener.delegateFailure((l, result) -> leasesSyncedStep.addListener(l.map(ignored -> result))));
    }

    private ActionListener<ReplicationResponse> wrapLeaseSyncListener(ActionListener<Void> listener) {
        return new ThreadedActionListener<Void>(this.shard.getThreadPool().generic(), listener).map(ignored -> null);
    }

    boolean hasSameLegacySyncId(Store.MetadataSnapshot source, Store.MetadataSnapshot target) {
        if (source.getSyncId() == null || !source.getSyncId().equals(target.getSyncId())) {
            return false;
        }
        if (source.numDocs() != target.numDocs()) {
            throw new IllegalStateException("try to recover " + String.valueOf(this.request.shardId()) + " from primary shard with sync id but number of docs differ: " + source.numDocs() + " (" + this.request.sourceNode().getName() + ", primary) vs " + target.numDocs() + "(" + this.request.targetNode().getName() + ")");
        }
        SequenceNumbers.CommitInfo sourceSeqNos = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(source.commitUserData().entrySet());
        SequenceNumbers.CommitInfo targetSeqNos = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(target.commitUserData().entrySet());
        if (sourceSeqNos.localCheckpoint() != targetSeqNos.localCheckpoint() || targetSeqNos.maxSeqNo() != sourceSeqNos.maxSeqNo()) {
            String message = "try to recover " + String.valueOf(this.request.shardId()) + " with sync id but seq_no stats are mismatched: [" + String.valueOf(source.commitUserData()) + "] vs [" + String.valueOf(target.commitUserData()) + "]";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
        return true;
    }

    void prepareTargetForTranslog(int totalTranslogOps, ActionListener<TimeValue> listener) {
        StopWatch stopWatch = new StopWatch().start();
        ActionListener<Void> wrappedListener = ActionListener.wrap(nullVal -> {
            stopWatch.stop();
            TimeValue tookTime = stopWatch.totalTime();
            this.logger.trace("recovery [phase1]: remote engine start took [{}]", (Object)tookTime);
            listener.onResponse(tookTime);
        }, e -> listener.onFailure(new RecoveryEngineException(this.shard.shardId(), 1, "prepare target for translog failed", (Throwable)e)));
        this.logger.trace("recovery [phase1]: prepare remote engine for translog");
        this.cancellableThreads.checkForCancel();
        this.recoveryTarget.prepareForTranslogOperations(totalTranslogOps, wrappedListener);
    }

    void phase2(long startingSeqNo, long endingSeqNo, Translog.Snapshot snapshot, long maxSeenAutoIdTimestamp, long maxSeqNoOfUpdatesOrDeletes, RetentionLeases retentionLeases, long mappingVersion, ActionListener<SendSnapshotResult> listener) throws IOException {
        if (this.shard.state() == IndexShardState.CLOSED) {
            throw new IndexShardClosedException(this.request.shardId());
        }
        this.logger.trace("recovery [phase2]: sending transaction log operations (from [" + startingSeqNo + "] to [" + endingSeqNo + "]");
        StopWatch stopWatch = new StopWatch().start();
        SubscribableListener<Void> sendListener = new SubscribableListener<Void>();
        OperationBatchSender sender = new OperationBatchSender(startingSeqNo, endingSeqNo, snapshot, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersion, sendListener);
        sendListener.addListener(listener.delegateFailureAndWrap((delegate, ignored) -> {
            long skippedOps = sender.skippedOps.get();
            int totalSentOps = sender.sentOps.get();
            long targetLocalCheckpoint = sender.targetLocalCheckpoint.get();
            assert ((long)snapshot.totalOperations() == (long)snapshot.skippedOperations() + skippedOps + (long)totalSentOps) : String.format(Locale.ROOT, "expected total [%d], overridden [%d], skipped [%d], total sent [%d]", snapshot.totalOperations(), snapshot.skippedOperations(), skippedOps, totalSentOps);
            stopWatch.stop();
            TimeValue tookTime = stopWatch.totalTime();
            this.logger.trace("recovery [phase2]: took [{}]", (Object)tookTime);
            delegate.onResponse(new SendSnapshotResult(targetLocalCheckpoint, totalSentOps, tookTime));
        }));
        sender.start();
    }

    void finalizeRecovery(long targetLocalCheckpoint, long trimAboveSeqNo, ActionListener<Void> listener) {
        SubscribableListener<Void> finalStep;
        if (this.shard.state() == IndexShardState.CLOSED) {
            throw new IndexShardClosedException(this.request.shardId());
        }
        this.cancellableThreads.checkForCancel();
        StopWatch stopWatch = new StopWatch().start();
        this.logger.trace("finalizing recovery");
        SubscribableListener<Void> markInSyncStep = new SubscribableListener<Void>();
        RecoverySourceHandler.runUnderPrimaryPermit(() -> this.cancellableThreads.execute(() -> this.shard.markAllocationIdAsInSync(this.request.targetAllocationId(), targetLocalCheckpoint)), this.shard, this.cancellableThreads, markInSyncStep);
        SubscribableListener<Long> finalizeListener = new SubscribableListener<Long>();
        markInSyncStep.addListener(listener.delegateFailureAndWrap((l, ignored) -> {
            long globalCheckpoint = this.shard.getLastKnownGlobalCheckpoint();
            this.cancellableThreads.checkForCancel();
            this.recoveryTarget.finalizeRecovery(globalCheckpoint, trimAboveSeqNo, finalizeListener.map(ignored2 -> globalCheckpoint));
        }));
        SubscribableListener<Void> updateGlobalCheckpointStep = new SubscribableListener<Void>();
        finalizeListener.addListener(listener.delegateFailureAndWrap((l, globalCheckpoint) -> RecoverySourceHandler.runUnderPrimaryPermit(() -> this.shard.updateGlobalCheckpointForShard(this.request.targetAllocationId(), (long)globalCheckpoint), this.shard, this.cancellableThreads, updateGlobalCheckpointStep)));
        if (this.request.isPrimaryRelocation()) {
            finalStep = new SubscribableListener();
            updateGlobalCheckpointStep.addListener(listener.delegateFailureAndWrap((l, ignored) -> {
                this.logger.trace("performing relocation hand-off");
                this.cancellableThreads.execute(() -> this.shard.relocated(this.request.targetNode().getId(), this.request.targetAllocationId(), this.recoveryTarget::handoffPrimaryContext, finalStep));
            }));
        } else {
            finalStep = updateGlobalCheckpointStep;
        }
        finalStep.addListener(listener.delegateFailureAndWrap((l, ignored) -> {
            this.cancellableThreads.checkForCancel();
            this.completeFinalizationListener((ActionListener<Void>)l, stopWatch);
        }));
    }

    private void completeFinalizationListener(ActionListener<Void> listener, StopWatch stopWatch) {
        stopWatch.stop();
        this.logger.trace("finalizing recovery took [{}]", (Object)stopWatch.totalTime());
        listener.onResponse(null);
    }

    public void cancel(String reason) {
        this.cancellableThreads.cancel(reason);
        this.recoveryTarget.cancel();
    }

    public String toString() {
        return "ShardRecoveryHandler{shardId=" + String.valueOf(this.request.shardId()) + ", sourceNode=" + String.valueOf(this.request.sourceNode()) + ", targetNode=" + String.valueOf(this.request.targetNode()) + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFiles(final Store store, StoreFileMetadata[] files, final IntSupplier translogOps, ActionListener<Void> listener) {
        ArrayUtil.timSort((Object[])files, Comparator.comparingLong(StoreFileMetadata::length));
        final int bufferSize = files.length == 0 ? 0 : (int)Math.min((long)this.chunkSizeInBytes, files[files.length - 1].length());
        Releasable temporaryStoreRef = this.acquireStore(store);
        try {
            final Releasable storeRef = temporaryStoreRef;
            MultiChunkTransfer<StoreFileMetadata, FileChunk> multiFileSender = new MultiChunkTransfer<StoreFileMetadata, FileChunk>(this.logger, this.threadPool.getThreadContext(), listener, this.maxConcurrentFileChunks, Arrays.asList(files)){
                final Deque<byte[]> buffers;
                final AtomicInteger liveBufferCount;
                IndexInput currentInput;
                long offset;
                {
                    super(logger, threadContext, listener, maxConcurrentChunks, sources);
                    this.buffers = new ConcurrentLinkedDeque<byte[]>();
                    this.liveBufferCount = new AtomicInteger();
                    this.currentInput = null;
                    this.offset = 0L;
                }

                @Override
                protected void onNewResource(StoreFileMetadata md) throws IOException {
                    this.offset = 0L;
                    IOUtils.close((Closeable)this.currentInput);
                    this.currentInput = md.hashEqualsContents() ? null : store.directory().openInput(md.name(), IOContext.READ);
                }

                @Override
                protected FileChunk nextChunkRequest(StoreFileMetadata md) throws IOException {
                    assert (Transports.assertNotTransportThread("read file chunk"));
                    RecoverySourceHandler.this.cancellableThreads.checkForCancel();
                    if (this.currentInput == null) {
                        assert (md.hashEqualsContents());
                        return new FileChunk(md, new BytesArray(md.hash()), 0L, true, () -> {});
                    }
                    byte[] buffer = Objects.requireNonNullElseGet(this.buffers.pollFirst(), () -> new byte[bufferSize]);
                    assert (this.liveBufferCount.incrementAndGet() > 0);
                    int toRead = Math.toIntExact(Math.min(md.length() - this.offset, (long)buffer.length));
                    this.currentInput.readBytes(buffer, 0, toRead, false);
                    boolean lastChunk = this.offset + (long)toRead == md.length();
                    FileChunk chunk = new FileChunk(md, new BytesArray(buffer, 0, toRead), this.offset, lastChunk, () -> {
                        assert (this.liveBufferCount.decrementAndGet() >= 0);
                        this.buffers.addFirst(buffer);
                    });
                    this.offset += (long)toRead;
                    return chunk;
                }

                @Override
                protected void executeChunkRequest(FileChunk request, ActionListener<Void> listener) {
                    RecoverySourceHandler.this.cancellableThreads.checkForCancel();
                    ReleasableBytesReference content = new ReleasableBytesReference(request.content, request);
                    RecoverySourceHandler.this.recoveryTarget.writeFileChunk(request.md, request.position, content, request.lastChunk, translogOps.getAsInt(), ActionListener.runBefore(listener, content::close));
                }

                @Override
                protected void handleError(StoreFileMetadata md, Exception e) throws Exception {
                    RecoverySourceHandler.this.handleErrorOnSendFiles(store, e, new StoreFileMetadata[]{md});
                }

                @Override
                public void close() throws IOException {
                    IOUtils.close((Closeable[])new Closeable[]{this.currentInput, storeRef});
                }

                @Override
                protected boolean assertOnSuccess() {
                    assert (this.liveBufferCount.get() == 0) : "leaked [" + String.valueOf(this.liveBufferCount) + "] buffers";
                    return true;
                }
            };
            this.resources.add(multiFileSender);
            temporaryStoreRef = null;
            multiFileSender.start();
        }
        finally {
            Releasables.close((Releasable)temporaryStoreRef);
        }
    }

    private void cleanFiles(Store store, Store.MetadataSnapshot sourceMetadata, IntSupplier translogOps, long globalCheckpoint, ActionListener<Void> listener) {
        this.cancellableThreads.checkForCancel();
        this.recoveryTarget.cleanFiles(translogOps.getAsInt(), globalCheckpoint, sourceMetadata, listener.delegateResponse((l, e) -> ActionListener.completeWith(l, () -> {
            Object[] mds = (StoreFileMetadata[])StreamSupport.stream(sourceMetadata.spliterator(), false).toArray(StoreFileMetadata[]::new);
            ArrayUtil.timSort((Object[])mds, Comparator.comparingLong(StoreFileMetadata::length));
            this.handleErrorOnSendFiles(store, (Exception)e, (StoreFileMetadata[])mds);
            throw e;
        })));
    }

    private void handleErrorOnSendFiles(Store store, Exception e, StoreFileMetadata[] mds) throws Exception {
        IOException corruptIndexException = ExceptionsHelper.unwrapCorruption(e);
        assert (Transports.assertNotTransportThread(String.valueOf(this) + "[handle error on send/clean files]"));
        if (corruptIndexException != null) {
            IOException localException = null;
            for (StoreFileMetadata md : mds) {
                this.cancellableThreads.checkForCancel();
                this.logger.debug("checking integrity for file {} after remove corruption exception", (Object)md);
                if (store.checkIntegrityNoException(md)) continue;
                this.logger.warn("Corrupted file detected {} checksum mismatch", (Object)md);
                if (localException == null) {
                    localException = corruptIndexException;
                }
                this.failEngine(corruptIndexException);
            }
            if (localException != null) {
                throw localException;
            }
            RemoteTransportException remoteException = new RemoteTransportException("File corruption occurred on recovery but checksums are ok", null);
            remoteException.addSuppressed(e);
            this.logger.warn(() -> Strings.format((String)"Remote file corruption on node %s, recovering %s. local checksum OK", (Object[])new Object[]{this.request.targetNode(), mds}), (Throwable)corruptIndexException);
            throw remoteException;
        }
        throw e;
    }

    protected void failEngine(IOException cause) {
        this.shard.failShard("recovery", cause);
    }

    record SendFileResult(List<String> phase1FileNames, List<Long> phase1FileSizes, long totalSize, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, long existingTotalSize, TimeValue took) {
        static final SendFileResult EMPTY = new SendFileResult(Collections.emptyList(), Collections.emptyList(), 0L, Collections.emptyList(), Collections.emptyList(), 0L, TimeValue.ZERO);
    }

    private class FileBasedRecoveryContext {
        private final Store store;
        private final StopWatch stopWatch;
        private final int translogOps;
        private ShardRecoveryPlan shardRecoveryPlan;

        FileBasedRecoveryContext(Store store, StopWatch stopWatch, ShardRecoveryPlan shardRecoveryPlan) {
            this.store = store;
            this.stopWatch = stopWatch;
            this.translogOps = shardRecoveryPlan.getTranslogOps();
            this.shardRecoveryPlan = shardRecoveryPlan;
        }

        private void sendShardRecoveryPlanFileInfo(ActionListener<Void> fileInfoListener) {
            RecoverySourceHandler.this.recoveryTarget.receiveFileInfo(this.shardRecoveryPlan.getFilesToRecoverNames(), this.shardRecoveryPlan.getFilesToRecoverSizes(), this.shardRecoveryPlan.getFilesPresentInTargetNames(), this.shardRecoveryPlan.getFilesPresentInTargetSizes(), this.shardRecoveryPlan.getTranslogOps(), fileInfoListener);
        }

        void run(ActionListener<SendFileResult> listener) {
            RecoverySourceHandler.this.cancellableThreads.checkForCancel();
            SubscribableListener.newForked(this::sendShardRecoveryPlanFileInfo).andThen(l -> RecoverySourceHandler.this.recoverSnapshotFiles(this.shardRecoveryPlan, l.delegateResponse((recoverSnapshotFilesListener, e) -> {
                if (!this.shardRecoveryPlan.canRecoverSnapshotFilesFromSourceNode() && !(e instanceof CancellableThreads.ExecutionCancelledException)) {
                    this.shardRecoveryPlan = this.shardRecoveryPlan.getFallbackPlan();
                    this.sendShardRecoveryPlanFileInfo(recoverSnapshotFilesListener.map(r -> Collections.emptyList()));
                } else {
                    recoverSnapshotFilesListener.onFailure((Exception)e);
                }
            }))).andThen((sendFilesListener, filesFailedToRecoverFromSnapshot) -> {
                List<StoreFileMetadata> filesToRecoverFromSource = filesFailedToRecoverFromSnapshot.isEmpty() ? this.shardRecoveryPlan.getSourceFilesToRecover() : CollectionUtils.concatLists(this.shardRecoveryPlan.getSourceFilesToRecover(), filesFailedToRecoverFromSnapshot);
                RecoverySourceHandler.this.sendFiles(this.store, filesToRecoverFromSource.toArray(new StoreFileMetadata[0]), this.shardRecoveryPlan::getTranslogOps, (ActionListener<Void>)sendFilesListener);
            }).andThen(createRetentionLeaseListener -> RecoverySourceHandler.this.createRetentionLease(this.shardRecoveryPlan.getStartingSeqNo(), (ActionListener<RetentionLease>)createRetentionLeaseListener)).andThen((finalRecoveryPlanListener, retentionLease) -> {
                Store.MetadataSnapshot recoverySourceMetadata = this.shardRecoveryPlan.getSourceMetadataSnapshot();
                long lastKnownGlobalCheckpoint = RecoverySourceHandler.this.shard.getLastKnownGlobalCheckpoint();
                assert (retentionLease == null || retentionLease.retainingSequenceNumber() - 1L <= lastKnownGlobalCheckpoint) : String.valueOf(retentionLease) + " vs " + lastKnownGlobalCheckpoint;
                RecoverySourceHandler.this.cleanFiles(this.store, recoverySourceMetadata, () -> this.translogOps, lastKnownGlobalCheckpoint, (ActionListener<Void>)finalRecoveryPlanListener);
            }).andThenApply(ignored -> {
                TimeValue took = this.stopWatch.totalTime();
                RecoverySourceHandler.this.logger.trace("recovery [phase1]: took [{}]", (Object)took);
                return new SendFileResult(this.shardRecoveryPlan.getFilesToRecoverNames(), this.shardRecoveryPlan.getFilesToRecoverSizes(), this.shardRecoveryPlan.getTotalSize(), this.shardRecoveryPlan.getFilesPresentInTargetNames(), this.shardRecoveryPlan.getFilesPresentInTargetSizes(), this.shardRecoveryPlan.getExistingSize(), took);
            }).addListener(listener);
        }
    }

    private class SnapshotRecoverFileRequestsSender {
        private final ShardRecoveryPlan shardRecoveryPlan;
        private final ShardRecoveryPlan.SnapshotFilesToRecover snapshotFilesToRecover;
        private final ActionListener<List<StoreFileMetadata>> listener;
        private final CountDown countDown;
        private final BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> pendingSnapshotFilesToRecover;
        private final AtomicBoolean cancelled = new AtomicBoolean();
        private final Set<SubscribableListener<Void>> outstandingRequests;
        private List<StoreFileMetadata> filesFailedToDownloadFromSnapshot;

        SnapshotRecoverFileRequestsSender(ShardRecoveryPlan shardRecoveryPlan, ActionListener<List<StoreFileMetadata>> listener) {
            this.outstandingRequests = Sets.newHashSetWithExpectedSize(RecoverySourceHandler.this.maxConcurrentSnapshotFileDownloads);
            this.shardRecoveryPlan = shardRecoveryPlan;
            this.snapshotFilesToRecover = shardRecoveryPlan.getSnapshotFilesToRecover();
            this.listener = listener;
            this.countDown = new CountDown(shardRecoveryPlan.getSnapshotFilesToRecover().size());
            this.pendingSnapshotFilesToRecover = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>(shardRecoveryPlan.getSnapshotFilesToRecover().snapshotFiles());
        }

        void start() {
            for (int i = 0; i < RecoverySourceHandler.this.maxConcurrentSnapshotFileDownloads; ++i) {
                this.sendRequest();
            }
        }

        void sendRequest() {
            final BlobStoreIndexShardSnapshot.FileInfo snapshotFileToRecover = (BlobStoreIndexShardSnapshot.FileInfo)this.pendingSnapshotFilesToRecover.poll();
            if (snapshotFileToRecover == null) {
                return;
            }
            SubscribableListener<Void> requestFuture = new SubscribableListener<Void>();
            try {
                RecoverySourceHandler.this.cancellableThreads.checkForCancel();
                ActionListener<Void> sendRequestListener = new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void unused) {
                        SnapshotRecoverFileRequestsSender.this.onRequestCompletion(snapshotFileToRecover.metadata(), null);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        if (SnapshotRecoverFileRequestsSender.this.cancelled.get() || e instanceof CancellableThreads.ExecutionCancelledException) {
                            RecoverySourceHandler.this.logger.debug(() -> Strings.format((String)"cancelled while recovering file [%s] from snapshot", (Object[])new Object[]{snapshotFileToRecover.metadata()}), (Throwable)e);
                        } else {
                            RecoverySourceHandler.this.logger.warn(() -> Strings.format((String)"failed to recover file [%s] from snapshot%s", (Object[])new Object[]{snapshotFileToRecover.metadata(), SnapshotRecoverFileRequestsSender.this.shardRecoveryPlan.canRecoverSnapshotFilesFromSourceNode() ? ", will recover from primary instead" : ""}), (Throwable)e);
                        }
                        if (SnapshotRecoverFileRequestsSender.this.shardRecoveryPlan.canRecoverSnapshotFilesFromSourceNode()) {
                            SnapshotRecoverFileRequestsSender.this.onRequestCompletion(snapshotFileToRecover.metadata(), e);
                        } else {
                            SnapshotRecoverFileRequestsSender.this.cancel(e);
                        }
                    }
                };
                requestFuture.addListener(sendRequestListener);
                this.trackOutstandingRequest(requestFuture);
                RecoverySourceHandler.this.recoveryTarget.restoreFileFromSnapshot(this.snapshotFilesToRecover.repository(), this.snapshotFilesToRecover.indexId(), snapshotFileToRecover, ActionListener.runBefore(requestFuture, () -> this.unTrackOutstandingRequest(requestFuture)));
            }
            catch (CancellableThreads.ExecutionCancelledException e) {
                this.cancel(e);
            }
            catch (Exception e) {
                this.unTrackOutstandingRequest(requestFuture);
                this.onRequestCompletion(snapshotFileToRecover.metadata(), e);
            }
        }

        void cancel(Exception e) {
            if (this.cancelled.compareAndSet(false, true)) {
                this.pendingSnapshotFilesToRecover.clear();
                this.notifyFailureOnceAllOutstandingRequestAreDone(e);
            }
        }

        void onRequestCompletion(StoreFileMetadata storeFileMetadata, @Nullable Exception exception) {
            if (this.cancelled.get()) {
                return;
            }
            if (exception != null) {
                this.addFileFailedToRecoverFromSnapshot(storeFileMetadata);
            }
            if (this.countDown.countDown()) {
                List<StoreFileMetadata> failedToRecoverFromSnapshotFiles = this.getFilesFailedToRecoverFromSnapshot();
                this.listener.onResponse(failedToRecoverFromSnapshotFiles);
            } else {
                this.sendRequest();
            }
        }

        synchronized void addFileFailedToRecoverFromSnapshot(StoreFileMetadata storeFileMetadata) {
            if (this.filesFailedToDownloadFromSnapshot == null) {
                this.filesFailedToDownloadFromSnapshot = new ArrayList<StoreFileMetadata>();
            }
            this.filesFailedToDownloadFromSnapshot.add(storeFileMetadata);
        }

        synchronized List<StoreFileMetadata> getFilesFailedToRecoverFromSnapshot() {
            return Objects.requireNonNullElse(this.filesFailedToDownloadFromSnapshot, Collections.emptyList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackOutstandingRequest(SubscribableListener<Void> future) {
            boolean cancelled;
            Set<SubscribableListener<Void>> set = this.outstandingRequests;
            synchronized (set) {
                boolean bl = cancelled = RecoverySourceHandler.this.cancellableThreads.isCancelled() || this.cancelled.get();
                if (!cancelled) {
                    this.outstandingRequests.add(future);
                }
            }
            if (cancelled) {
                RecoverySourceHandler.this.cancellableThreads.checkForCancel();
                assert (this.cancelled.get());
                throw new CancellableThreads.ExecutionCancelledException("Recover snapshot files cancelled");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unTrackOutstandingRequest(SubscribableListener<Void> future) {
            Set<SubscribableListener<Void>> set = this.outstandingRequests;
            synchronized (set) {
                this.outstandingRequests.remove(future);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyFailureOnceAllOutstandingRequestAreDone(Exception e) {
            HashSet<SubscribableListener<Void>> pendingRequests;
            assert (this.cancelled.get());
            Set<SubscribableListener<Void>> set = this.outstandingRequests;
            synchronized (set) {
                pendingRequests = new HashSet<SubscribableListener<Void>>(this.outstandingRequests);
            }
            if (pendingRequests.isEmpty()) {
                this.listener.onFailure(e);
                return;
            }
            CountDown pendingRequestsCountDown = new CountDown(pendingRequests.size());
            for (SubscribableListener subscribableListener : pendingRequests) {
                subscribableListener.addListener(ActionListener.running(() -> {
                    if (pendingRequestsCountDown.countDown()) {
                        this.listener.onFailure(e);
                    }
                }));
            }
        }
    }

    private class OperationBatchSender
    extends MultiChunkTransfer<Translog.Snapshot, OperationChunkRequest> {
        private final long startingSeqNo;
        private final long endingSeqNo;
        private final Translog.Snapshot snapshot;
        private final long maxSeenAutoIdTimestamp;
        private final long maxSeqNoOfUpdatesOrDeletes;
        private final RetentionLeases retentionLeases;
        private final long mappingVersion;
        private int lastBatchCount;
        private final AtomicInteger skippedOps;
        private final AtomicInteger sentOps;
        private final AtomicLong targetLocalCheckpoint;

        OperationBatchSender(long startingSeqNo, long endingSeqNo, Translog.Snapshot snapshot, long maxSeenAutoIdTimestamp, long maxSeqNoOfUpdatesOrDeletes, RetentionLeases retentionLeases, long mappingVersion, ActionListener<Void> listener) {
            super(RecoverySourceHandler.this.logger, RecoverySourceHandler.this.threadPool.getThreadContext(), listener, RecoverySourceHandler.this.maxConcurrentOperations, List.of(snapshot));
            this.lastBatchCount = 0;
            this.skippedOps = new AtomicInteger();
            this.sentOps = new AtomicInteger();
            this.targetLocalCheckpoint = new AtomicLong(-1L);
            this.startingSeqNo = startingSeqNo;
            this.endingSeqNo = endingSeqNo;
            this.snapshot = snapshot;
            this.maxSeenAutoIdTimestamp = maxSeenAutoIdTimestamp;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
            this.retentionLeases = retentionLeases;
            this.mappingVersion = mappingVersion;
        }

        @Override
        protected synchronized OperationChunkRequest nextChunkRequest(Translog.Snapshot snapshot) throws IOException {
            Translog.Operation operation;
            assert (Transports.assertNotTransportThread("[phase2]"));
            RecoverySourceHandler.this.cancellableThreads.checkForCancel();
            ArrayList<Translog.Operation> ops = this.lastBatchCount > 0 ? new ArrayList<Translog.Operation>(this.lastBatchCount) : new ArrayList();
            long batchSizeInBytes = 0L;
            while ((operation = snapshot.next()) != null) {
                if (RecoverySourceHandler.this.shard.state() == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(RecoverySourceHandler.this.request.shardId());
                }
                long seqNo = operation.seqNo();
                if (seqNo < this.startingSeqNo || seqNo > this.endingSeqNo) {
                    this.skippedOps.incrementAndGet();
                    continue;
                }
                ops.add(operation);
                this.sentOps.incrementAndGet();
                if ((batchSizeInBytes += operation.estimateSize()) < (long)RecoverySourceHandler.this.chunkSizeInBytes) continue;
                break;
            }
            this.lastBatchCount = ops.size();
            return new OperationChunkRequest(ops, operation == null);
        }

        @Override
        protected void executeChunkRequest(OperationChunkRequest request, ActionListener<Void> listener) {
            RecoverySourceHandler.this.cancellableThreads.checkForCancel();
            RecoverySourceHandler.this.recoveryTarget.indexTranslogOperations(request.operations, this.snapshot.totalOperations(), this.maxSeenAutoIdTimestamp, this.maxSeqNoOfUpdatesOrDeletes, this.retentionLeases, this.mappingVersion, listener.safeMap(newCheckpoint -> {
                this.targetLocalCheckpoint.accumulateAndGet((long)newCheckpoint, SequenceNumbers::max);
                return null;
            }));
        }

        @Override
        protected void handleError(Translog.Snapshot snapshot, Exception e) {
            throw new RecoveryEngineException(RecoverySourceHandler.this.shard.shardId(), 2, "failed to send/replay operations", e);
        }

        @Override
        public void close() throws IOException {
            this.snapshot.close();
        }
    }

    record SendSnapshotResult(long targetLocalCheckpoint, int sentOperations, TimeValue tookTime) {
    }

    private record FileChunk(StoreFileMetadata md, BytesReference content, long position, boolean lastChunk, Releasable onClose) implements MultiChunkTransfer.ChunkRequest,
    Releasable
    {
        public void close() {
            this.onClose.close();
        }
    }

    private record OperationChunkRequest(List<Translog.Operation> operations, boolean lastChunk) implements MultiChunkTransfer.ChunkRequest
    {
    }
}

