/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.IndexVersion;

public class PreBuiltCacheFactory {
    private PreBuiltCacheFactory() {
    }

    public static <T> PreBuiltCache<T> getCache(CachingStrategy cachingStrategy) {
        return switch (cachingStrategy) {
            default -> throw new IncompatibleClassChangeError();
            case CachingStrategy.ONE -> new PreBuiltCacheStrategyOne();
            case CachingStrategy.LUCENE -> new PreBuiltCacheStrategyLucene();
            case CachingStrategy.INDEX -> new PreBuiltCacheStrategyElasticsearch();
        };
    }

    public static enum CachingStrategy {
        ONE,
        LUCENE,
        INDEX;

    }

    private static class PreBuiltCacheStrategyOne<T>
    implements PreBuiltCache<T> {
        private T model = null;

        private PreBuiltCacheStrategyOne() {
        }

        @Override
        public T get(IndexVersion version) {
            return this.model;
        }

        @Override
        public void put(IndexVersion version, T model) {
            this.model = model;
        }

        @Override
        public Collection<T> values() {
            return this.model == null ? Collections.emptySet() : Collections.singleton(this.model);
        }
    }

    private static class PreBuiltCacheStrategyLucene<T>
    implements PreBuiltCache<T> {
        private final Map<Version, T> mapModel = Maps.newMapWithExpectedSize(2);

        private PreBuiltCacheStrategyLucene() {
        }

        @Override
        public T get(IndexVersion version) {
            return this.mapModel.get(version.luceneVersion());
        }

        @Override
        public void put(IndexVersion version, T model) {
            this.mapModel.put(version.luceneVersion(), model);
        }

        @Override
        public Collection<T> values() {
            return this.mapModel.values();
        }
    }

    private static class PreBuiltCacheStrategyElasticsearch<T>
    implements PreBuiltCache<T> {
        private final Map<IndexVersion, T> mapModel = Maps.newMapWithExpectedSize(2);

        private PreBuiltCacheStrategyElasticsearch() {
        }

        @Override
        public T get(IndexVersion version) {
            return this.mapModel.get(version);
        }

        @Override
        public void put(IndexVersion version, T model) {
            this.mapModel.put(version, model);
        }

        @Override
        public Collection<T> values() {
            return this.mapModel.values();
        }
    }

    public static interface PreBuiltCache<T> {
        public T get(IndexVersion var1);

        public void put(IndexVersion var1, T var2);

        public Collection<T> values();
    }
}

