/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.ActionRequestLazyBuilder;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public abstract class AbstractBulkByScrollRequestBuilder<Request extends AbstractBulkByScrollRequest<Request>, Self extends AbstractBulkByScrollRequestBuilder<Request, Self>>
extends ActionRequestLazyBuilder<Request, BulkByScrollResponse> {
    private final SearchRequestBuilder source;
    private Integer maxDocs;
    private Boolean abortOnVersionConflict;
    private Boolean refresh;
    private TimeValue timeout;
    private ActiveShardCount waitForActiveShards;
    private TimeValue retryBackoffInitialTime;
    private Integer maxRetries;
    private Float requestsPerSecond;
    private Boolean shouldStoreResult;
    private Integer slices;

    protected AbstractBulkByScrollRequestBuilder(ElasticsearchClient client, ActionType<BulkByScrollResponse> action, SearchRequestBuilder source) {
        super(client, action);
        this.source = source;
        this.initSourceSearchRequest();
    }

    private void initSourceSearchRequest() {
        ((SearchRequest)this.source.request()).scroll(AbstractBulkByScrollRequest.DEFAULT_SCROLL_TIMEOUT);
        ((SearchRequest)this.source.request()).source(new SearchSourceBuilder());
        ((SearchRequest)this.source.request()).source().size(1000);
    }

    protected abstract Self self();

    public SearchRequestBuilder source() {
        return this.source;
    }

    public Self source(String ... indices) {
        this.source.setIndices(indices);
        return this.self();
    }

    public Self filter(QueryBuilder filter) {
        this.source.setQuery(filter);
        return this.self();
    }

    @Deprecated
    public Self size(int size) {
        return this.maxDocs(size);
    }

    public Self maxDocs(int maxDocs) {
        this.maxDocs = maxDocs;
        return this.self();
    }

    public Self abortOnVersionConflict(boolean abortOnVersionConflict) {
        this.abortOnVersionConflict = abortOnVersionConflict;
        return this.self();
    }

    public Self refresh(boolean refresh) {
        this.refresh = refresh;
        return this.self();
    }

    public Self timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this.self();
    }

    public Self waitForActiveShards(ActiveShardCount activeShardCount) {
        this.waitForActiveShards = activeShardCount;
        return this.self();
    }

    public Self setRetryBackoffInitialTime(TimeValue retryBackoffInitialTime) {
        this.retryBackoffInitialTime = retryBackoffInitialTime;
        return this.self();
    }

    public Self setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this.self();
    }

    public Self setRequestsPerSecond(float requestsPerSecond) {
        this.requestsPerSecond = Float.valueOf(requestsPerSecond);
        return this.self();
    }

    public Self setShouldStoreResult(boolean shouldStoreResult) {
        this.shouldStoreResult = shouldStoreResult;
        return this.self();
    }

    public Self setSlices(int slices) {
        this.slices = slices;
        return this.self();
    }

    protected void apply(Request request) {
        if (this.maxDocs != null) {
            ((AbstractBulkByScrollRequest)request).setMaxDocs(this.maxDocs);
        }
        if (this.abortOnVersionConflict != null) {
            ((AbstractBulkByScrollRequest)request).setAbortOnVersionConflict(this.abortOnVersionConflict);
        }
        if (this.refresh != null) {
            ((AbstractBulkByScrollRequest)request).setRefresh(this.refresh);
        }
        if (this.timeout != null) {
            ((AbstractBulkByScrollRequest)request).setTimeout(this.timeout);
        }
        if (this.waitForActiveShards != null) {
            ((AbstractBulkByScrollRequest)request).setWaitForActiveShards(this.waitForActiveShards);
        }
        if (this.retryBackoffInitialTime != null) {
            ((AbstractBulkByScrollRequest)request).setRetryBackoffInitialTime(this.retryBackoffInitialTime);
        }
        if (this.maxRetries != null) {
            ((AbstractBulkByScrollRequest)request).setMaxRetries(this.maxRetries);
        }
        if (this.requestsPerSecond != null) {
            ((AbstractBulkByScrollRequest)request).setRequestsPerSecond(this.requestsPerSecond.floatValue());
        }
        if (this.shouldStoreResult != null) {
            ((AbstractBulkByScrollRequest)request).setShouldStoreResult(this.shouldStoreResult);
        }
        if (this.slices != null) {
            ((AbstractBulkByScrollRequest)request).setSlices(this.slices);
        }
    }
}

