/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.function.Predicate;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.transport.RemoteClusterAware;

public class SearchIndexNameMatcher
implements Predicate<String> {
    private final String indexName;
    private final String clusterAlias;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver expressionResolver;

    public SearchIndexNameMatcher(String indexName, String clusterAlias, ClusterService clusterService, IndexNameExpressionResolver expressionResolver) {
        this.indexName = indexName;
        this.clusterAlias = "".equals(clusterAlias) ? null : clusterAlias;
        this.clusterService = clusterService;
        this.expressionResolver = expressionResolver;
    }

    @Override
    public boolean test(String pattern) {
        String[] splitIndex = RemoteClusterAware.splitIndexName(pattern);
        if (splitIndex[0] == null) {
            return this.clusterAlias == null && this.matchesIndex(pattern);
        }
        return Regex.simpleMatch(splitIndex[0], this.clusterAlias) && this.matchesIndex(splitIndex[1]);
    }

    private boolean matchesIndex(String pattern) {
        String[] concreteIndices;
        for (String index : concreteIndices = this.expressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpandOpen(), true, pattern)) {
            if (!Regex.simpleMatch(index, this.indexName)) continue;
            return true;
        }
        return false;
    }
}

