/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQueries;
import java.time.temporal.TemporalQuery;
import java.time.temporal.UnsupportedTemporalTypeException;
import org.elasticsearch.common.time.DateFormatters;

record DateTime(int years, Integer months, Integer days, Integer hours, Integer minutes, Integer seconds, Integer nanos, ZoneId zoneId, ZoneOffset offset) implements TemporalAccessor
{
    @Override
    public <R> R query(TemporalQuery<R> query) {
        if (query == TemporalQueries.zoneId()) {
            return (R)this.zoneId;
        }
        if (query == TemporalQueries.offset()) {
            return (R)this.offset;
        }
        if (query == DateFormatters.LOCAL_DATE_QUERY || query == TemporalQueries.localDate()) {
            if (this.months != null && this.days != null) {
                return (R)LocalDate.of(this.years, this.months, (int)this.days);
            }
            return null;
        }
        if (query == TemporalQueries.localTime()) {
            if (this.hours != null && this.minutes != null && this.seconds != null) {
                return (R)LocalTime.of(this.hours, this.minutes, this.seconds, this.nanos != null ? this.nanos : 0);
            }
            return null;
        }
        return TemporalAccessor.super.query(query);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            return switch (f) {
                case ChronoField.YEAR -> true;
                case ChronoField.MONTH_OF_YEAR -> {
                    if (this.months != null) {
                        yield true;
                    }
                    yield false;
                }
                case ChronoField.DAY_OF_MONTH -> {
                    if (this.days != null) {
                        yield true;
                    }
                    yield false;
                }
                case ChronoField.HOUR_OF_DAY -> {
                    if (this.hours != null) {
                        yield true;
                    }
                    yield false;
                }
                case ChronoField.MINUTE_OF_HOUR -> {
                    if (this.minutes != null) {
                        yield true;
                    }
                    yield false;
                }
                case ChronoField.SECOND_OF_MINUTE -> {
                    if (this.seconds != null) {
                        yield true;
                    }
                    yield false;
                }
                case ChronoField.INSTANT_SECONDS -> {
                    if (this.months != null && this.days != null && this.hours != null && this.minutes != null && this.seconds != null) {
                        yield true;
                    }
                    yield false;
                }
                case ChronoField.SECOND_OF_DAY, ChronoField.NANO_OF_SECOND, ChronoField.NANO_OF_DAY -> {
                    if (this.hours != null && this.minutes != null && this.seconds != null) {
                        yield true;
                    }
                    yield false;
                }
                case ChronoField.OFFSET_SECONDS -> {
                    if (this.offset != null) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return field.isSupportedBy(this);
    }

    @Override
    public long getLong(TemporalField field) {
        if (field instanceof ChronoField) {
            ChronoField f = (ChronoField)field;
            switch (f) {
                case YEAR: {
                    return this.years;
                }
                case MONTH_OF_YEAR: {
                    return DateTime.extractValue(f, this.months);
                }
                case DAY_OF_MONTH: {
                    return DateTime.extractValue(f, this.days);
                }
                case HOUR_OF_DAY: {
                    return DateTime.extractValue(f, this.hours);
                }
                case MINUTE_OF_HOUR: {
                    return DateTime.extractValue(f, this.minutes);
                }
                case SECOND_OF_MINUTE: {
                    return DateTime.extractValue(f, this.seconds);
                }
                case INSTANT_SECONDS: {
                    if (!this.isSupported(ChronoField.INSTANT_SECONDS)) {
                        throw new UnsupportedTemporalTypeException("No " + String.valueOf(f) + " value available");
                    }
                    return LocalDateTime.of(this.years, this.months, (int)this.days, (int)this.hours, (int)this.minutes, (int)this.seconds).toEpochSecond(this.offset != null ? this.offset : ZoneOffset.UTC);
                }
                case SECOND_OF_DAY: {
                    if (!this.isSupported(ChronoField.SECOND_OF_DAY)) {
                        throw new UnsupportedTemporalTypeException("No " + String.valueOf(f) + " value available");
                    }
                    return LocalTime.of(this.hours, this.minutes, this.seconds).toSecondOfDay();
                }
                case NANO_OF_SECOND: {
                    if (!this.isSupported(ChronoField.NANO_OF_SECOND)) {
                        throw new UnsupportedTemporalTypeException("No " + String.valueOf(f) + " value available");
                    }
                    return this.nanos != null ? this.nanos.longValue() : 0L;
                }
                case NANO_OF_DAY: {
                    if (!this.isSupported(ChronoField.NANO_OF_DAY)) {
                        throw new UnsupportedTemporalTypeException("No " + String.valueOf(f) + " value available");
                    }
                    return LocalTime.of(this.hours, this.minutes, this.seconds, this.nanos != null ? this.nanos : 0).toNanoOfDay();
                }
                case OFFSET_SECONDS: {
                    if (this.offset == null) {
                        throw new UnsupportedTemporalTypeException("No " + String.valueOf(f) + " value available");
                    }
                    return this.offset.getTotalSeconds();
                }
            }
            throw new UnsupportedTemporalTypeException("No " + String.valueOf(f) + " value available");
        }
        return field.getFrom(this);
    }

    private static long extractValue(ChronoField field, Number value) {
        if (value == null) {
            throw new UnsupportedTemporalTypeException("No " + String.valueOf(field) + " value available");
        }
        return value.longValue();
    }
}

