/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.text;

import java.io.StringWriter;
import org.elasticsearch.common.Strings;

public class SizeLimitingStringWriter
extends StringWriter {
    private final int sizeLimit;

    public SizeLimitingStringWriter(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    private int limitSize(int additionalChars) {
        int neededSize = this.getBuffer().length() + additionalChars;
        if (neededSize > this.sizeLimit) {
            return additionalChars - (neededSize - this.sizeLimit);
        }
        return additionalChars;
    }

    private void throwSizeLimitExceeded(int limitedChars, int requestedChars) {
        assert (limitedChars < requestedChars);
        int bufLen = this.getBuffer().length();
        int foundSize = bufLen - limitedChars + requestedChars;
        String selection = this.getBuffer().substring(0, Math.min(bufLen, 20));
        throw new SizeLimitExceededException(Strings.format("String [%s...] has size [%d] which exceeds the size limit [%d]", selection, foundSize, this.sizeLimit));
    }

    @Override
    public void write(int c) {
        if (this.limitSize(1) != 1) {
            this.throwSizeLimitExceeded(0, 1);
        }
        super.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        int limitedLen = this.limitSize(len);
        if (limitedLen > 0) {
            super.write(cbuf, off, limitedLen);
        }
        if (limitedLen != len) {
            this.throwSizeLimitExceeded(limitedLen, len);
        }
    }

    @Override
    public void write(String str) {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        int limitedLen = this.limitSize(len);
        if (limitedLen > 0) {
            super.write(str, off, limitedLen);
        }
        if (limitedLen != len) {
            this.throwSizeLimitExceeded(limitedLen, len);
        }
    }

    public static class SizeLimitExceededException
    extends IllegalStateException {
        public SizeLimitExceededException(String message) {
            super(message);
        }
    }
}

