/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.Build;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class HeaderWarning {
    private static final String semanticVersionPattern = "\\d+\\.\\d+\\.\\d+(?:-(?:alpha|beta|rc)\\d+)?(?:-SNAPSHOT)?";
    private static final boolean hasSemanticVersion;
    public static final Pattern WARNING_HEADER_PATTERN;
    private static BitSet qdTextChars;
    public static final Pattern WARNING_XCONTENT_LOCATION_PATTERN;
    private static final String WARNING_PREFIX;
    private static BitSet doesNotNeedEncoding;
    private static final Charset UTF_8;
    static final CopyOnWriteArraySet<ThreadContext> THREAD_CONTEXT;

    static Pattern getPatternWithSemanticVersion() {
        return Pattern.compile("299 Elasticsearch-\\d+\\.\\d+\\.\\d+(?:-(?:alpha|beta|rc)\\d+)?(?:-SNAPSHOT)?-(?:[a-f0-9]{7}(?:[a-f0-9]{33})?|unknown) \"(?<quotedStringValue>.*)\"( \"(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), \\d{2} (?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4} \\d{2}:\\d{2}:\\d{2} GMT\")?", 32);
    }

    static Pattern getPatternWithoutSemanticVersion() {
        return Pattern.compile("299 Elasticsearch-(?:[a-f0-9]{7}(?:[a-f0-9]{33})?|unknown) \"(?<quotedStringValue>.*)\"( \"(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), \\d{2} (?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4} \\d{2}:\\d{2}:\\d{2} GMT\")?", 32);
    }

    private static String buildWarningPrefix() {
        return hasSemanticVersion ? String.format(Locale.ROOT, "299 Elasticsearch-%s-%s", Build.current().version(), Build.current().hash()) : String.format(Locale.ROOT, "299 Elasticsearch-%s", Build.current().hash());
    }

    public static void setThreadContext(ThreadContext threadContext) {
        Objects.requireNonNull(threadContext, "Cannot register a null ThreadContext");
        if (!THREAD_CONTEXT.add(threadContext)) {
            throw new IllegalStateException("Double-setting ThreadContext not allowed!");
        }
    }

    public static void removeThreadContext(ThreadContext threadContext) {
        assert (threadContext != null);
        if (!THREAD_CONTEXT.remove(threadContext)) {
            throw new IllegalStateException("Removing unknown ThreadContext not allowed!");
        }
    }

    public static String extractWarningValueFromWarningHeader(String s, boolean stripXContentPosition) {
        Matcher matcher;
        int firstQuote = s.indexOf(34);
        int lastQuote = s.length() - 1;
        String warningValue = s.substring(firstQuote + 1, lastQuote);
        assert (HeaderWarning.assertWarningValue(s, warningValue));
        if (stripXContentPosition && (matcher = WARNING_XCONTENT_LOCATION_PATTERN.matcher(warningValue)).find()) {
            warningValue = warningValue.substring(matcher.end());
        }
        return warningValue;
    }

    private static boolean assertWarningValue(String s, String warningValue) {
        Matcher matcher = WARNING_HEADER_PATTERN.matcher(s);
        boolean matches = matcher.matches();
        assert (matches);
        String quotedStringValue = matcher.group("quotedStringValue");
        assert (HeaderWarning.matchesQuotedString(quotedStringValue));
        return quotedStringValue.equals(warningValue);
    }

    public static boolean warningHeaderPatternMatches(String s) {
        Matcher matcher = WARNING_HEADER_PATTERN.matcher(s);
        boolean matches = matcher.matches();
        if (matches) {
            String quotedStringValue = matcher.group("quotedStringValue");
            return HeaderWarning.matchesQuotedString(quotedStringValue);
        }
        return false;
    }

    private static boolean matchesQuotedString(String qdtext) {
        qdtext = qdtext.replace("\"", "");
        qdtext = qdtext.replace("\\", "");
        return qdtext.chars().allMatch(c -> qdTextChars.get(c));
    }

    public static String formatWarning(String s) {
        int length = WARNING_PREFIX.length() + s.length() + 6;
        StringBuilder sb = new StringBuilder(length);
        sb.append(WARNING_PREFIX).append(" \"").append(HeaderWarning.escapeAndEncode(s)).append("\"");
        return sb.toString();
    }

    public static String escapeAndEncode(String s) {
        return HeaderWarning.encode(HeaderWarning.escapeBackslashesAndQuotes(s));
    }

    static String escapeBackslashesAndQuotes(String s) {
        boolean escapingNeeded = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"') continue;
            escapingNeeded = true;
            break;
        }
        if (escapingNeeded) {
            StringBuilder sb = new StringBuilder();
            for (char c : s.toCharArray()) {
                if (c == '\\' || c == '\"') {
                    sb.append("\\");
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return s;
    }

    static String encode(String s) {
        boolean encodingNeeded = false;
        for (int i = 0; i < s.length(); ++i) {
            char current = s.charAt(i);
            if (doesNotNeedEncoding.get(current)) continue;
            encodingNeeded = true;
            break;
        }
        if (!encodingNeeded) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int i = 0;
        while (i < s.length()) {
            char current = s.charAt(i);
            if (doesNotNeedEncoding.get(current)) {
                sb.append(current);
                ++i;
                continue;
            }
            int startIndex = i;
            while (++i < s.length() && !doesNotNeedEncoding.get(s.charAt(i))) {
            }
            byte[] bytes = s.substring(startIndex, i).getBytes(UTF_8);
            for (int j = 0; j < bytes.length; ++j) {
                sb.append('%').append(HeaderWarning.hex(bytes[j] >> 4)).append(HeaderWarning.hex(bytes[j]));
            }
        }
        return sb.toString();
    }

    private static char hex(int b) {
        char ch = Character.forDigit(b & 0xF, 16);
        if (Character.isLetter(ch)) {
            return Character.toUpperCase(ch);
        }
        return ch;
    }

    public static String getProductOrigin() {
        return HeaderWarning.getSingleValue("X-elastic-product-origin");
    }

    public static String getXOpaqueId() {
        return HeaderWarning.getSingleValue("X-Opaque-Id");
    }

    private static String getSingleValue(String headerName) {
        for (ThreadContext threadContext : THREAD_CONTEXT) {
            String header = threadContext.getHeader(headerName);
            if (header == null) continue;
            return header;
        }
        return "";
    }

    public static void addWarning(String message, Object ... params) {
        HeaderWarning.addWarning(THREAD_CONTEXT, message, params);
    }

    static void addWarning(Set<ThreadContext> threadContexts, String message, Object ... params) {
        Iterator<ThreadContext> iterator = threadContexts.iterator();
        if (iterator.hasNext()) {
            String formattedMessage = LoggerMessageFormat.format(message, params);
            String warningHeaderValue = HeaderWarning.formatWarning(formattedMessage);
            assert (HeaderWarning.warningHeaderPatternMatches(warningHeaderValue));
            assert (HeaderWarning.extractWarningValueFromWarningHeader(warningHeaderValue, false).equals(HeaderWarning.escapeAndEncode(formattedMessage)));
            while (iterator.hasNext()) {
                try {
                    ThreadContext next = iterator.next();
                    next.addResponseHeader("Warning", warningHeaderValue);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
    }

    static {
        int i2;
        hasSemanticVersion = Pattern.matches(semanticVersionPattern, Build.current().version());
        WARNING_HEADER_PATTERN = hasSemanticVersion ? HeaderWarning.getPatternWithSemanticVersion() : HeaderWarning.getPatternWithoutSemanticVersion();
        qdTextChars = Stream.of(IntStream.of(9), IntStream.of(32), IntStream.of(33), IntStream.rangeClosed(35, 91), IntStream.rangeClosed(93, 126), IntStream.rangeClosed(128, 255)).flatMapToInt(i -> i).collect(BitSet::new, BitSet::set, BitSet::or);
        WARNING_XCONTENT_LOCATION_PATTERN = Pattern.compile("^\\[.*?]\\[-?\\d+:-?\\d+] ");
        WARNING_PREFIX = HeaderWarning.buildWarningPrefix();
        doesNotNeedEncoding = new BitSet(256);
        doesNotNeedEncoding.set(9);
        doesNotNeedEncoding.set(32);
        doesNotNeedEncoding.set(33);
        doesNotNeedEncoding.set(92);
        doesNotNeedEncoding.set(34);
        for (i2 = 35; i2 <= 36; ++i2) {
            doesNotNeedEncoding.set(i2);
        }
        for (i2 = 38; i2 <= 91; ++i2) {
            doesNotNeedEncoding.set(i2);
        }
        for (i2 = 93; i2 <= 126; ++i2) {
            doesNotNeedEncoding.set(i2);
        }
        for (i2 = 128; i2 <= 255; ++i2) {
            doesNotNeedEncoding.set(i2);
        }
        assert (!doesNotNeedEncoding.get(37)) : doesNotNeedEncoding;
        UTF_8 = StandardCharsets.UTF_8;
        THREAD_CONTEXT = new CopyOnWriteArraySet();
    }
}

