/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterInfoSimulator;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceInput;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

public class DesiredBalanceComputer {
    private static final Logger logger = LogManager.getLogger(DesiredBalanceComputer.class);
    private final ShardsAllocator delegateAllocator;
    private final LongSupplier timeSupplierMillis;
    protected final MeanMetric iterations = new MeanMetric();
    public static final Setting<TimeValue> PROGRESS_LOG_INTERVAL_SETTING = Setting.timeSetting("cluster.routing.allocation.desired_balance.progress_log_interval", TimeValue.timeValueMinutes((long)1L), TimeValue.ZERO, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> MAX_BALANCE_COMPUTATION_TIME_DURING_INDEX_CREATION_SETTING = Setting.timeSetting("cluster.routing.allocation.desired_balance.max_balance_computation_time_during_index_creation", TimeValue.timeValueSeconds((long)1L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    private TimeValue progressLogInterval;
    private long maxBalanceComputationTimeDuringIndexCreationMillis;

    public DesiredBalanceComputer(ClusterSettings clusterSettings, ThreadPool threadPool, ShardsAllocator delegateAllocator) {
        this(clusterSettings, delegateAllocator, threadPool::relativeTimeInMillis);
    }

    DesiredBalanceComputer(ClusterSettings clusterSettings, ShardsAllocator delegateAllocator, LongSupplier timeSupplierMillis) {
        this.delegateAllocator = delegateAllocator;
        this.timeSupplierMillis = timeSupplierMillis;
        clusterSettings.initializeAndWatch(PROGRESS_LOG_INTERVAL_SETTING, value -> {
            this.progressLogInterval = value;
        });
        clusterSettings.initializeAndWatch(MAX_BALANCE_COMPUTATION_TIME_DURING_INDEX_CREATION_SETTING, value -> {
            this.maxBalanceComputationTimeDuringIndexCreationMillis = value.millis();
        });
    }

    public DesiredBalance compute(DesiredBalance previousDesiredBalance, DesiredBalanceInput desiredBalanceInput, Queue<List<MoveAllocationCommand>> pendingDesiredBalanceMoves, Predicate<DesiredBalanceInput> isFresh) {
        List<MoveAllocationCommand> commands;
        if (logger.isTraceEnabled()) {
            logger.trace("Recomputing desired balance for [{}]: {}, {}, {}, {}", (Object)desiredBalanceInput.index(), (Object)previousDesiredBalance, (Object)desiredBalanceInput.routingAllocation().routingNodes().toString(), (Object)desiredBalanceInput.routingAllocation().clusterInfo().toString(), (Object)desiredBalanceInput.routingAllocation().snapshotShardSizeInfo().toString());
        } else {
            logger.debug("Recomputing desired balance for [{}]", (Object)desiredBalanceInput.index());
        }
        RoutingAllocation routingAllocation = desiredBalanceInput.routingAllocation().mutableCloneForSimulation();
        RoutingNodes routingNodes = routingAllocation.routingNodes();
        Set<String> knownNodeIds = routingNodes.getAllNodeIds();
        RoutingChangesObserver changes = routingAllocation.changes();
        Set<ShardRouting> ignoredShards = DesiredBalanceComputer.getIgnoredShardsWithDiscardedAllocationStatus(desiredBalanceInput.ignoredShards());
        ClusterInfoSimulator clusterInfoSimulator = new ClusterInfoSimulator(routingAllocation);
        DesiredBalance.ComputationFinishReason finishReason = DesiredBalance.ComputationFinishReason.CONVERGED;
        if (routingNodes.size() == 0) {
            return new DesiredBalance(desiredBalanceInput.index(), Map.of(), finishReason);
        }
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shardRouting : routingNode) {
                if (!shardRouting.initializing()) continue;
                clusterInfoSimulator.simulateShardStarted(shardRouting);
                routingNodes.startShard(shardRouting, changes, 0L);
            }
        }
        HashSet<ShardId> unassignedPrimaries = new HashSet<ShardId>();
        HashMap<ShardId, ShardRoutings> shardRoutings = new HashMap<ShardId, ShardRoutings>();
        for (Object primary : (Iterator<Map.Entry<ShardId, List<ShardRouting>>>)new boolean[]{true, false}) {
            RoutingNodes.UnassignedShards unassigned = routingNodes.unassigned();
            RoutingNodes.UnassignedShards.UnassignedIterator iterator = unassigned.iterator();
            while (iterator.hasNext()) {
                ShardRouting shardRouting = iterator.next();
                if (shardRouting.primary() != primary) continue;
                String lastAllocatedNodeId = shardRouting.unassignedInfo().lastAllocatedNodeId();
                if (knownNodeIds.contains(lastAllocatedNodeId) || !ignoredShards.contains(DesiredBalanceComputer.discardAllocationStatus(shardRouting))) {
                    shardRoutings.computeIfAbsent(shardRouting.shardId(), ShardRoutings::new).unassigned().add(shardRouting);
                    continue;
                }
                iterator.removeAndIgnore(UnassignedInfo.AllocationStatus.NO_ATTEMPT, changes);
                if (!shardRouting.primary()) continue;
                unassignedPrimaries.add(shardRouting.shardId());
            }
        }
        for (Map.Entry<ShardId, List<ShardRouting>> assigned : routingNodes.getAssignedShards().entrySet()) {
            shardRoutings.computeIfAbsent(assigned.getKey(), ShardRoutings::new).assigned().addAll((Collection<ShardRouting>)assigned.getValue());
        }
        HashMap<ShardRouting, LinkedList> unassignedShardsToInitialize = new HashMap<ShardRouting, LinkedList>();
        block7: for (Map.Entry entry : shardRoutings.entrySet()) {
            Object shardRouting2;
            ShardId shardId = (ShardId)entry.getKey();
            ShardRoutings routings = (ShardRoutings)entry.getValue();
            TreeMap<String, Iterator<ShardRouting>> shardsToRelocate = new TreeMap<String, Iterator<ShardRouting>>();
            ShardAssignment assignment = previousDesiredBalance.getAssignment(shardId);
            TreeSet<String> targetNodes = assignment != null ? new TreeSet<String>(assignment.nodeIds()) : new TreeSet();
            targetNodes.retainAll(knownNodeIds);
            for (Object shardRouting2 : routings.unassigned()) {
                String lastAllocatedNodeId = ((ShardRouting)shardRouting2).unassignedInfo().lastAllocatedNodeId();
                if (!knownNodeIds.contains(lastAllocatedNodeId)) continue;
                targetNodes.add(lastAllocatedNodeId);
            }
            for (Object shardRouting2 : routings.assigned()) {
                assert (((ShardRouting)shardRouting2).started());
                if (targetNodes.remove(((ShardRouting)shardRouting2).currentNodeId())) continue;
                ShardRouting previousShard = (ShardRouting)((Object)shardsToRelocate.put(((ShardRouting)shardRouting2).currentNodeId(), (Iterator<ShardRouting>)shardRouting2));
                assert (previousShard == null) : "duplicate shards to relocate: " + String.valueOf(shardRouting2) + " vs " + String.valueOf(previousShard);
            }
            Iterator<String> targetNodesIterator = targetNodes.iterator();
            block10: for (ShardRouting shardRouting3 : shardsToRelocate.values()) {
                assert (shardRouting3.started());
                while (targetNodesIterator.hasNext()) {
                    String targetNodeId = targetNodesIterator.next();
                    RoutingNode targetNode = routingNodes.node(targetNodeId);
                    if (targetNode == null || routingAllocation.deciders().canAllocate(shardRouting3, targetNode, routingAllocation).type() == Decision.Type.NO) continue;
                    ShardRouting shardToRelocate = (ShardRouting)routingNodes.relocateShard(shardRouting3, targetNodeId, 0L, "computation", changes).v2();
                    clusterInfoSimulator.simulateShardStarted(shardToRelocate);
                    routingNodes.startShard(shardToRelocate, changes, 0L);
                    continue block10;
                }
            }
            shardRouting2 = routings.unassigned().iterator();
            while (shardRouting2.hasNext()) {
                ShardRouting shardRouting3;
                shardRouting3 = shardRouting2.next();
                assert (shardRouting3.unassigned());
                if (!targetNodesIterator.hasNext()) continue block7;
                unassignedShardsToInitialize.computeIfAbsent(shardRouting3, ignored -> new LinkedList()).add(targetNodesIterator.next());
            }
        }
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedPrimaryIterator = routingNodes.unassigned().iterator();
        while (unassignedPrimaryIterator.hasNext()) {
            String nodeId;
            RoutingNode routingNode;
            LinkedList nodeIds;
            ShardRouting shardRouting = unassignedPrimaryIterator.next();
            if (!shardRouting.primary() || (nodeIds = (LinkedList)unassignedShardsToInitialize.get(shardRouting)) == null || nodeIds.isEmpty() || (routingNode = routingNodes.node(nodeId = (String)nodeIds.removeFirst())) == null || routingAllocation.deciders().canAllocate(shardRouting, routingNode, routingAllocation).type() == Decision.Type.NO) continue;
            ShardRouting shardToInitialize = unassignedPrimaryIterator.initialize(nodeId, null, 0L, changes);
            clusterInfoSimulator.simulateShardStarted(shardToInitialize);
            routingNodes.startShard(shardToInitialize, changes, 0L);
        }
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedReplicaIterator = routingNodes.unassigned().iterator();
        while (unassignedReplicaIterator.hasNext()) {
            String nodeId;
            RoutingNode routingNode;
            Object nodeIds;
            ShardRouting shardRouting = unassignedReplicaIterator.next();
            if (unassignedPrimaries.contains(shardRouting.shardId()) || (nodeIds = (LinkedList)unassignedShardsToInitialize.get(shardRouting)) == null || ((AbstractCollection)nodeIds).isEmpty() || (routingNode = routingNodes.node(nodeId = (String)((LinkedList)nodeIds).removeFirst())) == null || routingAllocation.deciders().canAllocate(shardRouting, routingNode, routingAllocation).type() == Decision.Type.NO) continue;
            ShardRouting shardToInitialize = unassignedReplicaIterator.initialize(nodeId, null, 0L, changes);
            clusterInfoSimulator.simulateShardStarted(shardToInitialize);
            routingNodes.startShard(shardToInitialize, changes, 0L);
        }
        while ((commands = pendingDesiredBalanceMoves.poll()) != null) {
            for (MoveAllocationCommand command : commands) {
                try {
                    command.execute(routingAllocation, false);
                }
                catch (RuntimeException e) {
                    logger.debug(() -> "move shard [" + command.index() + ":" + command.shardId() + "] command failed during applying it to the desired balance", (Throwable)e);
                }
            }
        }
        int iterationCountReportInterval = DesiredBalanceComputer.computeIterationCountReportInterval(routingAllocation);
        long timeWarningInterval = this.progressLogInterval.millis();
        long computationStartedTime = this.timeSupplierMillis.getAsLong();
        long nextReportTime = computationStartedTime + timeWarningInterval;
        int i = 0;
        boolean hasChanges = false;
        boolean assignedNewlyCreatedPrimaryShards = false;
        while (true) {
            boolean reportByIterationCount;
            if (hasChanges) {
                routingNodes.unassigned().resetIgnored();
                Iterator<ShardRouting> iterator = routingNodes.unassigned().iterator();
                while (((RoutingNodes.UnassignedShards.UnassignedIterator)iterator).hasNext()) {
                    ShardRouting shardRouting = ((RoutingNodes.UnassignedShards.UnassignedIterator)iterator).next();
                    if (!ignoredShards.contains(DesiredBalanceComputer.discardAllocationStatus(shardRouting))) continue;
                    ((RoutingNodes.UnassignedShards.UnassignedIterator)iterator).removeAndIgnore(UnassignedInfo.AllocationStatus.NO_ATTEMPT, changes);
                }
            }
            routingAllocation.setSimulatedClusterInfo(clusterInfoSimulator.getClusterInfo());
            logger.trace("running delegate allocator");
            this.delegateAllocator.allocate(routingAllocation);
            assert (routingNodes.unassigned().isEmpty());
            hasChanges = false;
            for (RoutingNode routingNode : routingNodes) {
                for (ShardRouting shardRouting : routingNode) {
                    if (!shardRouting.initializing()) continue;
                    hasChanges = true;
                    if (shardRouting.primary() && shardRouting.unassignedInfo() != null && shardRouting.unassignedInfo().reason() == UnassignedInfo.Reason.INDEX_CREATED) {
                        assignedNewlyCreatedPrimaryShards = true;
                    }
                    clusterInfoSimulator.simulateShardStarted(shardRouting);
                    routingNodes.startShard(shardRouting, changes, 0L);
                }
            }
            int iterations = ++i;
            long currentTime = this.timeSupplierMillis.getAsLong();
            boolean reportByTime = nextReportTime <= currentTime;
            boolean bl = reportByIterationCount = i % iterationCountReportInterval == 0;
            if (reportByTime || reportByIterationCount) {
                nextReportTime = currentTime + timeWarningInterval;
            }
            if (this.hasComputationConverged(hasChanges, i)) {
                logger.debug("Desired balance computation for [{}] converged after [{}] and [{}] iterations", (Object)desiredBalanceInput.index(), (Object)TimeValue.timeValueMillis((long)(currentTime - computationStartedTime)).toString(), (Object)i);
                break;
            }
            if (!isFresh.test(desiredBalanceInput)) {
                logger.debug("Desired balance computation for [{}] interrupted after [{}] and [{}] iterations as newer cluster state received. Publishing intermediate desired balance and restarting computation", (Object)desiredBalanceInput.index(), (Object)TimeValue.timeValueMillis((long)(currentTime - computationStartedTime)).toString(), (Object)i);
                finishReason = DesiredBalance.ComputationFinishReason.YIELD_TO_NEW_INPUT;
                break;
            }
            if (assignedNewlyCreatedPrimaryShards && currentTime - computationStartedTime >= this.maxBalanceComputationTimeDuringIndexCreationMillis) {
                logger.info("Desired balance computation for [{}] interrupted after [{}] and [{}] iterations in order to not delay assignment of newly created index shards for more than [{}]. Publishing intermediate desired balance and restarting computation", (Object)desiredBalanceInput.index(), (Object)TimeValue.timeValueMillis((long)(currentTime - computationStartedTime)).toString(), (Object)i, (Object)TimeValue.timeValueMillis((long)this.maxBalanceComputationTimeDuringIndexCreationMillis).toString());
                finishReason = DesiredBalance.ComputationFinishReason.STOP_EARLY;
                break;
            }
            logger.log(reportByIterationCount || reportByTime ? Level.INFO : (i % 100 == 0 ? Level.DEBUG : Level.TRACE), () -> Strings.format((String)"Desired balance computation for [%d] is still not converged after [%s] and [%d] iterations", (Object[])new Object[]{desiredBalanceInput.index(), TimeValue.timeValueMillis((long)(currentTime - computationStartedTime)).toString(), iterations}));
        }
        this.iterations.inc(i);
        Map<ShardId, ShardAssignment> assignments = DesiredBalanceComputer.collectShardAssignments(routingNodes);
        for (ShardRouting shard : routingNodes.unassigned().ignored()) {
            UnassignedInfo info = shard.unassignedInfo();
            assert (info != null && (info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO || info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.NO_ATTEMPT || info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED)) : "Unexpected stats in: " + String.valueOf(info);
            if (!hasChanges && info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_THROTTLED) {
                hasChanges = true;
            }
            int ignored2 = shard.unassignedInfo().lastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO ? 0 : 1;
            assignments.compute(shard.shardId(), (key, oldValue) -> oldValue == null ? new ShardAssignment(Set.of(), 1, 1, ignored2) : new ShardAssignment(oldValue.nodeIds(), oldValue.total() + 1, oldValue.unassigned() + 1, oldValue.ignored() + ignored2));
        }
        long lastConvergedIndex = hasChanges ? previousDesiredBalance.lastConvergedIndex() : desiredBalanceInput.index();
        return new DesiredBalance(lastConvergedIndex, assignments, finishReason);
    }

    boolean hasComputationConverged(boolean hasRoutingChanges, int currentIteration) {
        return !hasRoutingChanges;
    }

    private static Map<ShardId, ShardAssignment> collectShardAssignments(RoutingNodes routingNodes) {
        Set<Map.Entry<ShardId, List<ShardRouting>>> entries = routingNodes.getAssignedShards().entrySet();
        assert (entries.stream().flatMap(t -> ((List)t.getValue()).stream()).allMatch(ShardRouting::started)) : routingNodes;
        Map<ShardId, ShardAssignment> res = Maps.newHashMapWithExpectedSize(entries.size());
        for (Map.Entry<ShardId, List<ShardRouting>> shardAndAssignments : entries) {
            res.put(shardAndAssignments.getKey(), ShardAssignment.ofAssignedShards(shardAndAssignments.getValue()));
        }
        return res;
    }

    private static Set<ShardRouting> getIgnoredShardsWithDiscardedAllocationStatus(List<ShardRouting> ignoredShards) {
        return ignoredShards.stream().map(DesiredBalanceComputer::discardAllocationStatus).collect(Collectors.toUnmodifiableSet());
    }

    private static ShardRouting discardAllocationStatus(ShardRouting shardRouting) {
        return shardRouting.updateUnassigned(DesiredBalanceComputer.discardAllocationStatus(shardRouting.unassignedInfo()), shardRouting.recoverySource());
    }

    private static UnassignedInfo discardAllocationStatus(UnassignedInfo info) {
        if (info.lastAllocationStatus() == UnassignedInfo.AllocationStatus.NO_ATTEMPT) {
            return info;
        }
        return new UnassignedInfo(info.reason(), info.message(), info.failure(), info.failedAllocations(), info.unassignedTimeNanos(), info.unassignedTimeMillis(), info.delayed(), UnassignedInfo.AllocationStatus.NO_ATTEMPT, info.failedNodeIds(), info.lastAllocatedNodeId());
    }

    private static int computeIterationCountReportInterval(RoutingAllocation allocation) {
        int iterations;
        int relativeSize = allocation.metadata().getTotalNumberOfShards();
        for (iterations = 1000; iterations < relativeSize && iterations < 1000000000; iterations *= 10) {
        }
        return iterations;
    }

    private record ShardRoutings(List<ShardRouting> unassigned, List<ShardRouting> assigned) {
        private ShardRoutings(ShardId ignored) {
            this(new ArrayList<ShardRouting>(), new ArrayList<ShardRouting>());
        }
    }
}

