/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiffable;
import org.elasticsearch.cluster.NamedDiffableValueSerializer;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.PublicationTransportHandler;
import org.elasticsearch.cluster.metadata.AliasInfo;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComponentTemplateMetadata;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.DataStreamAlias;
import org.elasticsearch.cluster.metadata.DataStreamMetadata;
import org.elasticsearch.cluster.metadata.DiffableStringMap;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexGraveyard;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.NodesShutdownMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.VersionedNamedWriteable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.plugins.FieldPredicate;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xcontent.NamedObjectNotFoundException;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Metadata
implements Iterable<IndexMetadata>,
Diffable<Metadata>,
ChunkedToXContent {
    private static final Logger logger = LogManager.getLogger(Metadata.class);
    public static final Runnable ON_NEXT_INDEX_FIND_MAPPINGS_NOOP = () -> {};
    public static final String ALL = "_all";
    public static final String UNKNOWN_CLUSTER_UUID = "_na_";
    public static EnumSet<XContentContext> API_ONLY = EnumSet.of(XContentContext.API);
    public static EnumSet<XContentContext> API_AND_GATEWAY = EnumSet.of(XContentContext.API, XContentContext.GATEWAY);
    public static EnumSet<XContentContext> API_AND_SNAPSHOT = EnumSet.of(XContentContext.API, XContentContext.SNAPSHOT);
    public static EnumSet<XContentContext> ALL_CONTEXTS = EnumSet.allOf(XContentContext.class);
    public static final Setting<Boolean> SETTING_READ_ONLY_SETTING = Setting.boolSetting("cluster.blocks.read_only", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_BLOCK = new ClusterBlock(6, "cluster read-only (api)", false, false, false, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<Boolean> SETTING_READ_ONLY_ALLOW_DELETE_SETTING = Setting.boolSetting("cluster.blocks.read_only_allow_delete", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final ClusterBlock CLUSTER_READ_ONLY_ALLOW_DELETE_BLOCK = new ClusterBlock(13, "cluster read-only / allow delete (api)", false, false, true, RestStatus.FORBIDDEN, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Metadata EMPTY_METADATA = Metadata.builder().build();
    public static final String CONTEXT_MODE_PARAM = "context_mode";
    public static final String CONTEXT_MODE_SNAPSHOT = XContentContext.SNAPSHOT.toString();
    public static final String CONTEXT_MODE_GATEWAY = XContentContext.GATEWAY.toString();
    public static final String CONTEXT_MODE_API = XContentContext.API.toString();
    public static final String DEDUPLICATED_MAPPINGS_PARAM = "deduplicated_mappings";
    public static final String GLOBAL_STATE_FILE_PREFIX = "global-";
    private static final NamedDiffableValueSerializer<Custom> CUSTOM_VALUE_SERIALIZER = new NamedDiffableValueSerializer<Custom>(Custom.class);
    private final String clusterUUID;
    private final boolean clusterUUIDCommitted;
    private final long version;
    private final CoordinationMetadata coordinationMetadata;
    private final Settings transientSettings;
    private final Settings persistentSettings;
    private final Settings settings;
    private final DiffableStringMap hashesOfConsistentSettings;
    private final ImmutableOpenMap<String, IndexMetadata> indices;
    private final ImmutableOpenMap<String, Set<Index>> aliasedIndices;
    private final ImmutableOpenMap<String, IndexTemplateMetadata> templates;
    private final ImmutableOpenMap<String, Custom> customs;
    private final Map<String, ReservedStateMetadata> reservedStateMetadata;
    private final transient int totalNumberOfShards;
    private final int totalOpenIndexShards;
    private final String[] allIndices;
    private final String[] visibleIndices;
    private final String[] allOpenIndices;
    private final String[] visibleOpenIndices;
    private final String[] allClosedIndices;
    private final String[] visibleClosedIndices;
    private volatile SortedMap<String, IndexAbstraction> indicesLookup;
    private final Map<String, MappingMetadata> mappingsByHash;
    private final IndexVersion oldestIndexVersion;
    public static final TransportVersion MAPPINGS_AS_HASH_VERSION = TransportVersions.V_8_1_0;
    private static final ToXContent.Params FORMAT_PARAMS;
    public static final MetadataStateFormat<Metadata> FORMAT;

    private Metadata(String clusterUUID, boolean clusterUUIDCommitted, long version, CoordinationMetadata coordinationMetadata, Settings transientSettings, Settings persistentSettings, Settings settings, DiffableStringMap hashesOfConsistentSettings, int totalNumberOfShards, int totalOpenIndexShards, ImmutableOpenMap<String, IndexMetadata> indices, ImmutableOpenMap<String, Set<Index>> aliasedIndices, ImmutableOpenMap<String, IndexTemplateMetadata> templates, ImmutableOpenMap<String, Custom> customs, String[] allIndices, String[] visibleIndices, String[] allOpenIndices, String[] visibleOpenIndices, String[] allClosedIndices, String[] visibleClosedIndices, SortedMap<String, IndexAbstraction> indicesLookup, Map<String, MappingMetadata> mappingsByHash, IndexVersion oldestIndexVersion, Map<String, ReservedStateMetadata> reservedStateMetadata) {
        this.clusterUUID = clusterUUID;
        this.clusterUUIDCommitted = clusterUUIDCommitted;
        this.version = version;
        this.coordinationMetadata = coordinationMetadata;
        this.transientSettings = transientSettings;
        this.persistentSettings = persistentSettings;
        this.settings = settings;
        this.hashesOfConsistentSettings = hashesOfConsistentSettings;
        this.indices = indices;
        this.aliasedIndices = aliasedIndices;
        this.customs = customs;
        this.templates = templates;
        this.totalNumberOfShards = totalNumberOfShards;
        this.totalOpenIndexShards = totalOpenIndexShards;
        this.allIndices = allIndices;
        this.visibleIndices = visibleIndices;
        this.allOpenIndices = allOpenIndices;
        this.visibleOpenIndices = visibleOpenIndices;
        this.allClosedIndices = allClosedIndices;
        this.visibleClosedIndices = visibleClosedIndices;
        this.indicesLookup = indicesLookup;
        this.mappingsByHash = mappingsByHash;
        this.oldestIndexVersion = oldestIndexVersion;
        this.reservedStateMetadata = reservedStateMetadata;
        assert (this.assertConsistent());
    }

    private boolean assertConsistent() {
        DataStreamMetadata dsMetadata;
        block10: {
            SortedMap<String, IndexAbstraction> lookup = this.indicesLookup;
            dsMetadata = this.custom("data_stream", DataStreamMetadata.EMPTY);
            assert (lookup == null || lookup.equals(Builder.buildIndicesLookup(dsMetadata, this.indices)));
            try {
                Builder.ensureNoNameCollisions(this.aliasedIndices.keySet(), this.indices, dsMetadata);
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)e);
            }
        }
        assert (Builder.assertDataStreams(this.indices, dsMetadata));
        assert (Set.of(this.allIndices).equals(this.indices.keySet()));
        Function<Predicate, Set> indicesByPredicate = predicate -> this.indices.entrySet().stream().filter(entry -> predicate.test((IndexMetadata)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
        assert (Set.of(this.allOpenIndices).equals(indicesByPredicate.apply(idx -> idx.getState() == IndexMetadata.State.OPEN)));
        assert (Set.of(this.allClosedIndices).equals(indicesByPredicate.apply(idx -> idx.getState() == IndexMetadata.State.CLOSE)));
        assert (Set.of(this.visibleIndices).equals(indicesByPredicate.apply(idx -> !idx.isHidden())));
        assert (Set.of(this.visibleOpenIndices).equals(indicesByPredicate.apply(idx -> !idx.isHidden() && idx.getState() == IndexMetadata.State.OPEN)));
        assert (Set.of(this.visibleClosedIndices).equals(indicesByPredicate.apply(idx -> !idx.isHidden() && idx.getState() == IndexMetadata.State.CLOSE)));
        return true;
    }

    public Metadata withIncrementedVersion() {
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version + 1L, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.totalNumberOfShards, this.totalOpenIndexShards, this.indices, this.aliasedIndices, this.templates, this.customs, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion, this.reservedStateMetadata);
    }

    public Metadata withLifecycleState(Index index, LifecycleExecutionState lifecycleState) {
        Objects.requireNonNull(index, "index must not be null");
        Objects.requireNonNull(lifecycleState, "lifecycleState must not be null");
        IndexMetadata indexMetadata = this.getIndexSafe(index);
        if (lifecycleState.equals(indexMetadata.getLifecycleExecutionState())) {
            return this;
        }
        IndexMetadata.Builder indexMetadataBuilder = IndexMetadata.builder(indexMetadata);
        indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
        indexMetadataBuilder.putCustom("ilm", lifecycleState.asMap());
        ImmutableOpenMap.Builder<String, IndexMetadata> builder = ImmutableOpenMap.builder(this.indices);
        builder.put(index.getName(), indexMetadataBuilder.build());
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.totalNumberOfShards, this.totalOpenIndexShards, builder.build(), this.aliasedIndices, this.templates, this.customs, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion, this.reservedStateMetadata);
    }

    public Metadata withIndexSettingsUpdates(Map<Index, Settings> updates) {
        Objects.requireNonNull(updates, "no indices to update settings for");
        ImmutableOpenMap.Builder<String, IndexMetadata> builder = ImmutableOpenMap.builder(this.indices);
        updates.forEach((? super K index, ? super V settings) -> {
            IndexMetadata previous = (IndexMetadata)builder.remove(index.getName());
            assert (previous != null) : index;
            builder.put(index.getName(), IndexMetadata.builder(previous).settingsVersion(previous.getSettingsVersion() + 1L).settings((Settings)settings).build());
        });
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.totalNumberOfShards, this.totalOpenIndexShards, builder.build(), this.aliasedIndices, this.templates, this.customs, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion, this.reservedStateMetadata);
    }

    public Metadata withCoordinationMetadata(CoordinationMetadata coordinationMetadata) {
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, coordinationMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.totalNumberOfShards, this.totalOpenIndexShards, this.indices, this.aliasedIndices, this.templates, this.customs, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion, this.reservedStateMetadata);
    }

    public Metadata withLastCommittedValues(boolean clusterUUIDCommitted, CoordinationMetadata.VotingConfiguration lastCommittedConfiguration) {
        if (clusterUUIDCommitted == this.clusterUUIDCommitted && lastCommittedConfiguration.equals(this.coordinationMetadata.getLastCommittedConfiguration())) {
            return this;
        }
        return new Metadata(this.clusterUUID, clusterUUIDCommitted, this.version, CoordinationMetadata.builder(this.coordinationMetadata).lastCommittedConfiguration(lastCommittedConfiguration).build(), this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.totalNumberOfShards, this.totalOpenIndexShards, this.indices, this.aliasedIndices, this.templates, this.customs, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion, this.reservedStateMetadata);
    }

    public Metadata withAllocationAndTermUpdatesOnly(Map<String, IndexMetadata> updates) {
        if (updates.isEmpty()) {
            return this;
        }
        ImmutableOpenMap.Builder<String, IndexMetadata> updatedIndicesBuilder = ImmutableOpenMap.builder(this.indices);
        updatedIndicesBuilder.putAllFromMap(updates);
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.totalNumberOfShards, this.totalOpenIndexShards, updatedIndicesBuilder.build(), this.aliasedIndices, this.templates, this.customs, this.allIndices, this.visibleIndices, this.allOpenIndices, this.visibleOpenIndices, this.allClosedIndices, this.visibleClosedIndices, this.indicesLookup, this.mappingsByHash, this.oldestIndexVersion, this.reservedStateMetadata);
    }

    public Metadata withAddedIndex(IndexMetadata index) {
        Map<String, MappingMetadata> updatedMappingsByHash;
        String[] updatedClosedIndices;
        String[] updatedVisibleClosedIndices;
        String[] updatedVisibleOpenIndices;
        String[] updatedOpenIndices;
        String indexName = index.getIndex().getName();
        this.ensureNoNameCollision(indexName);
        Map<String, AliasMetadata> aliases = index.getAliases();
        ImmutableOpenMap<String, Set<Index>> updatedAliases = this.aliasesAfterAddingIndex(index, aliases);
        String[] updatedVisibleIndices = index.isHidden() ? this.visibleIndices : ArrayUtils.append(this.visibleIndices, indexName);
        String[] updatedAllIndices = ArrayUtils.append(this.allIndices, indexName);
        switch (index.getState()) {
            case OPEN: {
                updatedOpenIndices = ArrayUtils.append(this.allOpenIndices, indexName);
                updatedVisibleOpenIndices = !index.isHidden() ? ArrayUtils.append(this.visibleOpenIndices, indexName) : this.visibleOpenIndices;
                updatedVisibleClosedIndices = this.visibleClosedIndices;
                updatedClosedIndices = this.allClosedIndices;
                break;
            }
            case CLOSE: {
                updatedOpenIndices = this.allOpenIndices;
                updatedClosedIndices = ArrayUtils.append(this.allClosedIndices, indexName);
                updatedVisibleOpenIndices = this.visibleOpenIndices;
                if (!index.isHidden()) {
                    updatedVisibleClosedIndices = ArrayUtils.append(this.visibleClosedIndices, indexName);
                    break;
                }
                updatedVisibleClosedIndices = this.visibleClosedIndices;
                break;
            }
            default: {
                throw new AssertionError((Object)"impossible, index is either open or closed");
            }
        }
        MappingMetadata mappingMetadata = index.mapping();
        if (mappingMetadata == null) {
            updatedMappingsByHash = this.mappingsByHash;
        } else {
            MappingMetadata existingMapping = this.mappingsByHash.get(mappingMetadata.getSha256());
            if (existingMapping != null) {
                index = index.withMappingMetadata(existingMapping);
                updatedMappingsByHash = this.mappingsByHash;
            } else {
                updatedMappingsByHash = Maps.copyMapWithAddedEntry(this.mappingsByHash, mappingMetadata.getSha256(), mappingMetadata);
            }
        }
        ImmutableOpenMap.Builder<String, IndexMetadata> builder = ImmutableOpenMap.builder(this.indices);
        builder.put(indexName, index);
        ImmutableOpenMap<String, IndexMetadata> indicesMap = builder.build();
        for (Map.Entry<String, Set<Index>> entry : updatedAliases.entrySet()) {
            List<IndexMetadata> aliasIndices = entry.getValue().stream().map(idx -> (IndexMetadata)indicesMap.get(idx.getName())).toList();
            Builder.validateAlias(entry.getKey(), aliasIndices);
        }
        return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.transientSettings, this.persistentSettings, this.settings, this.hashesOfConsistentSettings, this.totalNumberOfShards + index.getTotalNumberOfShards(), this.totalOpenIndexShards + (index.getState() == IndexMetadata.State.OPEN ? index.getTotalNumberOfShards() : 0), indicesMap, updatedAliases, this.templates, this.customs, updatedAllIndices, updatedVisibleIndices, updatedOpenIndices, updatedVisibleOpenIndices, updatedClosedIndices, updatedVisibleClosedIndices, null, updatedMappingsByHash, IndexVersion.min(index.getCompatibilityVersion(), this.oldestIndexVersion), this.reservedStateMetadata);
    }

    private ImmutableOpenMap<String, Set<Index>> aliasesAfterAddingIndex(IndexMetadata index, Map<String, AliasMetadata> aliases) {
        if (aliases.isEmpty()) {
            return this.aliasedIndices;
        }
        String indexName = index.getIndex().getName();
        ImmutableOpenMap.Builder<String, Set<Index>> aliasesBuilder = ImmutableOpenMap.builder(this.aliasedIndices);
        for (String alias : aliases.keySet()) {
            Set<Index> updated;
            this.ensureNoNameCollision(alias);
            if (this.aliasedIndices.containsKey(indexName)) {
                throw new IllegalArgumentException("alias with name [" + indexName + "] already exists");
            }
            Set<Index> found = aliasesBuilder.get(alias);
            if (found == null) {
                updated = Set.of(index.getIndex());
            } else {
                HashSet<Index> tmp = new HashSet<Index>(found);
                tmp.add(index.getIndex());
                updated = Set.copyOf(tmp);
            }
            aliasesBuilder.put(alias, updated);
        }
        return aliasesBuilder.build();
    }

    private void ensureNoNameCollision(String indexName) {
        if (this.indices.containsKey(indexName)) {
            throw new IllegalArgumentException("index with name [" + indexName + "] already exists");
        }
        if (this.dataStreams().containsKey(indexName)) {
            throw new IllegalArgumentException("data stream with name [" + indexName + "] already exists");
        }
        if (this.dataStreamAliases().containsKey(indexName)) {
            throw new IllegalStateException("data stream alias and indices alias have the same name (" + indexName + ")");
        }
    }

    public long version() {
        return this.version;
    }

    public String clusterUUID() {
        return this.clusterUUID;
    }

    public boolean clusterUUIDCommitted() {
        return this.clusterUUIDCommitted;
    }

    public Settings settings() {
        return this.settings;
    }

    public Settings transientSettings() {
        return this.transientSettings;
    }

    public Settings persistentSettings() {
        return this.persistentSettings;
    }

    public Map<String, String> hashesOfConsistentSettings() {
        return this.hashesOfConsistentSettings;
    }

    public CoordinationMetadata coordinationMetadata() {
        return this.coordinationMetadata;
    }

    public IndexVersion oldestIndexVersion() {
        return this.oldestIndexVersion;
    }

    public boolean equalsAliases(Metadata other) {
        for (IndexMetadata otherIndex : other.indices().values()) {
            IndexMetadata thisIndex = this.index(otherIndex.getIndex());
            if (thisIndex == null) {
                return false;
            }
            if (otherIndex.getAliases().equals(thisIndex.getAliases())) continue;
            return false;
        }
        if (other.dataStreamAliases().size() != this.dataStreamAliases().size()) {
            return false;
        }
        for (DataStreamAlias otherAlias : other.dataStreamAliases().values()) {
            DataStreamAlias thisAlias = this.dataStreamAliases().get(otherAlias.getName());
            if (thisAlias == null) {
                return false;
            }
            if (thisAlias.equals(otherAlias)) continue;
            return false;
        }
        return true;
    }

    public boolean indicesLookupInitialized() {
        return this.indicesLookup != null;
    }

    public SortedMap<String, IndexAbstraction> getIndicesLookup() {
        SortedMap<String, IndexAbstraction> lookup = this.indicesLookup;
        if (lookup == null) {
            lookup = this.buildIndicesLookup();
        }
        return lookup;
    }

    private synchronized SortedMap<String, IndexAbstraction> buildIndicesLookup() {
        SortedMap<String, IndexAbstraction> i = this.indicesLookup;
        if (i != null) {
            return i;
        }
        this.indicesLookup = i = Builder.buildIndicesLookup(this.custom("data_stream", DataStreamMetadata.EMPTY), this.indices);
        return i;
    }

    public boolean sameIndicesLookup(Metadata other) {
        return this.indicesLookup == other.indicesLookup;
    }

    public Map<String, List<AliasMetadata>> findAllAliases(String[] concreteIndices) {
        return this.findAliases(Strings.EMPTY_ARRAY, concreteIndices);
    }

    public Map<String, List<AliasMetadata>> findAliases(String[] aliases, String[] concreteIndices) {
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        AliasInfoGetter getter = index -> this.indices.get(index).getAliases().values().stream().toList();
        AliasInfoSetter setter = (index, foundAliases) -> {
            ArrayList d = new ArrayList();
            foundAliases.forEach(i -> d.add((AliasMetadata)i));
            mapBuilder.put(index, d);
        };
        this.findAliasInfo(aliases, concreteIndices, getter, setter);
        return mapBuilder.build();
    }

    public Map<String, List<DataStreamAlias>> findDataStreamAliases(String[] aliases, String[] dataStreams) {
        ImmutableOpenMap.Builder mapBuilder = ImmutableOpenMap.builder();
        Map<String, List<DataStreamAlias>> dataStreamAliases = this.dataStreamAliasesByDataStream();
        AliasInfoGetter getter = dataStream -> dataStreamAliases.getOrDefault(dataStream, Collections.emptyList());
        AliasInfoSetter setter = (dataStream, foundAliases) -> {
            ArrayList dsAliases = new ArrayList();
            foundAliases.forEach(alias -> dsAliases.add((DataStreamAlias)alias));
            mapBuilder.put(dataStream, dsAliases);
        };
        this.findAliasInfo(aliases, dataStreams, getter, setter);
        return mapBuilder.build();
    }

    private void findAliasInfo(String[] aliases, String[] possibleMatches, AliasInfoGetter getter, AliasInfoSetter setter) {
        assert (aliases != null);
        assert (possibleMatches != null);
        if (possibleMatches.length == 0) {
            return;
        }
        String[] patterns = new String[aliases.length];
        boolean[] include = new boolean[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias.charAt(0) == '-') {
                patterns[i] = alias.substring(1);
                include[i] = false;
                continue;
            }
            patterns[i] = alias;
            include[i] = true;
        }
        boolean matchAllAliases = patterns.length == 0;
        for (String index : possibleMatches) {
            ArrayList<AliasInfo> filteredValues = new ArrayList<AliasInfo>();
            List<? extends AliasInfo> entities = getter.get(index);
            for (AliasInfo aliasInfo : entities) {
                boolean matched = matchAllAliases;
                String alias = aliasInfo.getAlias();
                for (int i = 0; i < patterns.length; ++i) {
                    if (include[i]) {
                        if (matched) continue;
                        String pattern = patterns[i];
                        matched = ALL.equals(pattern) || Regex.simpleMatch(pattern, alias);
                        continue;
                    }
                    if (!matched) continue;
                    matched = !Regex.simpleMatch(patterns[i], alias);
                }
                if (!matched) continue;
                filteredValues.add(aliasInfo);
            }
            if (filteredValues.isEmpty()) continue;
            CollectionUtil.timSort(filteredValues, Comparator.comparing(AliasInfo::getAlias));
            setter.put(index, Collections.unmodifiableList(filteredValues));
        }
    }

    public Map<String, MappingMetadata> findMappings(String[] concreteIndices, Function<String, ? extends Predicate<String>> fieldFilter, Runnable onNextIndex) {
        assert (Transports.assertNotTransportThread("decompressing mappings is too expensive for a transport thread"));
        assert (concreteIndices != null);
        if (concreteIndices.length == 0) {
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder indexMapBuilder = ImmutableOpenMap.builder();
        Set<String> indicesKeys = this.indices.keySet();
        Stream.of(concreteIndices).filter(indicesKeys::contains).forEach(index -> {
            onNextIndex.run();
            IndexMetadata indexMetadata = this.indices.get(index);
            Predicate fieldPredicate = (Predicate)fieldFilter.apply((String)index);
            indexMapBuilder.put(index, Metadata.filterFields(indexMetadata.mapping(), fieldPredicate));
        });
        return indexMapBuilder.build();
    }

    public Map<String, DataStream> findDataStreams(String ... concreteIndices) {
        assert (concreteIndices != null);
        ImmutableOpenMap.Builder<String, DataStream> builder = ImmutableOpenMap.builder();
        SortedMap<String, IndexAbstraction> lookup = this.getIndicesLookup();
        for (String indexName : concreteIndices) {
            IndexAbstraction index = (IndexAbstraction)lookup.get(indexName);
            assert (index != null);
            assert (index.getType() == IndexAbstraction.Type.CONCRETE_INDEX);
            if (index.getParentDataStream() == null) continue;
            builder.put(indexName, index.getParentDataStream());
        }
        return builder.build();
    }

    public boolean indexIsADataStream(String indexName) {
        SortedMap<String, IndexAbstraction> lookup = this.getIndicesLookup();
        IndexAbstraction abstraction = (IndexAbstraction)lookup.get(indexName);
        return abstraction != null && abstraction.getType() == IndexAbstraction.Type.DATA_STREAM;
    }

    private static MappingMetadata filterFields(MappingMetadata mappingMetadata, Predicate<String> fieldPredicate) {
        if (mappingMetadata == null) {
            return MappingMetadata.EMPTY_MAPPINGS;
        }
        if (fieldPredicate == FieldPredicate.ACCEPT_ALL) {
            return mappingMetadata;
        }
        Map sourceAsMap = (Map)XContentHelper.convertToMap(mappingMetadata.source().compressedReference(), true).v2();
        Map mapping = sourceAsMap.size() == 1 && sourceAsMap.containsKey(mappingMetadata.type()) ? (Map)sourceAsMap.get(mappingMetadata.type()) : sourceAsMap;
        Map properties = (Map)mapping.get("properties");
        if (properties == null || properties.isEmpty()) {
            return mappingMetadata;
        }
        Metadata.filterFields("", properties, fieldPredicate);
        return new MappingMetadata(mappingMetadata.type(), sourceAsMap);
    }

    private static boolean filterFields(String currentPath, Map<String, Object> fields, Predicate<String> fieldPredicate) {
        assert (fieldPredicate != FieldPredicate.ACCEPT_ALL);
        Iterator<Map.Entry<String, Object>> entryIterator = fields.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map map;
            Map.Entry<String, Object> entry = entryIterator.next();
            String newPath = Metadata.mergePaths(currentPath, entry.getKey());
            Object value = entry.getValue();
            boolean mayRemove = true;
            boolean isMultiField = false;
            if (value instanceof Map) {
                map = (Map)value;
                Map properties = (Map)map.get("properties");
                if (properties != null) {
                    mayRemove = Metadata.filterFields(newPath, properties, fieldPredicate);
                } else {
                    Map subFields = (Map)map.get("fields");
                    if (subFields != null) {
                        isMultiField = true;
                        mayRemove = Metadata.filterFields(newPath, subFields, fieldPredicate);
                        if (mayRemove) {
                            map.remove("fields");
                        }
                    }
                }
            } else {
                throw new IllegalStateException("cannot filter mappings, found unknown element of type [" + String.valueOf(value.getClass()) + "]");
            }
            if (fieldPredicate.test(newPath)) continue;
            if (mayRemove) {
                entryIterator.remove();
                continue;
            }
            if (!isMultiField) continue;
            map = (Map)value;
            Map subFields = (Map)map.get("fields");
            assert (subFields.size() > 0);
            map.put("properties", subFields);
            map.remove("fields");
            map.remove("type");
        }
        return fields.size() == 0;
    }

    private static String mergePaths(String path, String field) {
        if (path.length() == 0) {
            return field;
        }
        return path + "." + field;
    }

    public String[] getConcreteAllIndices() {
        return this.allIndices;
    }

    public String[] getConcreteVisibleIndices() {
        return this.visibleIndices;
    }

    public String[] getConcreteAllOpenIndices() {
        return this.allOpenIndices;
    }

    public String[] getConcreteVisibleOpenIndices() {
        return this.visibleOpenIndices;
    }

    public String[] getConcreteAllClosedIndices() {
        return this.allClosedIndices;
    }

    public String[] getConcreteVisibleClosedIndices() {
        return this.visibleClosedIndices;
    }

    public String resolveWriteIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        IndexAbstraction result = (IndexAbstraction)this.getIndicesLookup().get(aliasOrIndex);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            return routing;
        }
        Index writeIndexName = result.getWriteIndex();
        if (writeIndexName == null) {
            throw new IllegalArgumentException("alias [" + aliasOrIndex + "] does not have a write index");
        }
        AliasMetadata writeIndexAliasMetadata = this.index(writeIndexName).getAliases().get(result.getName());
        if (writeIndexAliasMetadata != null) {
            return Metadata.resolveRouting(routing, aliasOrIndex, writeIndexAliasMetadata);
        }
        return routing;
    }

    public String resolveIndexRouting(@Nullable String routing, String aliasOrIndex) {
        if (aliasOrIndex == null) {
            return routing;
        }
        IndexAbstraction result = (IndexAbstraction)this.getIndicesLookup().get(aliasOrIndex);
        if (result == null || result.getType() != IndexAbstraction.Type.ALIAS) {
            return routing;
        }
        if (result.getIndices().size() > 1) {
            Metadata.rejectSingleIndexOperation(aliasOrIndex, result);
        }
        return Metadata.resolveRouting(routing, aliasOrIndex, AliasMetadata.getFirstAliasMetadata(this, result));
    }

    private static String resolveRouting(@Nullable String routing, String aliasOrIndex, AliasMetadata aliasMd) {
        if (aliasMd.indexRouting() != null) {
            if (aliasMd.indexRouting().indexOf(44) != -1) {
                throw new IllegalArgumentException("index/alias [" + aliasOrIndex + "] provided with routing value [" + aliasMd.getIndexRouting() + "] that resolved to several routing values, rejecting operation");
            }
            if (routing != null && !routing.equals(aliasMd.indexRouting())) {
                throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has index routing associated with it [" + aliasMd.indexRouting() + "], and was provided with routing value [" + routing + "], rejecting operation");
            }
            return aliasMd.indexRouting();
        }
        return routing;
    }

    private static void rejectSingleIndexOperation(String aliasOrIndex, IndexAbstraction result) {
        Object[] indexNames = new String[result.getIndices().size()];
        int i = 0;
        for (Index indexName : result.getIndices()) {
            indexNames[i++] = indexName.getName();
        }
        throw new IllegalArgumentException("Alias [" + aliasOrIndex + "] has more than one index associated with it [" + Arrays.toString(indexNames) + "], can't execute a single index op");
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    public boolean hasIndex(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        return metadata != null && metadata.getIndexUUID().equals(index.getUUID());
    }

    public boolean hasIndexAbstraction(String index) {
        return this.getIndicesLookup().containsKey(index);
    }

    public IndexMetadata index(String index) {
        return this.indices.get(index);
    }

    public IndexMetadata index(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        if (metadata != null && metadata.getIndexUUID().equals(index.getUUID())) {
            return metadata;
        }
        return null;
    }

    public boolean hasIndexMetadata(IndexMetadata indexMetadata) {
        return this.indices.get(indexMetadata.getIndex().getName()) == indexMetadata;
    }

    public IndexMetadata getIndexSafe(Index index) {
        IndexMetadata metadata = this.index(index.getName());
        if (metadata != null) {
            if (metadata.getIndexUUID().equals(index.getUUID())) {
                return metadata;
            }
            throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + metadata.getIndexUUID() + "]"));
        }
        throw new IndexNotFoundException(index);
    }

    public Map<String, IndexMetadata> indices() {
        return this.indices;
    }

    public Map<String, IndexMetadata> getIndices() {
        return this.indices();
    }

    public boolean hasAlias(String aliasName) {
        return this.aliasedIndices.containsKey(aliasName) || this.dataStreamAliases().containsKey(aliasName);
    }

    public Set<Index> aliasedIndices(String aliasName) {
        Objects.requireNonNull(aliasName);
        return this.aliasedIndices.getOrDefault((Object)aliasName, Set.of());
    }

    public Set<String> aliasedIndices() {
        return this.aliasedIndices.keySet();
    }

    public Map<String, IndexTemplateMetadata> templates() {
        return this.templates;
    }

    public Map<String, IndexTemplateMetadata> getTemplates() {
        return this.templates();
    }

    public Map<String, ComponentTemplate> componentTemplates() {
        return Optional.ofNullable((ComponentTemplateMetadata)this.custom("component_template")).map(ComponentTemplateMetadata::componentTemplates).orElse(Collections.emptyMap());
    }

    public Map<String, ComposableIndexTemplate> templatesV2() {
        return Optional.ofNullable((ComposableIndexTemplateMetadata)this.custom("index_template")).map(ComposableIndexTemplateMetadata::indexTemplates).orElse(Collections.emptyMap());
    }

    public IndexMode retrieveIndexModeFromTemplate(ComposableIndexTemplate indexTemplate) {
        if (indexTemplate.getDataStreamTemplate() == null) {
            return null;
        }
        Settings settings = MetadataIndexTemplateService.resolveSettings(indexTemplate, this.componentTemplates());
        String rawIndexMode = settings.get(IndexSettings.MODE.getKey());
        return rawIndexMode != null ? Enum.valueOf(IndexMode.class, rawIndexMode.toUpperCase(Locale.ROOT)) : null;
    }

    public Map<String, DataStream> dataStreams() {
        return this.custom("data_stream", DataStreamMetadata.EMPTY).dataStreams();
    }

    public Map<String, DataStreamAlias> dataStreamAliases() {
        return this.custom("data_stream", DataStreamMetadata.EMPTY).getDataStreamAliases();
    }

    public Map<String, List<DataStreamAlias>> dataStreamAliasesByDataStream() {
        HashMap<String, List<DataStreamAlias>> dataStreamAliases = new HashMap<String, List<DataStreamAlias>>();
        for (DataStreamAlias dsAlias : this.dataStreamAliases().values()) {
            for (String dataStream : dsAlias.getDataStreams()) {
                if (!dataStreamAliases.containsKey(dataStream)) {
                    dataStreamAliases.put(dataStream, new ArrayList());
                }
                ((List)dataStreamAliases.get(dataStream)).add(dsAlias);
            }
        }
        return dataStreamAliases;
    }

    public NodesShutdownMetadata nodeShutdowns() {
        return this.custom("node_shutdown", NodesShutdownMetadata.EMPTY);
    }

    public boolean isIndexManagedByILM(IndexMetadata indexMetadata) {
        if (!Strings.hasText(indexMetadata.getLifecyclePolicyName())) {
            return false;
        }
        IndexAbstraction indexAbstraction = (IndexAbstraction)this.getIndicesLookup().get(indexMetadata.getIndex().getName());
        if (indexAbstraction == null) {
            return false;
        }
        DataStream parentDataStream = indexAbstraction.getParentDataStream();
        if (parentDataStream != null && parentDataStream.getDataLifecycle() != null && parentDataStream.getDataLifecycle().enabled()) {
            return IndexSettings.PREFER_ILM_SETTING.get(indexMetadata.getSettings());
        }
        return true;
    }

    public Map<String, Custom> customs() {
        return this.customs;
    }

    public Map<String, ReservedStateMetadata> reservedStateMetadata() {
        return this.reservedStateMetadata;
    }

    public IndexGraveyard indexGraveyard() {
        return (IndexGraveyard)this.custom("index-graveyard");
    }

    public <T extends Custom> T custom(String type) {
        return (T)this.customs.get(type);
    }

    public <T extends Custom> T custom(String type, T defaultValue) {
        return (T)this.customs.getOrDefault((Object)type, defaultValue);
    }

    public int getTotalNumberOfShards() {
        return this.totalNumberOfShards;
    }

    public int getTotalOpenIndexShards() {
        return this.totalOpenIndexShards;
    }

    @Override
    public Iterator<IndexMetadata> iterator() {
        return this.indices.values().iterator();
    }

    public Stream<IndexMetadata> stream() {
        return this.indices.values().stream();
    }

    public int size() {
        return this.indices.size();
    }

    public static boolean isGlobalStateEquals(Metadata metadata1, Metadata metadata2) {
        if (!metadata1.coordinationMetadata.equals(metadata2.coordinationMetadata)) {
            return false;
        }
        if (!metadata1.persistentSettings.equals(metadata2.persistentSettings)) {
            return false;
        }
        if (!metadata1.hashesOfConsistentSettings.equals(metadata2.hashesOfConsistentSettings)) {
            return false;
        }
        if (!metadata1.templates.equals(metadata2.templates())) {
            return false;
        }
        if (!metadata1.clusterUUID.equals(metadata2.clusterUUID)) {
            return false;
        }
        if (metadata1.clusterUUIDCommitted != metadata2.clusterUUIDCommitted) {
            return false;
        }
        int customCount1 = 0;
        for (Map.Entry<String, Custom> cursor : metadata1.customs.entrySet()) {
            if (!cursor.getValue().context().contains((Object)XContentContext.GATEWAY)) continue;
            if (!cursor.getValue().equals(metadata2.custom(cursor.getKey()))) {
                return false;
            }
            ++customCount1;
        }
        int customCount2 = 0;
        for (Custom custom : metadata2.customs.values()) {
            if (!custom.context().contains((Object)XContentContext.GATEWAY)) continue;
            ++customCount2;
        }
        if (customCount1 != customCount2) {
            return false;
        }
        return Objects.equals(metadata1.reservedStateMetadata, metadata2.reservedStateMetadata);
    }

    @Override
    public Diff<Metadata> diff(Metadata previousState) {
        return new MetadataDiff(previousState, this);
    }

    public static Diff<Metadata> readDiffFrom(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter(MetadataDiff.NOOP_METADATA_DIFF_VERSION) && in.readBoolean()) {
            return SimpleDiffable.empty();
        }
        return new MetadataDiff(in);
    }

    public static Metadata fromXContent(XContentParser parser) throws IOException {
        return Builder.fromXContent(parser);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        XContentContext context = XContentContext.valueOf(params.param(CONTEXT_MODE_PARAM, CONTEXT_MODE_API));
        return ChunkedToXContent.builder(params).append(context == XContentContext.API ? (b, p) -> b.startObject("metadata") : (b, p) -> b.startObject("meta-data").field("version", this.version())).append((b, p) -> {
            b.field("cluster_uuid", this.clusterUUID);
            b.field("cluster_uuid_committed", this.clusterUUIDCommitted);
            b.startObject("cluster_coordination");
            this.coordinationMetadata().toXContent(b, p);
            return b.endObject();
        }).execute(xb -> {
            if (context != XContentContext.API && !this.persistentSettings().isEmpty()) {
                xb.append((b, p) -> {
                    b.startObject("settings");
                    this.persistentSettings().toXContent(b, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("flat_settings", "true")));
                    return b.endObject();
                });
            }
        }).object("templates", this.templates().values().iterator(), t -> (b, p) -> IndexTemplateMetadata.Builder.toXContentWithTypes(t, b, p)).execute(xb -> {
            if (context == XContentContext.API) {
                xb.xContentObject("indices", this.indices().values().iterator());
            }
        }).forEach(this.customs.entrySet().iterator(), (b, e) -> {
            if (((Custom)e.getValue()).context().contains((Object)context)) {
                b.xContentObject((String)e.getKey(), (ChunkedToXContent)e.getValue());
            }
        }).xContentObject("reserved_state", this.reservedStateMetadata().values().iterator()).append((b, p) -> b.endObject());
    }

    public Map<String, MappingMetadata> getMappingsByHash() {
        return this.mappingsByHash;
    }

    public static Metadata readFrom(StreamInput in) throws IOException {
        int i;
        Map<String, MappingMetadata> mappingMetadataMap;
        Builder builder = new Builder();
        builder.version = in.readLong();
        builder.clusterUUID = in.readString();
        builder.clusterUUIDCommitted = in.readBoolean();
        builder.coordinationMetadata(new CoordinationMetadata(in));
        builder.transientSettings(Settings.readSettingsFromStream(in));
        builder.persistentSettings(Settings.readSettingsFromStream(in));
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_3_0)) {
            builder.hashesOfConsistentSettings(DiffableStringMap.readFrom(in));
        }
        Function<String, MappingMetadata> mappingLookup = in.getTransportVersion().onOrAfter(MAPPINGS_AS_HASH_VERSION) ? ((mappingMetadataMap = in.readMapValues(MappingMetadata::new, MappingMetadata::getSha256)).size() > 0 ? mappingMetadataMap::get : null) : null;
        int size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexMetadata.readFrom(in, mappingLookup), false);
        }
        size = in.readVInt();
        for (i = 0; i < size; ++i) {
            builder.put(IndexTemplateMetadata.readFrom(in));
        }
        int customSize = in.readVInt();
        for (int i2 = 0; i2 < customSize; ++i2) {
            Custom customIndexMetadata = in.readNamedWriteable(Custom.class);
            builder.putCustom(customIndexMetadata.getWriteableName(), customIndexMetadata);
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            int reservedStateSize = in.readVInt();
            for (int i3 = 0; i3 < reservedStateSize; ++i3) {
                builder.put(ReservedStateMetadata.readFrom(in));
            }
        }
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.version);
        out.writeString(this.clusterUUID);
        out.writeBoolean(this.clusterUUIDCommitted);
        this.coordinationMetadata.writeTo(out);
        this.transientSettings.writeTo(out);
        this.persistentSettings.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_3_0)) {
            this.hashesOfConsistentSettings.writeTo(out);
        }
        if (out.getTransportVersion().onOrAfter(MAPPINGS_AS_HASH_VERSION)) {
            out.writeMapValues(this.mappingsByHash);
        }
        out.writeVInt(this.indices.size());
        boolean writeMappingsHash = out.getTransportVersion().onOrAfter(MAPPINGS_AS_HASH_VERSION);
        for (IndexMetadata indexMetadata : this) {
            indexMetadata.writeTo(out, writeMappingsHash);
        }
        out.writeCollection(this.templates.values());
        VersionedNamedWriteable.writeVersionedWritables(out, this.customs);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            out.writeCollection(this.reservedStateMetadata.values());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Metadata metadata) {
        return new Builder(metadata);
    }

    public Metadata copyAndUpdate(Consumer<Builder> updater) {
        Builder builder = Metadata.builder(this);
        updater.accept(builder);
        return builder.build();
    }

    static {
        Map<String, String> params = Maps.newMapWithExpectedSize(2);
        params.put("binary", "true");
        params.put(CONTEXT_MODE_PARAM, CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
        FORMAT = new MetadataStateFormat<Metadata>(GLOBAL_STATE_FILE_PREFIX){

            @Override
            public void toXContent(XContentBuilder builder, Metadata state) throws IOException {
                ChunkedToXContent.wrapAsToXContent(state).toXContent(builder, FORMAT_PARAMS);
            }

            @Override
            public Metadata fromXContent(XContentParser parser) throws IOException {
                return Builder.fromXContent(parser);
            }
        };
    }

    public static interface Custom
    extends NamedDiffable<Custom>,
    ChunkedToXContent {
        public EnumSet<XContentContext> context();

        default public boolean isRestorable() {
            return this.context().contains((Object)XContentContext.SNAPSHOT);
        }
    }

    public static class Builder {
        private String clusterUUID;
        private boolean clusterUUIDCommitted;
        private long version;
        private CoordinationMetadata coordinationMetadata = CoordinationMetadata.EMPTY_METADATA;
        private Settings transientSettings = Settings.EMPTY;
        private Settings persistentSettings = Settings.EMPTY;
        private DiffableStringMap hashesOfConsistentSettings = DiffableStringMap.EMPTY;
        private final ImmutableOpenMap.Builder<String, IndexMetadata> indices;
        private final ImmutableOpenMap.Builder<String, IndexTemplateMetadata> templates;
        private final ImmutableOpenMap.Builder<String, Custom> customs;
        private SortedMap<String, IndexAbstraction> previousIndicesLookup;
        private final Map<String, ReservedStateMetadata> reservedStateMetadata;
        private boolean checkForUnusedMappings = true;
        private final Map<String, MappingMetadata> mappingsByHash;

        public Builder() {
            this(Map.of(), 0);
        }

        Builder(Metadata metadata) {
            this.clusterUUID = metadata.clusterUUID;
            this.clusterUUIDCommitted = metadata.clusterUUIDCommitted;
            this.coordinationMetadata = metadata.coordinationMetadata;
            this.transientSettings = metadata.transientSettings;
            this.persistentSettings = metadata.persistentSettings;
            this.hashesOfConsistentSettings = metadata.hashesOfConsistentSettings;
            this.version = metadata.version;
            this.indices = ImmutableOpenMap.builder(metadata.indices);
            this.templates = ImmutableOpenMap.builder(metadata.templates);
            this.customs = ImmutableOpenMap.builder(metadata.customs);
            this.previousIndicesLookup = metadata.indicesLookup;
            this.mappingsByHash = new HashMap<String, MappingMetadata>(metadata.mappingsByHash);
            this.checkForUnusedMappings = false;
            this.reservedStateMetadata = new HashMap<String, ReservedStateMetadata>(metadata.reservedStateMetadata);
        }

        private Builder(Map<String, MappingMetadata> mappingsByHash, int indexCountHint) {
            this.clusterUUID = Metadata.UNKNOWN_CLUSTER_UUID;
            this.indices = ImmutableOpenMap.builder(indexCountHint);
            this.templates = ImmutableOpenMap.builder();
            this.customs = ImmutableOpenMap.builder();
            this.reservedStateMetadata = new HashMap<String, ReservedStateMetadata>();
            this.indexGraveyard(IndexGraveyard.builder().build());
            this.previousIndicesLookup = null;
            this.mappingsByHash = new HashMap<String, MappingMetadata>(mappingsByHash);
        }

        public Builder put(IndexMetadata.Builder indexMetadataBuilder) {
            indexMetadataBuilder.version(indexMetadataBuilder.version() + 1L);
            this.dedupeMapping(indexMetadataBuilder);
            IndexMetadata indexMetadata = indexMetadataBuilder.build();
            IndexMetadata previous = this.indices.put(indexMetadata.getIndex().getName(), indexMetadata);
            if (Builder.unsetPreviousIndicesLookup(previous, indexMetadata)) {
                this.previousIndicesLookup = null;
            }
            this.maybeSetMappingPurgeFlag(previous, indexMetadata);
            return this;
        }

        public Builder put(IndexMetadata indexMetadata, boolean incrementVersion) {
            IndexMetadata previous;
            String name = indexMetadata.getIndex().getName();
            indexMetadata = this.dedupeMapping(indexMetadata);
            if (incrementVersion) {
                if (this.indices.get(name) == indexMetadata) {
                    return this;
                }
                indexMetadata = indexMetadata.withIncrementedVersion();
                previous = this.indices.put(name, indexMetadata);
            } else {
                previous = this.indices.put(name, indexMetadata);
                if (previous == indexMetadata) {
                    return this;
                }
            }
            if (Builder.unsetPreviousIndicesLookup(previous, indexMetadata)) {
                this.previousIndicesLookup = null;
            }
            this.maybeSetMappingPurgeFlag(previous, indexMetadata);
            return this;
        }

        private void maybeSetMappingPurgeFlag(@Nullable IndexMetadata previous, IndexMetadata updated) {
            if (this.checkForUnusedMappings) {
                return;
            }
            if (previous == null) {
                return;
            }
            MappingMetadata mapping = previous.mapping();
            if (mapping == null) {
                return;
            }
            MappingMetadata updatedMapping = updated.mapping();
            if (updatedMapping == null) {
                return;
            }
            if (!mapping.getSha256().equals(updatedMapping.getSha256())) {
                this.checkForUnusedMappings = true;
            }
        }

        private static boolean unsetPreviousIndicesLookup(IndexMetadata previous, IndexMetadata current) {
            if (previous == null) {
                return true;
            }
            if (!previous.getAliases().equals(current.getAliases())) {
                return true;
            }
            if (previous.isHidden() != current.isHidden()) {
                return true;
            }
            if (previous.isSystem() != current.isSystem()) {
                return true;
            }
            return previous.getState() != current.getState();
        }

        public IndexMetadata get(String index) {
            return this.indices.get(index);
        }

        public IndexMetadata getSafe(Index index) {
            IndexMetadata indexMetadata = this.get(index.getName());
            if (indexMetadata != null) {
                if (indexMetadata.getIndexUUID().equals(index.getUUID())) {
                    return indexMetadata;
                }
                throw new IndexNotFoundException(index, (Throwable)new IllegalStateException("index uuid doesn't match expected: [" + index.getUUID() + "] but got: [" + indexMetadata.getIndexUUID() + "]"));
            }
            throw new IndexNotFoundException(index);
        }

        public Builder remove(String index) {
            this.previousIndicesLookup = null;
            this.checkForUnusedMappings = true;
            this.indices.remove(index);
            return this;
        }

        public Builder removeAllIndices() {
            this.previousIndicesLookup = null;
            this.checkForUnusedMappings = true;
            this.indices.clear();
            this.mappingsByHash.clear();
            return this;
        }

        public Builder indices(Map<String, IndexMetadata> indices) {
            for (IndexMetadata value : indices.values()) {
                this.put(value, false);
            }
            return this;
        }

        public Builder put(IndexTemplateMetadata.Builder template) {
            return this.put(template.build());
        }

        public Builder put(IndexTemplateMetadata template) {
            this.templates.put(template.name(), template);
            return this;
        }

        public Builder removeTemplate(String templateName) {
            this.templates.remove(templateName);
            return this;
        }

        public Builder templates(Map<String, IndexTemplateMetadata> templates) {
            this.templates.putAllFromMap(templates);
            return this;
        }

        public Builder put(String name, ComponentTemplate componentTemplate) {
            Objects.requireNonNull(componentTemplate, "it is invalid to add a null component template: " + name);
            Map existingTemplates = Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ctm -> new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).orElse(new HashMap());
            existingTemplates.put(name, componentTemplate);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeComponentTemplate(String name) {
            Map existingTemplates = Optional.ofNullable((ComponentTemplateMetadata)this.customs.get("component_template")).map(ctm -> new HashMap<String, ComponentTemplate>(ctm.componentTemplates())).orElse(new HashMap());
            existingTemplates.remove(name);
            this.customs.put("component_template", new ComponentTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder componentTemplates(Map<String, ComponentTemplate> componentTemplates) {
            this.customs.put("component_template", new ComponentTemplateMetadata(componentTemplates));
            return this;
        }

        public Builder indexTemplates(Map<String, ComposableIndexTemplate> indexTemplates) {
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(indexTemplates));
            return this;
        }

        public Builder put(String name, ComposableIndexTemplate indexTemplate) {
            Objects.requireNonNull(indexTemplate, "it is invalid to add a null index template: " + name);
            Map existingTemplates = Optional.ofNullable((ComposableIndexTemplateMetadata)this.customs.get("index_template")).map(itmd -> new HashMap<String, ComposableIndexTemplate>(itmd.indexTemplates())).orElse(new HashMap());
            existingTemplates.put(name, indexTemplate);
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(existingTemplates));
            return this;
        }

        public Builder removeIndexTemplate(String name) {
            Map existingTemplates = Optional.ofNullable((ComposableIndexTemplateMetadata)this.customs.get("index_template")).map(itmd -> new HashMap<String, ComposableIndexTemplate>(itmd.indexTemplates())).orElse(new HashMap());
            existingTemplates.remove(name);
            this.customs.put("index_template", new ComposableIndexTemplateMetadata(existingTemplates));
            return this;
        }

        public DataStream dataStream(String dataStreamName) {
            return this.dataStreamMetadata().dataStreams().get(dataStreamName);
        }

        public Builder dataStreams(Map<String, DataStream> dataStreams, Map<String, DataStreamAlias> dataStreamAliases) {
            this.previousIndicesLookup = null;
            for (DataStream dataStream : dataStreams.values()) {
                dataStream.validate(this.indices::get);
            }
            this.customs.put("data_stream", new DataStreamMetadata(ImmutableOpenMap.builder().putAllFromMap(dataStreams).build(), ImmutableOpenMap.builder().putAllFromMap(dataStreamAliases).build()));
            return this;
        }

        public Builder put(DataStream dataStream) {
            this.previousIndicesLookup = null;
            Objects.requireNonNull(dataStream, "it is invalid to add a null data stream");
            dataStream.validate(this.indices::get);
            this.customs.put("data_stream", this.dataStreamMetadata().withAddedDatastream(dataStream));
            return this;
        }

        public DataStreamMetadata dataStreamMetadata() {
            return (DataStreamMetadata)this.customs.getOrDefault("data_stream", DataStreamMetadata.EMPTY);
        }

        public boolean put(String aliasName, String dataStream, Boolean isWriteDataStream, String filter) {
            DataStreamMetadata updated;
            this.previousIndicesLookup = null;
            DataStreamMetadata existing = this.dataStreamMetadata();
            if (existing == (updated = existing.withAlias(aliasName, dataStream, isWriteDataStream, filter))) {
                return false;
            }
            this.customs.put("data_stream", updated);
            return true;
        }

        public Builder removeDataStream(String name) {
            this.previousIndicesLookup = null;
            this.customs.put("data_stream", this.dataStreamMetadata().withRemovedDataStream(name));
            return this;
        }

        public boolean removeDataStreamAlias(String aliasName, String dataStreamName, boolean mustExist) {
            DataStreamMetadata updated;
            this.previousIndicesLookup = null;
            DataStreamMetadata existing = this.dataStreamMetadata();
            if (existing == (updated = existing.withRemovedAlias(aliasName, dataStreamName, mustExist))) {
                return false;
            }
            this.customs.put("data_stream", updated);
            return true;
        }

        public Custom getCustom(String type) {
            return this.customs.get(type);
        }

        public Builder putCustom(String type, Custom custom) {
            this.customs.put(type, Objects.requireNonNull(custom, type));
            return this;
        }

        public Builder removeCustom(String type) {
            this.customs.remove(type);
            return this;
        }

        public Builder removeCustomIf(BiPredicate<String, Custom> p) {
            this.customs.removeAll(p);
            return this;
        }

        public Builder customs(Map<String, Custom> customs) {
            customs.forEach((key, value) -> Objects.requireNonNull(value, key));
            this.customs.putAllFromMap(customs);
            return this;
        }

        public Builder put(Map<String, ReservedStateMetadata> reservedStateMetadata) {
            this.reservedStateMetadata.putAll(reservedStateMetadata);
            return this;
        }

        public Builder put(ReservedStateMetadata metadata) {
            this.reservedStateMetadata.put(metadata.namespace(), metadata);
            return this;
        }

        public Builder removeReservedState(ReservedStateMetadata metadata) {
            this.reservedStateMetadata.remove(metadata.namespace());
            return this;
        }

        public Builder indexGraveyard(IndexGraveyard indexGraveyard) {
            this.putCustom("index-graveyard", indexGraveyard);
            return this;
        }

        public IndexGraveyard indexGraveyard() {
            return (IndexGraveyard)this.getCustom("index-graveyard");
        }

        public Builder updateSettings(Settings settings, String ... indices) {
            if (indices == null || indices.length == 0) {
                indices = this.indices.keys().toArray(new String[0]);
            }
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                long newVersion = indexMetadata.getSettingsVersion() + 1L;
                this.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put(settings)).settingsVersion(newVersion));
            }
            return this;
        }

        public Builder updateNumberOfReplicas(int numberOfReplicas, String[] indices) {
            for (String index : indices) {
                IndexMetadata indexMetadata = this.indices.get(index);
                if (indexMetadata == null) {
                    throw new IndexNotFoundException(index);
                }
                this.put(IndexMetadata.builder(indexMetadata).numberOfReplicas(numberOfReplicas));
            }
            return this;
        }

        public Builder coordinationMetadata(CoordinationMetadata coordinationMetadata) {
            this.coordinationMetadata = coordinationMetadata;
            return this;
        }

        public Settings transientSettings() {
            return this.transientSettings;
        }

        public Builder transientSettings(Settings settings) {
            this.transientSettings = settings;
            return this;
        }

        public Settings persistentSettings() {
            return this.persistentSettings;
        }

        public Builder persistentSettings(Settings settings) {
            this.persistentSettings = settings;
            return this;
        }

        public Builder hashesOfConsistentSettings(DiffableStringMap hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = hashesOfConsistentSettings;
            return this;
        }

        public Builder hashesOfConsistentSettings(Map<String, String> hashesOfConsistentSettings) {
            this.hashesOfConsistentSettings = new DiffableStringMap(hashesOfConsistentSettings);
            return this;
        }

        public Builder version(long version) {
            this.version = version;
            return this;
        }

        public Builder clusterUUID(String clusterUUID) {
            this.clusterUUID = clusterUUID;
            return this;
        }

        public Builder clusterUUIDCommitted(boolean clusterUUIDCommitted) {
            this.clusterUUIDCommitted = clusterUUIDCommitted;
            return this;
        }

        public Builder generateClusterUuidIfNeeded() {
            if (this.clusterUUID.equals(Metadata.UNKNOWN_CLUSTER_UUID)) {
                this.clusterUUID = UUIDs.randomBase64UUID();
            }
            return this;
        }

        public Metadata build() {
            return this.build(false);
        }

        public Metadata build(boolean skipNameCollisionChecks) {
            ArrayList<String> visibleIndices = new ArrayList<String>();
            ArrayList<String> allOpenIndices = new ArrayList<String>();
            ArrayList<String> visibleOpenIndices = new ArrayList<String>();
            ArrayList<String> allClosedIndices = new ArrayList<String>();
            ArrayList<String> visibleClosedIndices = new ArrayList<String>();
            ImmutableOpenMap<String, IndexMetadata> indicesMap = this.indices.build();
            int oldestIndexVersionId = IndexVersion.current().id();
            int totalNumberOfShards = 0;
            int totalOpenIndexShards = 0;
            ImmutableOpenMap.Builder<Object, Set<Object>> aliasedIndicesBuilder = ImmutableOpenMap.builder();
            String[] allIndicesArray = new String[indicesMap.size()];
            int i = 0;
            HashSet<String> sha256HashesInUse = this.checkForUnusedMappings ? Sets.newHashSetWithExpectedSize(this.mappingsByHash.size()) : null;
            for (Map.Entry<String, IndexMetadata> entry : indicesMap.entrySet()) {
                Object mapping;
                boolean visible;
                allIndicesArray[i++] = entry.getKey();
                IndexMetadata indexMetadata = entry.getValue();
                totalNumberOfShards += indexMetadata.getTotalNumberOfShards();
                String name = indexMetadata.getIndex().getName();
                boolean bl = visible = !indexMetadata.isHidden();
                if (visible) {
                    visibleIndices.add(name);
                }
                if (indexMetadata.getState() == IndexMetadata.State.OPEN) {
                    totalOpenIndexShards += indexMetadata.getTotalNumberOfShards();
                    allOpenIndices.add(name);
                    if (visible) {
                        visibleOpenIndices.add(name);
                    }
                } else if (indexMetadata.getState() == IndexMetadata.State.CLOSE) {
                    allClosedIndices.add(name);
                    if (visible) {
                        visibleClosedIndices.add(name);
                    }
                }
                oldestIndexVersionId = Math.min(oldestIndexVersionId, indexMetadata.getCompatibilityVersion().id());
                if (sha256HashesInUse != null && (mapping = indexMetadata.mapping()) != null) {
                    sha256HashesInUse.add(((MappingMetadata)mapping).getSha256());
                }
                mapping = indexMetadata.getAliases().keySet().iterator();
                while (mapping.hasNext()) {
                    String alias = (String)mapping.next();
                    HashSet<Index> indices = (HashSet<Index>)aliasedIndicesBuilder.get(alias);
                    if (indices == null) {
                        indices = new HashSet<Index>();
                        aliasedIndicesBuilder.put(alias, indices);
                    }
                    indices.add(indexMetadata.getIndex());
                }
            }
            for (Object alias : aliasedIndicesBuilder.keys()) {
                aliasedIndicesBuilder.put(alias, Collections.unmodifiableSet((Set)aliasedIndicesBuilder.get(alias)));
            }
            ImmutableOpenMap<String, Set<Index>> aliasedIndices = aliasedIndicesBuilder.build();
            for (Map.Entry entry : aliasedIndices.entrySet()) {
                List<IndexMetadata> aliasIndices = ((Set)entry.getValue()).stream().map(idx -> (IndexMetadata)indicesMap.get(idx.getName())).toList();
                Builder.validateAlias((String)entry.getKey(), aliasIndices);
            }
            SortedMap<String, IndexAbstraction> indicesLookup = null;
            if (this.previousIndicesLookup != null) {
                assert (this.previousIndicesLookup.equals(Builder.buildIndicesLookup(this.dataStreamMetadata(), indicesMap)));
                indicesLookup = this.previousIndicesLookup;
            } else if (!skipNameCollisionChecks) {
                Builder.ensureNoNameCollisions(aliasedIndices.keySet(), indicesMap, this.dataStreamMetadata());
            }
            assert (Builder.assertDataStreams(indicesMap, this.dataStreamMetadata()));
            if (sha256HashesInUse != null) {
                this.mappingsByHash.keySet().retainAll(sha256HashesInUse);
            }
            String[] stringArray = visibleIndices.toArray(Strings.EMPTY_ARRAY);
            String[] allOpenIndicesArray = allOpenIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleOpenIndicesArray = visibleOpenIndices.toArray(Strings.EMPTY_ARRAY);
            String[] allClosedIndicesArray = allClosedIndices.toArray(Strings.EMPTY_ARRAY);
            String[] visibleClosedIndicesArray = visibleClosedIndices.toArray(Strings.EMPTY_ARRAY);
            return new Metadata(this.clusterUUID, this.clusterUUIDCommitted, this.version, this.coordinationMetadata, this.transientSettings, this.persistentSettings, Settings.builder().put(this.persistentSettings).put(this.transientSettings).build(), this.hashesOfConsistentSettings, totalNumberOfShards, totalOpenIndexShards, indicesMap, aliasedIndices, this.templates.build(), this.customs.build(), allIndicesArray, stringArray, allOpenIndicesArray, visibleOpenIndicesArray, allClosedIndicesArray, visibleClosedIndicesArray, indicesLookup, Collections.unmodifiableMap(this.mappingsByHash), IndexVersion.fromId(oldestIndexVersionId), Collections.unmodifiableMap(this.reservedStateMetadata));
        }

        private static void ensureNoNameCollisions(Set<String> indexAliases, ImmutableOpenMap<String, IndexMetadata> indicesMap, DataStreamMetadata dataStreamMetadata) {
            ArrayList<String> duplicates = new ArrayList<String>();
            HashSet<String> aliasDuplicatesWithIndices = new HashSet<String>();
            HashSet<String> aliasDuplicatesWithDataStreams = new HashSet<String>();
            Map<String, DataStream> allDataStreams = dataStreamMetadata.dataStreams();
            for (String dataStreamAlias : dataStreamMetadata.getDataStreamAliases().keySet()) {
                if (indexAliases.contains(dataStreamAlias)) {
                    duplicates.add("data stream alias and indices alias have the same name (" + dataStreamAlias + ")");
                }
                if (indicesMap.containsKey(dataStreamAlias)) {
                    aliasDuplicatesWithIndices.add(dataStreamAlias);
                }
                if (!allDataStreams.containsKey(dataStreamAlias)) continue;
                aliasDuplicatesWithDataStreams.add(dataStreamAlias);
            }
            for (String alias : indexAliases) {
                if (allDataStreams.containsKey(alias)) {
                    aliasDuplicatesWithDataStreams.add(alias);
                }
                if (!indicesMap.containsKey(alias)) continue;
                aliasDuplicatesWithIndices.add(alias);
            }
            allDataStreams.forEach((key, value) -> {
                if (indicesMap.containsKey(key)) {
                    duplicates.add("data stream [" + key + "] conflicts with index");
                }
            });
            if (!aliasDuplicatesWithIndices.isEmpty()) {
                Builder.collectAliasDuplicates(indicesMap, aliasDuplicatesWithIndices, duplicates);
            }
            if (!aliasDuplicatesWithDataStreams.isEmpty()) {
                Builder.collectAliasDuplicates(indicesMap, dataStreamMetadata, aliasDuplicatesWithDataStreams, duplicates);
            }
            if (!duplicates.isEmpty()) {
                throw new IllegalStateException("index, alias, and data stream names need to be unique, but the following duplicates were found [" + Strings.collectionToCommaDelimitedString(duplicates) + "]");
            }
        }

        private static void collectAliasDuplicates(ImmutableOpenMap<String, IndexMetadata> indicesMap, DataStreamMetadata dataStreamMetadata, Set<String> aliasDuplicatesWithDataStreams, ArrayList<String> duplicates) {
            for (String alias : aliasDuplicatesWithDataStreams) {
                boolean reported = false;
                for (IndexMetadata cursor : indicesMap.values()) {
                    if (!cursor.getAliases().containsKey(alias)) continue;
                    duplicates.add(alias + " (alias of " + String.valueOf(cursor.getIndex()) + ") conflicts with data stream");
                    reported = true;
                }
                if (reported || dataStreamMetadata == null || !dataStreamMetadata.dataStreams().containsKey(alias)) continue;
                duplicates.add("data stream alias and data stream have the same name (" + alias + ")");
            }
        }

        private static void collectAliasDuplicates(ImmutableOpenMap<String, IndexMetadata> indicesMap, Set<String> aliasDuplicatesWithIndices, ArrayList<String> duplicates) {
            for (IndexMetadata cursor : indicesMap.values()) {
                for (String alias : aliasDuplicatesWithIndices) {
                    if (!cursor.getAliases().containsKey(alias)) continue;
                    duplicates.add(alias + " (alias of " + String.valueOf(cursor.getIndex()) + ") conflicts with index");
                }
            }
        }

        static SortedMap<String, IndexAbstraction> buildIndicesLookup(DataStreamMetadata dataStreamMetadata, ImmutableOpenMap<String, IndexMetadata> indices) {
            if (indices.isEmpty()) {
                return Collections.emptySortedMap();
            }
            TreeMap<String, IndexAbstraction> indicesLookup = new TreeMap<String, IndexAbstraction>();
            HashMap<String, DataStream> indexToDataStreamLookup = new HashMap<String, DataStream>();
            Builder.collectDataStreams(dataStreamMetadata, indicesLookup, indexToDataStreamLookup);
            HashMap<String, List<IndexMetadata>> aliasToIndices = new HashMap<String, List<IndexMetadata>>();
            Builder.collectIndices(indices, indexToDataStreamLookup, indicesLookup, aliasToIndices);
            Builder.collectAliases(aliasToIndices, indicesLookup);
            return Collections.unmodifiableSortedMap(indicesLookup);
        }

        private static void collectAliases(Map<String, List<IndexMetadata>> aliasToIndices, Map<String, IndexAbstraction> indicesLookup) {
            for (Map.Entry<String, List<IndexMetadata>> entry : aliasToIndices.entrySet()) {
                AliasMetadata alias = entry.getValue().get(0).getAliases().get(entry.getKey());
                IndexAbstraction existing = indicesLookup.put(entry.getKey(), new IndexAbstraction.Alias(alias, entry.getValue()));
                assert (existing == null) : "duplicate for " + entry.getKey();
            }
        }

        private static void collectIndices(Map<String, IndexMetadata> indices, Map<String, DataStream> indexToDataStreamLookup, Map<String, IndexAbstraction> indicesLookup, Map<String, List<IndexMetadata>> aliasToIndices) {
            for (Map.Entry<String, IndexMetadata> entry : indices.entrySet()) {
                String name = entry.getKey();
                IndexMetadata indexMetadata = entry.getValue();
                DataStream parent = indexToDataStreamLookup.get(name);
                assert (Builder.assertContainsIndexIfDataStream(parent, indexMetadata));
                IndexAbstraction existing = indicesLookup.put(name, new IndexAbstraction.ConcreteIndex(indexMetadata, parent));
                assert (existing == null) : "duplicate for " + String.valueOf(indexMetadata.getIndex());
                for (AliasMetadata aliasMetadata : indexMetadata.getAliases().values()) {
                    List aliasIndices = aliasToIndices.computeIfAbsent(aliasMetadata.getAlias(), k -> new ArrayList());
                    aliasIndices.add(indexMetadata);
                }
            }
        }

        private static boolean assertContainsIndexIfDataStream(DataStream parent, IndexMetadata indexMetadata) {
            assert (parent == null || parent.getIndices().stream().anyMatch(index -> indexMetadata.getIndex().getName().equals(index.getName())) || parent.getFailureComponent().getIndices().stream().anyMatch(index -> indexMetadata.getIndex().getName().equals(index.getName()))) : "Expected data stream [" + parent.getName() + "] to contain index " + String.valueOf(indexMetadata.getIndex());
            return true;
        }

        private static void collectDataStreams(DataStreamMetadata dataStreamMetadata, Map<String, IndexAbstraction> indicesLookup, Map<String, DataStream> indexToDataStreamLookup) {
            IndexAbstraction existing;
            Map<String, DataStream> dataStreams = dataStreamMetadata.dataStreams();
            for (DataStreamAlias alias : dataStreamMetadata.getDataStreamAliases().values()) {
                existing = indicesLookup.put(alias.getName(), Builder.makeDsAliasAbstraction(dataStreams, alias));
                assert (existing == null) : "duplicate data stream alias for " + alias.getName();
            }
            for (DataStream dataStream : dataStreams.values()) {
                existing = indicesLookup.put(dataStream.getName(), dataStream);
                assert (existing == null) : "duplicate data stream for " + dataStream.getName();
                for (Index i : dataStream.getIndices()) {
                    indexToDataStreamLookup.put(i.getName(), dataStream);
                }
                for (Index i : dataStream.getFailureIndices()) {
                    indexToDataStreamLookup.put(i.getName(), dataStream);
                }
            }
        }

        private static IndexAbstraction.Alias makeDsAliasAbstraction(Map<String, DataStream> dataStreams, DataStreamAlias alias) {
            Index writeIndexOfWriteDataStream = null;
            if (alias.getWriteDataStream() != null) {
                DataStream writeDataStream = dataStreams.get(alias.getWriteDataStream());
                writeIndexOfWriteDataStream = writeDataStream.getWriteIndex();
            }
            return new IndexAbstraction.Alias(alias, alias.getDataStreams().stream().flatMap(name -> ((DataStream)dataStreams.get(name)).getIndices().stream()).toList(), writeIndexOfWriteDataStream, alias.getDataStreams());
        }

        private static boolean isNonEmpty(List<IndexMetadata> idxMetas) {
            return !(Objects.isNull(idxMetas) || idxMetas.isEmpty());
        }

        private static void validateAlias(String aliasName, List<IndexMetadata> indexMetadatas) {
            List<String> newVersionSystemIndices;
            List<String> writeIndices = indexMetadatas.stream().filter(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(aliasName).writeIndex())).map(im -> im.getIndex().getName()).toList();
            if (writeIndices.size() > 1) {
                throw new IllegalStateException("alias [" + aliasName + "] has more than one write index [" + Strings.collectionToCommaDelimitedString(writeIndices) + "]");
            }
            Map<Boolean, List<IndexMetadata>> groupedByHiddenStatus = indexMetadatas.stream().collect(Collectors.groupingBy(idxMeta -> Boolean.TRUE.equals(idxMeta.getAliases().get(aliasName).isHidden())));
            if (Builder.isNonEmpty(groupedByHiddenStatus.get(true)) && Builder.isNonEmpty(groupedByHiddenStatus.get(false))) {
                List<String> hiddenOn = groupedByHiddenStatus.get(true).stream().map(idx -> idx.getIndex().getName()).toList();
                List<String> nonHiddenOn = groupedByHiddenStatus.get(false).stream().map(idx -> idx.getIndex().getName()).toList();
                throw new IllegalStateException("alias [" + aliasName + "] has is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(hiddenOn) + "] but does not have is_hidden set to true on indices [" + Strings.collectionToCommaDelimitedString(nonHiddenOn) + "]; alias must have the same is_hidden setting on all indices");
            }
            Map<Boolean, List<IndexMetadata>> groupedBySystemStatus = indexMetadatas.stream().collect(Collectors.groupingBy(IndexMetadata::isSystem));
            if (Builder.isNonEmpty(groupedBySystemStatus.get(false)) && Builder.isNonEmpty(groupedBySystemStatus.get(true)) && !(newVersionSystemIndices = groupedBySystemStatus.get(true).stream().filter(i -> i.getCreationVersion().onOrAfter(IndexNameExpressionResolver.SYSTEM_INDEX_ENFORCEMENT_INDEX_VERSION)).map(i -> i.getIndex().getName()).sorted().toList()).isEmpty()) {
                List<String> nonSystemIndices = groupedBySystemStatus.get(false).stream().map(i -> i.getIndex().getName()).sorted().toList();
                throw new IllegalStateException("alias [" + aliasName + "] refers to both system indices " + String.valueOf(newVersionSystemIndices) + " and non-system indices: " + String.valueOf(nonSystemIndices) + ", but aliases must refer to either system or non-system indices, not both");
            }
        }

        static boolean assertDataStreams(Map<String, IndexMetadata> indices, DataStreamMetadata dsMetadata) {
            LinkedList<String> conflictingAliases = null;
            for (DataStream dataStream : dsMetadata.dataStreams().values()) {
                for (Index index : dataStream.getIndices()) {
                    IndexMetadata im = indices.get(index.getName());
                    if (im == null || im.getAliases().isEmpty()) continue;
                    for (AliasMetadata alias : im.getAliases().values()) {
                        if (conflictingAliases == null) {
                            conflictingAliases = new LinkedList<String>();
                        }
                        conflictingAliases.add(alias.alias());
                    }
                }
            }
            if (conflictingAliases != null) {
                throw new AssertionError((Object)("aliases " + String.valueOf(conflictingAliases) + " cannot refer to backing indices of data streams"));
            }
            return true;
        }

        public static Metadata fromXContent(XContentParser parser) throws IOException {
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            String currentFieldName = parser.currentName();
            if (!"meta-data".equals(currentFieldName)) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
                    token = parser.nextToken();
                }
                currentFieldName = parser.currentName();
            }
            if (!"meta-data".equals(currentFieldName)) {
                throw new IllegalArgumentException("Expected [meta-data] as a field name but got " + currentFieldName);
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, token, parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("cluster_coordination".equals(currentFieldName)) {
                        builder.coordinationMetadata(CoordinationMetadata.fromXContent(parser));
                        continue;
                    }
                    if ("settings".equals(currentFieldName)) {
                        builder.persistentSettings(Settings.fromXContent(parser));
                        continue;
                    }
                    if ("indices".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexMetadata.Builder.fromXContent(parser), false);
                        }
                        continue;
                    }
                    if ("hashes_of_consistent_settings".equals(currentFieldName)) {
                        builder.hashesOfConsistentSettings(parser.mapStrings());
                        continue;
                    }
                    if ("templates".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(IndexTemplateMetadata.Builder.fromXContent(parser, parser.currentName()));
                        }
                        continue;
                    }
                    if ("reserved_state".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            builder.put(ReservedStateMetadata.fromXContent(parser));
                        }
                        continue;
                    }
                    try {
                        Custom custom = (Custom)parser.namedObject(Custom.class, currentFieldName, null);
                        builder.putCustom(custom.getWriteableName(), custom);
                    }
                    catch (NamedObjectNotFoundException ex) {
                        logger.warn("Skipping unknown custom object with type {}", (Object)currentFieldName);
                        parser.skipChildren();
                    }
                    continue;
                }
                if (token.isValue()) {
                    if ("version".equals(currentFieldName)) {
                        builder.version = parser.longValue();
                        continue;
                    }
                    if ("cluster_uuid".equals(currentFieldName) || "uuid".equals(currentFieldName)) {
                        builder.clusterUUID = parser.text();
                        continue;
                    }
                    if ("cluster_uuid_committed".equals(currentFieldName)) {
                        builder.clusterUUIDCommitted = parser.booleanValue();
                        continue;
                    }
                    throw new IllegalArgumentException("Unexpected field [" + currentFieldName + "]");
                }
                throw new IllegalArgumentException("Unexpected token " + String.valueOf(token));
            }
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
            return builder.build();
        }

        private IndexMetadata dedupeMapping(IndexMetadata indexMetadata) {
            if (indexMetadata.mapping() == null) {
                return indexMetadata;
            }
            String digest = indexMetadata.mapping().getSha256();
            MappingMetadata entry = this.mappingsByHash.get(digest);
            if (entry != null) {
                return indexMetadata.withMappingMetadata(entry);
            }
            this.mappingsByHash.put(digest, indexMetadata.mapping());
            return indexMetadata;
        }

        private void dedupeMapping(IndexMetadata.Builder indexMetadataBuilder) {
            if (indexMetadataBuilder.mapping() == null) {
                return;
            }
            String digest = indexMetadataBuilder.mapping().getSha256();
            MappingMetadata entry = this.mappingsByHash.get(digest);
            if (entry != null) {
                indexMetadataBuilder.putMapping(entry);
            } else {
                this.mappingsByHash.put(digest, indexMetadataBuilder.mapping());
            }
        }
    }

    private static interface AliasInfoGetter {
        public List<? extends AliasInfo> get(String var1);
    }

    private static interface AliasInfoSetter {
        public void put(String var1, List<AliasInfo> var2);
    }

    public static enum XContentContext {
        API,
        GATEWAY,
        SNAPSHOT;

    }

    private static class MetadataDiff
    implements Diff<Metadata> {
        private static final TransportVersion NOOP_METADATA_DIFF_VERSION = TransportVersions.V_8_5_0;
        private static final TransportVersion NOOP_METADATA_DIFF_SAFE_VERSION = PublicationTransportHandler.INCLUDES_LAST_COMMITTED_DATA_VERSION;
        private final long version;
        private final String clusterUUID;
        private final boolean clusterUUIDCommitted;
        private final CoordinationMetadata coordinationMetadata;
        private final Settings transientSettings;
        private final Settings persistentSettings;
        private final Diff<DiffableStringMap> hashesOfConsistentSettings;
        private final Diff<ImmutableOpenMap<String, IndexMetadata>> indices;
        private final Diff<ImmutableOpenMap<String, IndexTemplateMetadata>> templates;
        private final Diff<ImmutableOpenMap<String, Custom>> customs;
        private final Diff<Map<String, ReservedStateMetadata>> reservedStateMetadata;
        private final boolean empty;
        private static final DiffableUtils.DiffableValueReader<String, IndexMetadata> INDEX_METADATA_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexMetadata::readFrom, IndexMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, IndexTemplateMetadata> TEMPLATES_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(IndexTemplateMetadata::readFrom, IndexTemplateMetadata::readDiffFrom);
        private static final DiffableUtils.DiffableValueReader<String, ReservedStateMetadata> RESERVED_DIFF_VALUE_READER = new DiffableUtils.DiffableValueReader(ReservedStateMetadata::readFrom, ReservedStateMetadata::readDiffFrom);

        MetadataDiff(Metadata before, Metadata after) {
            this.empty = before == after;
            this.clusterUUID = after.clusterUUID;
            this.clusterUUIDCommitted = after.clusterUUIDCommitted;
            this.version = after.version;
            this.coordinationMetadata = after.coordinationMetadata;
            this.transientSettings = after.transientSettings;
            this.persistentSettings = after.persistentSettings;
            if (this.empty) {
                this.hashesOfConsistentSettings = DiffableStringMap.DiffableStringMapDiff.EMPTY;
                this.indices = DiffableUtils.emptyDiff();
                this.templates = DiffableUtils.emptyDiff();
                this.customs = DiffableUtils.emptyDiff();
                this.reservedStateMetadata = DiffableUtils.emptyDiff();
            } else {
                this.hashesOfConsistentSettings = after.hashesOfConsistentSettings.diff(before.hashesOfConsistentSettings);
                this.indices = DiffableUtils.diff(before.indices, after.indices, DiffableUtils.getStringKeySerializer());
                this.templates = DiffableUtils.diff(before.templates, after.templates, DiffableUtils.getStringKeySerializer());
                this.customs = DiffableUtils.diff(before.customs, after.customs, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
                this.reservedStateMetadata = DiffableUtils.diff(before.reservedStateMetadata, after.reservedStateMetadata, DiffableUtils.getStringKeySerializer());
            }
        }

        private MetadataDiff(StreamInput in) throws IOException {
            this.empty = false;
            this.clusterUUID = in.readString();
            this.clusterUUIDCommitted = in.readBoolean();
            this.version = in.readLong();
            this.coordinationMetadata = new CoordinationMetadata(in);
            this.transientSettings = Settings.readSettingsFromStream(in);
            this.persistentSettings = Settings.readSettingsFromStream(in);
            this.hashesOfConsistentSettings = in.getTransportVersion().onOrAfter(TransportVersions.V_7_3_0) ? DiffableStringMap.readDiffFrom(in) : DiffableStringMap.DiffableStringMapDiff.EMPTY;
            this.indices = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), INDEX_METADATA_DIFF_VALUE_READER);
            this.templates = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), TEMPLATES_DIFF_VALUE_READER);
            this.customs = DiffableUtils.readImmutableOpenMapDiff(in, DiffableUtils.getStringKeySerializer(), CUSTOM_VALUE_SERIALIZER);
            this.reservedStateMetadata = in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0) ? DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), RESERVED_DIFF_VALUE_READER) : DiffableUtils.emptyDiff();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(NOOP_METADATA_DIFF_SAFE_VERSION)) {
                out.writeBoolean(this.empty);
                if (this.empty) {
                    return;
                }
            } else if (out.getTransportVersion().onOrAfter(NOOP_METADATA_DIFF_VERSION)) {
                out.writeBoolean(false);
            }
            out.writeString(this.clusterUUID);
            out.writeBoolean(this.clusterUUIDCommitted);
            out.writeLong(this.version);
            this.coordinationMetadata.writeTo(out);
            this.transientSettings.writeTo(out);
            this.persistentSettings.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_3_0)) {
                this.hashesOfConsistentSettings.writeTo(out);
            }
            this.indices.writeTo(out);
            this.templates.writeTo(out);
            this.customs.writeTo(out);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
                this.reservedStateMetadata.writeTo(out);
            }
        }

        @Override
        public Metadata apply(Metadata part) {
            if (this.empty) {
                return part;
            }
            ImmutableOpenMap<String, IndexMetadata> updatedIndices = this.indices.apply(part.indices);
            Builder builder = new Builder(part.mappingsByHash, updatedIndices.size());
            builder.clusterUUID(this.clusterUUID);
            builder.clusterUUIDCommitted(this.clusterUUIDCommitted);
            builder.version(this.version);
            builder.coordinationMetadata(this.coordinationMetadata);
            builder.transientSettings(this.transientSettings);
            builder.persistentSettings(this.persistentSettings);
            builder.hashesOfConsistentSettings(this.hashesOfConsistentSettings.apply(part.hashesOfConsistentSettings));
            builder.indices(updatedIndices);
            builder.templates((Map<String, IndexTemplateMetadata>)this.templates.apply(part.templates));
            builder.customs((Map<String, Custom>)this.customs.apply(part.customs));
            builder.put(this.reservedStateMetadata.apply(part.reservedStateMetadata));
            if (part.indices == updatedIndices && builder.dataStreamMetadata() == part.custom("data_stream", DataStreamMetadata.EMPTY)) {
                builder.previousIndicesLookup = part.indicesLookup;
            }
            return builder.build(true);
        }
    }
}

