/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.ObjLongConsumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.Coordinator;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.JoinReasonService;
import org.elasticsearch.cluster.coordination.JoinRequest;
import org.elasticsearch.cluster.coordination.JoinStatus;
import org.elasticsearch.cluster.coordination.JoinTask;
import org.elasticsearch.cluster.coordination.NodeJoinExecutor;
import org.elasticsearch.cluster.coordination.StartJoinRequest;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.cluster.version.CompatibilityVersions;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class JoinHelper {
    private static final Logger logger = LogManager.getLogger(JoinHelper.class);
    public static final String START_JOIN_ACTION_NAME = "internal:cluster/coordination/start_join";
    public static final String JOIN_ACTION_NAME = "internal:cluster/coordination/join";
    public static final String JOIN_PING_ACTION_NAME = "internal:cluster/coordination/join/ping";
    private final ClusterApplier clusterApplier;
    private final TransportService transportService;
    private final MasterServiceTaskQueue<JoinTask> joinTaskQueue;
    private final LongSupplier currentTermSupplier;
    private final NodeHealthService nodeHealthService;
    private final JoinReasonService joinReasonService;
    private final CircuitBreakerService circuitBreakerService;
    private final ObjLongConsumer<ActionListener<ClusterState>> latestStoredStateSupplier;
    private final CompatibilityVersions compatibilityVersions;
    private final Set<String> features;
    private final Map<Tuple<DiscoveryNode, JoinRequest>, PendingJoinInfo> pendingOutgoingJoins = ConcurrentCollections.newConcurrentMap();
    private final AtomicReference<FailedJoinAttempt> lastFailedJoinAttempt = new AtomicReference();
    private final Map<DiscoveryNode, Releasable> joinConnections = new HashMap<DiscoveryNode, Releasable>();
    static final String PENDING_JOIN_INITIALIZING = "initializing";
    static final String PENDING_JOIN_CONNECTING = "waiting to connect";
    static final String PENDING_JOIN_WAITING_APPLIER = "waiting for local cluster applier";
    static final String PENDING_JOIN_WAITING_RESPONSE = "waiting for response";
    static final String PENDING_JOIN_WAITING_STATE = "waiting to receive cluster state";
    static final String PENDING_JOIN_CONNECT_FAILED = "failed to connect";
    static final String PENDING_JOIN_FAILED = "failed";

    JoinHelper(AllocationService allocationService, MasterService masterService, ClusterApplier clusterApplier, TransportService transportService, LongSupplier currentTermSupplier, BiConsumer<JoinRequest, ActionListener<Void>> joinHandler, Function<StartJoinRequest, Join> joinLeaderInTerm, RerouteService rerouteService, NodeHealthService nodeHealthService, JoinReasonService joinReasonService, CircuitBreakerService circuitBreakerService, Function<ClusterState, ClusterState> maybeReconfigureAfterMasterElection, ObjLongConsumer<ActionListener<ClusterState>> latestStoredStateSupplier, CompatibilityVersions compatibilityVersions, FeatureService featureService) {
        this.joinTaskQueue = masterService.createTaskQueue("node-join", Priority.URGENT, new NodeJoinExecutor(allocationService, rerouteService, featureService, maybeReconfigureAfterMasterElection));
        this.clusterApplier = clusterApplier;
        this.transportService = transportService;
        this.circuitBreakerService = circuitBreakerService;
        this.currentTermSupplier = currentTermSupplier;
        this.nodeHealthService = nodeHealthService;
        this.joinReasonService = joinReasonService;
        this.latestStoredStateSupplier = latestStoredStateSupplier;
        this.compatibilityVersions = compatibilityVersions;
        this.features = featureService.getNodeFeatures().keySet();
        transportService.registerRequestHandler(JOIN_ACTION_NAME, transportService.getThreadPool().executor("cluster_coordination"), false, false, JoinRequest::new, (request, channel, task) -> joinHandler.accept((JoinRequest)request, new ChannelActionListener(channel).map(ignored -> ActionResponse.Empty.INSTANCE)));
        transportService.registerRequestHandler(START_JOIN_ACTION_NAME, transportService.getThreadPool().executor("cluster_coordination"), false, false, StartJoinRequest::new, (request, channel, task) -> {
            DiscoveryNode destination = request.getMasterCandidateNode();
            this.sendJoinRequest(destination, currentTermSupplier.getAsLong(), Optional.of((Join)joinLeaderInTerm.apply((StartJoinRequest)request)));
            channel.sendResponse(ActionResponse.Empty.INSTANCE);
        });
        transportService.registerRequestHandler(JOIN_PING_ACTION_NAME, EsExecutors.DIRECT_EXECUTOR_SERVICE, false, false, JoinPingRequest::new, (request, channel, task) -> channel.sendResponse(ActionResponse.Empty.INSTANCE));
    }

    boolean isJoinPending() {
        return !this.pendingOutgoingJoins.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClusterStateApplied() {
        ArrayList<Releasable> releasables;
        Map<DiscoveryNode, Releasable> map = this.joinConnections;
        synchronized (map) {
            if (this.joinConnections.isEmpty()) {
                return;
            }
            releasables = new ArrayList<Releasable>(this.joinConnections.values());
            this.joinConnections.clear();
        }
        logger.debug("releasing [{}] connections on successful cluster state application", (Object)releasables.size());
        Releasables.close(releasables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerConnection(DiscoveryNode destination, Releasable connectionReference) {
        Releasable previousConnection;
        Map<DiscoveryNode, Releasable> map = this.joinConnections;
        synchronized (map) {
            previousConnection = this.joinConnections.put(destination, connectionReference);
        }
        Releasables.close((Releasable)previousConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAndReleaseConnection(DiscoveryNode destination, Releasable connectionReference) {
        Map<DiscoveryNode, Releasable> map = this.joinConnections;
        synchronized (map) {
            this.joinConnections.remove(destination, connectionReference);
        }
        Releasables.close((Releasable)connectionReference);
    }

    void logLastFailedJoinAttempt() {
        FailedJoinAttempt attempt = this.lastFailedJoinAttempt.get();
        if (attempt != null) {
            attempt.logWarnWithTimestamp();
            this.lastFailedJoinAttempt.compareAndSet(attempt, null);
        }
    }

    public void sendJoinRequest(final DiscoveryNode destination, long term, Optional<Join> optionalJoin) {
        PendingJoinInfo pendingJoinInfo;
        assert (destination.isMasterNode()) : "trying to join master-ineligible " + String.valueOf(destination);
        StatusInfo statusInfo = this.nodeHealthService.getHealth();
        if (statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
            logger.debug("dropping join request to [{}], unhealthy status: [{}]", (Object)destination, (Object)statusInfo.getInfo());
            return;
        }
        final JoinRequest joinRequest = new JoinRequest(this.transportService.getLocalNode(), this.compatibilityVersions, this.features, term, optionalJoin);
        final Tuple dedupKey = Tuple.tuple((Object)destination, (Object)joinRequest);
        if (this.pendingOutgoingJoins.putIfAbsent((Tuple<DiscoveryNode, JoinRequest>)dedupKey, pendingJoinInfo = new PendingJoinInfo(this.transportService.getThreadPool().relativeTimeInMillis())) == null) {
            CircuitBreaker breaker = this.circuitBreakerService.getBreaker("inflight_requests");
            try {
                breaker.addEstimateBytesAndMaybeBreak(1L, "pre-flight join request");
            }
            catch (Exception e) {
                pendingJoinInfo.message = PENDING_JOIN_FAILED;
                this.pendingOutgoingJoins.remove(dedupKey);
                if (e instanceof ElasticsearchException) {
                    ElasticsearchException elasticsearchException = (ElasticsearchException)e;
                    FailedJoinAttempt attempt = new FailedJoinAttempt(destination, joinRequest, elasticsearchException);
                    attempt.logNow();
                    this.lastFailedJoinAttempt.set(attempt);
                    assert (elasticsearchException instanceof CircuitBreakingException) : e;
                } else {
                    logger.error("join failed during pre-flight circuit breaker check", (Throwable)e);
                    assert (false) : e;
                }
                return;
            }
            breaker.addWithoutBreaking(-1L);
            logger.debug("attempting to join {} with {}", (Object)destination, (Object)joinRequest);
            pendingJoinInfo.message = PENDING_JOIN_CONNECTING;
            this.transportService.connectToNode(destination, new ActionListener<Releasable>(){

                @Override
                public void onResponse(final Releasable connectionReference) {
                    logger.trace("acquired connection for joining join {} with {}", (Object)destination, (Object)joinRequest);
                    JoinHelper.this.registerConnection(destination, connectionReference);
                    pendingJoinInfo.message = JoinHelper.PENDING_JOIN_WAITING_APPLIER;
                    JoinHelper.this.clusterApplier.onNewClusterState("joining " + destination.descriptionWithoutAttributes(), () -> null, new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void unused) {
                            assert (ThreadPool.assertCurrentThreadPool("clusterApplierService#updateTask"));
                            pendingJoinInfo.message = JoinHelper.PENDING_JOIN_WAITING_RESPONSE;
                            JoinHelper.this.transportService.sendRequest(destination, JoinHelper.JOIN_ACTION_NAME, (TransportRequest)joinRequest, TransportRequestOptions.of(null, TransportRequestOptions.Type.PING), new TransportResponseHandler.Empty(){

                                @Override
                                public Executor executor() {
                                    return TransportResponseHandler.TRANSPORT_WORKER;
                                }

                                @Override
                                public void handleResponse() {
                                    pendingJoinInfo.message = JoinHelper.PENDING_JOIN_WAITING_STATE;
                                    JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                                    logger.debug("successfully joined {} with {}", (Object)destination, (Object)joinRequest);
                                    JoinHelper.this.lastFailedJoinAttempt.set(null);
                                }

                                @Override
                                public void handleException(TransportException exp) {
                                    this.cleanUpOnFailure(exp);
                                }
                            });
                        }

                        @Override
                        public void onFailure(Exception e) {
                            assert (false) : e;
                            this.cleanUpOnFailure(new TransportException(e));
                        }

                        private void cleanUpOnFailure(TransportException exp) {
                            pendingJoinInfo.message = JoinHelper.PENDING_JOIN_FAILED;
                            JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                            FailedJoinAttempt attempt = new FailedJoinAttempt(destination, joinRequest, exp);
                            attempt.logNow();
                            JoinHelper.this.lastFailedJoinAttempt.set(attempt);
                            JoinHelper.this.unregisterAndReleaseConnection(destination, connectionReference);
                        }
                    });
                }

                @Override
                public void onFailure(Exception e) {
                    pendingJoinInfo.message = JoinHelper.PENDING_JOIN_CONNECT_FAILED;
                    JoinHelper.this.pendingOutgoingJoins.remove(dedupKey);
                    FailedJoinAttempt attempt = new FailedJoinAttempt(destination, joinRequest, new ConnectTransportException(destination, "failed to acquire connection", e));
                    attempt.logNow();
                    JoinHelper.this.lastFailedJoinAttempt.set(attempt);
                }
            });
        } else {
            logger.debug("already attempting to join {} with request {}, not sending request", (Object)destination, (Object)joinRequest);
        }
    }

    void sendStartJoinRequest(final StartJoinRequest startJoinRequest, final DiscoveryNode destination) {
        assert (startJoinRequest.getMasterCandidateNode().isMasterNode()) : "sending start-join request for master-ineligible " + String.valueOf(startJoinRequest.getMasterCandidateNode());
        this.transportService.sendRequest(destination, START_JOIN_ACTION_NAME, startJoinRequest, new TransportResponseHandler.Empty(){

            @Override
            public Executor executor() {
                return TransportResponseHandler.TRANSPORT_WORKER;
            }

            @Override
            public void handleResponse() {
                logger.debug("successful response to {} from {}", (Object)startJoinRequest, (Object)destination);
            }

            @Override
            public void handleException(TransportException exp) {
                logger.debug(() -> Strings.format((String)"failure in response to %s from %s", (Object[])new Object[]{startJoinRequest, destination}), (Throwable)exp);
            }
        });
    }

    List<JoinStatus> getInFlightJoinStatuses() {
        long currentTime = this.transportService.getThreadPool().relativeTimeInMillis();
        ArrayList<JoinStatus> result = new ArrayList<JoinStatus>(this.pendingOutgoingJoins.size());
        long maxTerm = Long.MIN_VALUE;
        for (Map.Entry<Tuple<DiscoveryNode, JoinRequest>, PendingJoinInfo> entry : this.pendingOutgoingJoins.entrySet()) {
            Tuple<DiscoveryNode, JoinRequest> nodeAndJoinRequest = entry.getKey();
            long term = ((JoinRequest)nodeAndJoinRequest.v2()).getTerm();
            if (maxTerm < term) {
                result.clear();
                maxTerm = term;
            }
            if (term != maxTerm) continue;
            PendingJoinInfo pendingJoinInfo = entry.getValue();
            result.add(new JoinStatus((DiscoveryNode)nodeAndJoinRequest.v1(), term, pendingJoinInfo.message, TimeValue.timeValueMillis((long)(currentTime - pendingJoinInfo.startTimeMillis))));
        }
        return result;
    }

    static class FailedJoinAttempt {
        private final DiscoveryNode destination;
        private final JoinRequest joinRequest;
        private final ElasticsearchException exception;
        private final long timestamp;

        FailedJoinAttempt(DiscoveryNode destination, JoinRequest joinRequest, ElasticsearchException exception) {
            this.destination = destination;
            this.joinRequest = joinRequest;
            this.exception = exception;
            this.timestamp = System.nanoTime();
        }

        void logNow() {
            logger.log(FailedJoinAttempt.getLogLevel(this.exception), () -> Strings.format((String)"failed to join %s with %s", (Object[])new Object[]{this.destination, this.joinRequest}), (Throwable)this.exception);
        }

        static Level getLogLevel(ElasticsearchException e) {
            Exception causeException;
            Throwable cause = e.unwrapCause();
            if (cause instanceof CoordinationStateRejectedException || cause instanceof CircuitBreakingException || cause instanceof Exception && MasterService.isPublishFailureException(causeException = (Exception)cause)) {
                return Level.DEBUG;
            }
            return Level.INFO;
        }

        void logWarnWithTimestamp() {
            logger.warn(() -> Strings.format((String)"last failed join attempt was %s ago, failed to join %s with %s", (Object[])new Object[]{TimeValue.timeValueMillis((long)TimeValue.nsecToMSec((long)(System.nanoTime() - this.timestamp))), this.destination, this.joinRequest}), (Throwable)this.exception);
        }
    }

    private static class PendingJoinInfo {
        final long startTimeMillis;
        volatile String message = "initializing";

        PendingJoinInfo(long startTimeMillis) {
            this.startTimeMillis = startTimeMillis;
        }
    }

    static class JoinPingRequest
    extends TransportRequest {
        JoinPingRequest() {
        }

        JoinPingRequest(StreamInput in) throws IOException {
            super(in);
        }
    }

    class CandidateJoinAccumulator
    implements JoinAccumulator {
        private final Map<DiscoveryNode, JoinInformation> joinRequestAccumulator = new HashMap<DiscoveryNode, JoinInformation>();
        boolean closed;

        CandidateJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, CompatibilityVersions compatibilityVersions, Set<String> features, ActionListener<Void> joinListener) {
            assert (!this.closed) : "CandidateJoinAccumulator closed";
            JoinInformation prev = this.joinRequestAccumulator.put(sender, new JoinInformation(compatibilityVersions, features, joinListener));
            if (prev != null) {
                prev.listener().onFailure(new CoordinationStateRejectedException("received a newer join from " + String.valueOf(sender), new Object[0]));
            }
        }

        @Override
        public void close(Coordinator.Mode newMode) {
            assert (!this.closed) : "CandidateJoinAccumulator closed";
            this.closed = true;
            if (newMode == Coordinator.Mode.LEADER) {
                final long joiningTerm = JoinHelper.this.currentTermSupplier.getAsLong();
                final JoinTask joinTask = JoinTask.completingElection(this.joinRequestAccumulator.entrySet().stream().map(entry -> {
                    DiscoveryNode discoveryNode = (DiscoveryNode)entry.getKey();
                    JoinInformation data = (JoinInformation)entry.getValue();
                    return new JoinTask.NodeJoinTask(discoveryNode, data.compatibilityVersions(), data.features(), JoinHelper.this.joinReasonService.getJoinReason(discoveryNode, Coordinator.Mode.CANDIDATE), data.listener());
                }), joiningTerm);
                JoinHelper.this.latestStoredStateSupplier.accept(new ActionListener<ClusterState>(){

                    @Override
                    public void onResponse(ClusterState latestStoredClusterState) {
                        JoinHelper.this.joinTaskQueue.submitTask("elected-as-master ([" + joinTask.nodeCount() + "] nodes joined in term " + joiningTerm + ")", joinTask.alsoRefreshState(latestStoredClusterState), null);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn(org.elasticsearch.common.Strings.format("failed to retrieve latest stored state after winning election in term [%d]", joiningTerm), (Throwable)e);
                        CandidateJoinAccumulator.this.joinRequestAccumulator.values().forEach(joinCallback -> joinCallback.listener().onFailure(e));
                    }
                }, joiningTerm);
            } else {
                assert (newMode == Coordinator.Mode.FOLLOWER) : newMode;
                this.joinRequestAccumulator.values().forEach(joinCallback -> joinCallback.listener().onFailure(new CoordinationStateRejectedException("became follower", new Object[0])));
            }
        }

        public String toString() {
            return "CandidateJoinAccumulator{" + String.valueOf(this.joinRequestAccumulator.keySet()) + ", closed=" + this.closed + "}";
        }

        private record JoinInformation(CompatibilityVersions compatibilityVersions, Set<String> features, ActionListener<Void> listener) {
        }
    }

    static class FollowerJoinAccumulator
    implements JoinAccumulator {
        FollowerJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, CompatibilityVersions compatibilityVersions, Set<String> features, ActionListener<Void> joinListener) {
            joinListener.onFailure(new CoordinationStateRejectedException("join target is a follower", new Object[0]));
        }

        public String toString() {
            return "FollowerJoinAccumulator";
        }
    }

    static class InitialJoinAccumulator
    implements JoinAccumulator {
        InitialJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, CompatibilityVersions compatibilityVersions, Set<String> features, ActionListener<Void> joinListener) {
            assert (false) : "unexpected join from " + String.valueOf(sender) + " during initialisation";
            joinListener.onFailure(new CoordinationStateRejectedException("join target is not initialised yet", new Object[0]));
        }

        public String toString() {
            return "InitialJoinAccumulator";
        }
    }

    class LeaderJoinAccumulator
    implements JoinAccumulator {
        LeaderJoinAccumulator() {
        }

        @Override
        public void handleJoinRequest(DiscoveryNode sender, CompatibilityVersions compatibilityVersions, Set<String> features, ActionListener<Void> joinListener) {
            JoinTask task = JoinTask.singleNode(sender, compatibilityVersions, features, JoinHelper.this.joinReasonService.getJoinReason(sender, Coordinator.Mode.LEADER), joinListener, JoinHelper.this.currentTermSupplier.getAsLong());
            JoinHelper.this.joinTaskQueue.submitTask("node-join", task, null);
        }

        public String toString() {
            return "LeaderJoinAccumulator";
        }
    }

    static interface JoinAccumulator {
        public void handleJoinRequest(DiscoveryNode var1, CompatibilityVersions var2, Set<String> var3, ActionListener<Void> var4);

        default public void close(Coordinator.Mode newMode) {
        }
    }
}

