/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.synonyms;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.synonyms.PutSynonymsAction;
import org.elasticsearch.action.synonyms.SynonymUpdateResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.synonyms.SynonymsManagementAPIService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class TransportPutSynonymsAction
extends HandledTransportAction<PutSynonymsAction.Request, SynonymUpdateResponse> {
    private final SynonymsManagementAPIService synonymsManagementAPIService;

    @Inject
    public TransportPutSynonymsAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/synonyms/put", transportService, actionFilters, PutSynonymsAction.Request::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.synonymsManagementAPIService = new SynonymsManagementAPIService(client);
    }

    @Override
    protected void doExecute(Task task, PutSynonymsAction.Request request, ActionListener<SynonymUpdateResponse> listener) {
        this.synonymsManagementAPIService.putSynonymsSet(request.synonymsSetId(), request.synonymRules(), listener.map(SynonymUpdateResponse::new));
    }
}

