/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import org.elasticsearch.action.ActionRequestLazyBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.core.TimeValue;

public abstract class ReplicationRequestBuilder<Request extends ReplicationRequest<Request>, Response extends ActionResponse, RequestBuilder extends ReplicationRequestBuilder<Request, Response, RequestBuilder>>
extends ActionRequestLazyBuilder<Request, Response> {
    private String index;
    private TimeValue timeout;
    private ActiveShardCount waitForActiveShards;

    protected ReplicationRequestBuilder(ElasticsearchClient client, ActionType<Response> action) {
        super(client, action);
    }

    public RequestBuilder setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return (RequestBuilder)this;
    }

    public RequestBuilder setIndex(String index) {
        this.index = index;
        return (RequestBuilder)this;
    }

    public String getIndex() {
        return this.index;
    }

    public RequestBuilder setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.waitForActiveShards = waitForActiveShards;
        return (RequestBuilder)this;
    }

    public RequestBuilder setWaitForActiveShards(int waitForActiveShards) {
        return this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    protected void apply(Request request) {
        if (this.index != null) {
            ((ReplicationRequest)request).index(this.index);
        }
        if (this.timeout != null) {
            ((ReplicationRequest)request).timeout(this.timeout);
        }
        if (this.waitForActiveShards != null) {
            ((ReplicationRequest)request).waitForActiveShards(this.waitForActiveShards);
        }
    }
}

