/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.common.util.concurrent.UncategorizedExecutionException;

public final class ListenableActionFuture<T>
extends SubscribableListener<T> {
    public T actionResult() {
        try {
            return super.rawResult();
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    @Override
    protected RuntimeException wrapException(Exception exception) {
        if (exception instanceof ElasticsearchException) {
            ElasticsearchException elasticsearchException = (ElasticsearchException)exception;
            Throwable rootCause = ExceptionsHelper.unwrapCause(elasticsearchException);
            if (rootCause instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)rootCause;
                return runtimeException;
            }
            return new UncategorizedExecutionException("Failed execution", rootCause);
        }
        return ListenableActionFuture.wrapAsExecutionException(exception);
    }
}

