/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;

public class WriteAckDelay
implements Consumer<Runnable> {
    public static final Setting<TimeValue> WRITE_ACK_DELAY_INTERVAL = Setting.timeSetting("indices.write_ack_delay_interval", TimeValue.ZERO, Setting.Property.NodeScope);
    public static final Setting<TimeValue> WRITE_ACK_DELAY_RANDOMNESS_BOUND = Setting.timeSetting("indices.write_ack_delay_randomness_bound", TimeValue.timeValueMillis((long)70L), Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(WriteAckDelay.class);
    private final ThreadPool threadPool;
    private final ConcurrentLinkedQueue<Runnable> writeCallbacks = new ConcurrentLinkedQueue();
    private final TimeValue writeDelayInterval;
    private final long writeDelayRandomnessBoundMillis;

    public WriteAckDelay(long writeDelayIntervalNanos, long writeDelayRandomnessBoundMillis, ThreadPool threadPool) {
        this.writeDelayInterval = TimeValue.timeValueNanos((long)writeDelayIntervalNanos);
        this.writeDelayRandomnessBoundMillis = writeDelayRandomnessBoundMillis;
        this.threadPool = threadPool;
        this.threadPool.scheduleWithFixedDelay(new ScheduleTask(), TimeValue.timeValueNanos((long)writeDelayIntervalNanos), this.threadPool.generic());
    }

    @Override
    public void accept(Runnable runnable) {
        this.writeCallbacks.add(runnable);
    }

    public static WriteAckDelay create(Settings settings, ThreadPool threadPool) {
        if (WRITE_ACK_DELAY_INTERVAL.get(settings).nanos() <= 0L) {
            return null;
        }
        return new WriteAckDelay(WRITE_ACK_DELAY_INTERVAL.get(settings).nanos(), WRITE_ACK_DELAY_RANDOMNESS_BOUND.get(settings).millis(), threadPool);
    }

    private class ScheduleTask
    implements Runnable {
        private ScheduleTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ConcurrentLinkedQueue<Runnable> concurrentLinkedQueue = WriteAckDelay.this.writeCallbacks;
            synchronized (concurrentLinkedQueue) {
                Runnable task;
                while ((task = WriteAckDelay.this.writeCallbacks.poll()) != null) {
                    tasks.add(task);
                }
            }
            long delayRandomness = Randomness.get().nextLong(WriteAckDelay.this.writeDelayRandomnessBoundMillis) + 1L;
            TimeValue randomDelay = TimeValue.timeValueMillis((long)delayRandomness);
            logger.trace("scheduling write ack completion task [{} writes; {} interval; {} random delay]", (Object)tasks.size(), (Object)WriteAckDelay.this.writeDelayInterval, (Object)randomDelay);
            WriteAckDelay.this.threadPool.schedule(new CompletionTask(tasks), randomDelay, WriteAckDelay.this.threadPool.generic());
        }
    }

    private record CompletionTask(ArrayList<Runnable> tasks) implements Runnable
    {
        @Override
        public void run() {
            logger.trace("completing {} writes", (Object)this.tasks.size());
            for (Runnable task : this.tasks) {
                try {
                    task.run();
                }
                catch (Exception e) {
                    logger.error("unexpected exception while completing write task after delay", (Throwable)e);
                }
            }
        }
    }
}

