/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.get;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;

public class GetSettingsResponse
extends ActionResponse
implements ChunkedToXContentObject {
    private final Map<String, Settings> indexToSettings;
    private final Map<String, Settings> indexToDefaultSettings;

    public GetSettingsResponse(Map<String, Settings> indexToSettings, Map<String, Settings> indexToDefaultSettings) {
        this.indexToSettings = indexToSettings;
        this.indexToDefaultSettings = indexToDefaultSettings;
    }

    public GetSettingsResponse(StreamInput in) throws IOException {
        super(in);
        this.indexToSettings = in.readImmutableMap(Settings::readSettingsFromStream);
        this.indexToDefaultSettings = in.readImmutableMap(Settings::readSettingsFromStream);
    }

    public Map<String, Settings> getIndexToSettings() {
        return this.indexToSettings;
    }

    public Map<String, Settings> getIndexToDefaultSettings() {
        return this.indexToDefaultSettings;
    }

    public String getSetting(String index, String setting) {
        Settings settings = this.indexToSettings.get(index);
        if (setting != null) {
            if (settings != null && settings.hasValue(setting)) {
                return settings.get(setting);
            }
            Settings defaultSettings = this.indexToDefaultSettings.get(index);
            if (defaultSettings != null) {
                return defaultSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.indexToSettings, StreamOutput::writeWriteable);
        out.writeMap(this.indexToDefaultSettings, StreamOutput::writeWriteable);
    }

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XContentBuilder builder = new XContentBuilder(JsonXContent.jsonXContent, (OutputStream)baos);
            Iterator<ToXContent> iterator = this.toXContentChunked(false);
            while (iterator.hasNext()) {
                iterator.next().toXContent(builder, ToXContent.EMPTY_PARAMS);
            }
            return Strings.toString(builder);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        boolean omitEmptySettings = this.indexToDefaultSettings.isEmpty();
        return this.toXContentChunked(omitEmptySettings);
    }

    private Iterator<ToXContent> toXContentChunked(boolean omitEmptySettings) {
        boolean indexToDefaultSettingsEmpty = this.indexToDefaultSettings.isEmpty();
        return Iterators.concat(Iterators.single((builder, params) -> builder.startObject()), this.getIndexToSettings().entrySet().stream().filter(entry -> !omitEmptySettings || !((Settings)entry.getValue()).isEmpty()).map(entry -> (builder, params) -> {
            builder.startObject((String)entry.getKey());
            builder.startObject("settings");
            ((Settings)entry.getValue()).toXContent(builder, params);
            builder.endObject();
            if (!indexToDefaultSettingsEmpty) {
                builder.startObject("defaults");
                this.indexToDefaultSettings.get(entry.getKey()).toXContent(builder, params);
                builder.endObject();
            }
            return builder.endObject();
        }).iterator(), Iterators.single((builder, params) -> builder.endObject()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetSettingsResponse that = (GetSettingsResponse)o;
        return Objects.equals(this.indexToSettings, that.indexToSettings) && Objects.equals(this.indexToDefaultSettings, that.indexToDefaultSettings);
    }

    public int hashCode() {
        return Objects.hash(this.indexToSettings, this.indexToDefaultSettings);
    }
}

