/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.features;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class NodeFeatures
extends BaseNodeResponse {
    private final Set<String> features;

    public NodeFeatures(StreamInput in) throws IOException {
        super(in);
        this.features = in.readCollectionAsImmutableSet(StreamInput::readString);
    }

    public NodeFeatures(Set<String> features, DiscoveryNode node) {
        super(node);
        this.features = Set.copyOf(features);
    }

    public Set<String> nodeFeatures() {
        return this.features;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.features, StreamOutput::writeString);
    }
}

