/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.snapshotbasedrecoveries;

import java.util.Optional;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.recovery.plan.RecoveryPlannerService;
import org.elasticsearch.indices.recovery.plan.ShardSnapshotsService;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.RecoveryPlannerPlugin;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.snapshotbasedrecoveries.recovery.plan.SnapshotsRecoveryPlannerService;

public class SnapshotBasedRecoveriesPlugin
extends Plugin
implements RecoveryPlannerPlugin {
    public static final LicensedFeature.Momentary SNAPSHOT_BASED_RECOVERIES_FEATURE = LicensedFeature.momentary(null, (String)"snapshot-based-recoveries", (License.OperationMode)License.OperationMode.ENTERPRISE);
    private final Settings settings;

    public SnapshotBasedRecoveriesPlugin(Settings settings) {
        this.settings = settings;
    }

    public Optional<RecoveryPlannerService> createRecoveryPlannerService(ShardSnapshotsService shardSnapshotsService) {
        if (DiscoveryNode.isStateless((Settings)this.settings)) {
            return Optional.empty();
        }
        return Optional.of(new SnapshotsRecoveryPlannerService(shardSnapshotsService, this::isLicenseEnabled));
    }

    public boolean isLicenseEnabled() {
        return SNAPSHOT_BASED_RECOVERIES_FEATURE.check(XPackPlugin.getSharedLicenseState());
    }
}

