/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash.action;

import java.util.concurrent.Executor;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.logstash.action.DeletePipelineRequest;
import org.elasticsearch.xpack.logstash.action.DeletePipelineResponse;

public class TransportDeletePipelineAction
extends HandledTransportAction<DeletePipelineRequest, DeletePipelineResponse> {
    private final Client client;

    @Inject
    public TransportDeletePipelineAction(TransportService transportService, ActionFilters actionFilters, Client client) {
        super("cluster:admin/logstash/pipeline/delete", transportService, actionFilters, DeletePipelineRequest::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = new OriginSettingClient(client, "logstash_management");
    }

    protected void doExecute(Task task, DeletePipelineRequest request, ActionListener<DeletePipelineResponse> listener) {
        this.client.prepareDelete(".logstash", request.id()).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).execute(ActionListener.wrap(deleteResponse -> listener.onResponse((Object)new DeletePipelineResponse(deleteResponse.getResult() == DocWriteResponse.Result.DELETED)), e -> TransportDeletePipelineAction.handleFailure(e, listener)));
    }

    private static void handleFailure(Exception e, ActionListener<DeletePipelineResponse> listener) {
        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
        if (cause instanceof IndexNotFoundException) {
            listener.onResponse((Object)new DeletePipelineResponse(false));
        } else {
            listener.onFailure(e);
        }
    }
}

